/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.AchievementEntityCreator;
import com.google.android.gms.internal.zzmo;

public final class AchievementEntity
implements SafeParcelable,
Achievement {
    public static final Parcelable.Creator<AchievementEntity> CREATOR = new AchievementEntityCreator();
    private final int mVersionCode;
    private final String zzauq;
    private final int zzWJ;
    private final String mName;
    private final String zzaqZ;
    private final Uri zzaur;
    private final String zzaus;
    private final Uri zzaut;
    private final String zzauu;
    private final int zzauv;
    private final String zzauw;
    private final PlayerEntity zzaux;
    private final int mState;
    private final int zzauy;
    private final String zzauz;
    private final long zzauA;
    private final long zzauB;

    public AchievementEntity(Achievement achievement) {
        this.mVersionCode = 1;
        this.zzauq = achievement.getAchievementId();
        this.zzWJ = achievement.getType();
        this.mName = achievement.getName();
        this.zzaqZ = achievement.getDescription();
        this.zzaur = achievement.getUnlockedImageUri();
        this.zzaus = achievement.getUnlockedImageUrl();
        this.zzaut = achievement.getRevealedImageUri();
        this.zzauu = achievement.getRevealedImageUrl();
        this.zzaux = (PlayerEntity)achievement.getPlayer().freeze();
        this.mState = achievement.getState();
        this.zzauA = achievement.getLastUpdatedTimestamp();
        this.zzauB = achievement.getXpValue();
        if (achievement.getType() == 1) {
            this.zzauv = achievement.getTotalSteps();
            this.zzauw = achievement.getFormattedTotalSteps();
            this.zzauy = achievement.getCurrentSteps();
            this.zzauz = achievement.getFormattedCurrentSteps();
        } else {
            this.zzauv = 0;
            this.zzauw = null;
            this.zzauy = 0;
            this.zzauz = null;
        }
        zzb.zzs((Object)this.zzauq);
        zzb.zzs((Object)this.zzaqZ);
    }

    AchievementEntity(int versionCode, String achievementId, int type, String name, String description, Uri unlockedImageUri, String unlockedImageUrl, Uri revealedImageUri, String revealedImageUrl, int totalSteps, String formattedTotalSteps, PlayerEntity player, int state, int currentSteps, String formattedCurrentSteps, long lastUpdatedTimestamp, long xpValue) {
        this.mVersionCode = versionCode;
        this.zzauq = achievementId;
        this.zzWJ = type;
        this.mName = name;
        this.zzaqZ = description;
        this.zzaur = unlockedImageUri;
        this.zzaus = unlockedImageUrl;
        this.zzaut = revealedImageUri;
        this.zzauu = revealedImageUrl;
        this.zzauv = totalSteps;
        this.zzauw = formattedTotalSteps;
        this.zzaux = player;
        this.mState = state;
        this.zzauy = currentSteps;
        this.zzauz = formattedCurrentSteps;
        this.zzauA = lastUpdatedTimestamp;
        this.zzauB = xpValue;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getAchievementId() {
        return this.zzauq;
    }

    @Override
    public int getType() {
        return this.zzWJ;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        zzmo.zzb((String)this.mName, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDescription() {
        return this.zzaqZ;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzmo.zzb((String)this.zzaqZ, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getUnlockedImageUri() {
        return this.zzaur;
    }

    @Override
    public String getUnlockedImageUrl() {
        return this.zzaus;
    }

    @Override
    public Uri getRevealedImageUri() {
        return this.zzaut;
    }

    @Override
    public String getRevealedImageUrl() {
        return this.zzauu;
    }

    public int zztK() {
        return this.zzauv;
    }

    @Override
    public int getTotalSteps() {
        zzb.zzZ((this.getType() == 1 ? 1 : 0) != 0);
        return this.zztK();
    }

    @Override
    public String getFormattedTotalSteps() {
        zzb.zzZ((this.getType() == 1 ? 1 : 0) != 0);
        return this.zztL();
    }

    public String zztL() {
        return this.zzauw;
    }

    @Override
    public void getFormattedTotalSteps(CharArrayBuffer dataOut) {
        zzb.zzZ((this.getType() == 1 ? 1 : 0) != 0);
        zzmo.zzb((String)this.zzauw, (CharArrayBuffer)dataOut);
    }

    @Override
    public Player getPlayer() {
        return this.zzaux;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getCurrentSteps() {
        zzb.zzZ((this.getType() == 1 ? 1 : 0) != 0);
        return this.zztM();
    }

    public int zztM() {
        return this.zzauy;
    }

    @Override
    public String getFormattedCurrentSteps() {
        zzb.zzZ((this.getType() == 1 ? 1 : 0) != 0);
        return this.zztN();
    }

    public String zztN() {
        return this.zzauz;
    }

    @Override
    public void getFormattedCurrentSteps(CharArrayBuffer dataOut) {
        zzb.zzZ((this.getType() == 1 ? 1 : 0) != 0);
        zzmo.zzb((String)this.zzauz, (CharArrayBuffer)dataOut);
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzauA;
    }

    @Override
    public long getXpValue() {
        return this.zzauB;
    }

    public Achievement freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return AchievementEntity.zza(this);
    }

    static int zza(Achievement achievement) {
        int n = 0;
        int n2 = 0;
        if (achievement.getType() == 1) {
            n = achievement.getCurrentSteps();
            n2 = achievement.getTotalSteps();
        }
        return zzw.hashCode((Object[])new Object[]{achievement.getAchievementId(), achievement.getName(), achievement.getType(), achievement.getDescription(), achievement.getXpValue(), achievement.getState(), achievement.getLastUpdatedTimestamp(), achievement.getPlayer(), n, n2});
    }

    public boolean equals(Object obj) {
        return AchievementEntity.zza(this, obj);
    }

    static boolean zza(Achievement achievement, Object object) {
        if (!(object instanceof Achievement)) {
            return false;
        }
        if (achievement == object) {
            return true;
        }
        Achievement achievement2 = (Achievement)object;
        boolean bl = true;
        boolean bl2 = true;
        if (achievement.getType() == 1) {
            bl = zzw.equal((Object)achievement2.getCurrentSteps(), (Object)achievement.getCurrentSteps());
            bl2 = zzw.equal((Object)achievement2.getTotalSteps(), (Object)achievement.getTotalSteps());
        }
        return zzw.equal((Object)achievement2.getAchievementId(), (Object)achievement.getAchievementId()) && zzw.equal((Object)achievement2.getName(), (Object)achievement.getName()) && zzw.equal((Object)achievement2.getType(), (Object)achievement.getType()) && zzw.equal((Object)achievement2.getDescription(), (Object)achievement.getDescription()) && zzw.equal((Object)achievement2.getXpValue(), (Object)achievement.getXpValue()) && zzw.equal((Object)achievement2.getState(), (Object)achievement.getState()) && zzw.equal((Object)achievement2.getLastUpdatedTimestamp(), (Object)achievement.getLastUpdatedTimestamp()) && zzw.equal((Object)achievement2.getPlayer(), (Object)achievement.getPlayer()) && bl && bl2;
    }

    public String toString() {
        return AchievementEntity.zzb(this);
    }

    static String zzb(Achievement achievement) {
        zzw.zza zza2 = zzw.zzv((Object)achievement).zzg("Id", (Object)achievement.getAchievementId()).zzg("Type", (Object)achievement.getType()).zzg("Name", (Object)achievement.getName()).zzg("Description", (Object)achievement.getDescription()).zzg("Player", (Object)achievement.getPlayer()).zzg("State", (Object)achievement.getState());
        if (achievement.getType() == 1) {
            zza2.zzg("CurrentSteps", (Object)achievement.getCurrentSteps());
            zza2.zzg("TotalSteps", (Object)achievement.getTotalSteps());
        }
        return zza2.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AchievementEntityCreator.zza(this, dest, flags);
    }
}

