/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.api;

import android.content.Intent;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.internal.zzlb;

public final class AchievementsImpl
implements Achievements {
    @Override
    public Intent getAchievementsIntent(GoogleApiClient apiClient) {
        return Games.zzc(apiClient).zzuC();
    }

    @Override
    public PendingResult<Achievements.LoadAchievementsResult> load(GoogleApiClient apiClient, final boolean forceReload) {
        return apiClient.zza((zzlb.zza)new LoadImpl(apiClient){

            public void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzc((zzlb.zzb<Achievements.LoadAchievementsResult>)this, forceReload);
            }
        });
    }

    @Override
    public void reveal(GoogleApiClient apiClient, final String id) {
        apiClient.zzb((zzlb.zza)new UpdateImpl(id, apiClient){

            public void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zzlb.zzb<Achievements.UpdateAchievementResult>)null, id);
            }
        });
    }

    @Override
    public PendingResult<Achievements.UpdateAchievementResult> revealImmediate(GoogleApiClient apiClient, final String id) {
        return apiClient.zzb((zzlb.zza)new UpdateImpl(id, apiClient){

            public void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zzlb.zzb<Achievements.UpdateAchievementResult>)this, id);
            }
        });
    }

    @Override
    public void unlock(GoogleApiClient apiClient, final String id) {
        apiClient.zzb((zzlb.zza)new UpdateImpl(id, apiClient){

            public void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzb(null, id);
            }
        });
    }

    @Override
    public PendingResult<Achievements.UpdateAchievementResult> unlockImmediate(GoogleApiClient apiClient, final String id) {
        return apiClient.zzb((zzlb.zza)new UpdateImpl(id, apiClient){

            public void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzb((zzlb.zzb<Achievements.UpdateAchievementResult>)this, id);
            }
        });
    }

    @Override
    public void increment(GoogleApiClient apiClient, final String id, final int numSteps) {
        apiClient.zzb((zzlb.zza)new UpdateImpl(id, apiClient){

            public void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza(null, id, numSteps);
            }
        });
    }

    @Override
    public PendingResult<Achievements.UpdateAchievementResult> incrementImmediate(GoogleApiClient apiClient, final String id, final int numSteps) {
        return apiClient.zzb((zzlb.zza)new UpdateImpl(id, apiClient){

            public void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zzlb.zzb<Achievements.UpdateAchievementResult>)this, id, numSteps);
            }
        });
    }

    @Override
    public void setSteps(GoogleApiClient apiClient, final String id, final int numSteps) {
        apiClient.zzb((zzlb.zza)new UpdateImpl(id, apiClient){

            public void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzb(null, id, numSteps);
            }
        });
    }

    @Override
    public PendingResult<Achievements.UpdateAchievementResult> setStepsImmediate(GoogleApiClient apiClient, final String id, final int numSteps) {
        return apiClient.zzb((zzlb.zza)new UpdateImpl(id, apiClient){

            public void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzb((zzlb.zzb<Achievements.UpdateAchievementResult>)this, id, numSteps);
            }
        });
    }

    private static abstract class UpdateImpl
    extends Games.BaseGamesApiMethodImpl<Achievements.UpdateAchievementResult> {
        private final String zzwN;

        public UpdateImpl(String id, GoogleApiClient googleApiClient) {
            super(googleApiClient);
            this.zzwN = id;
        }

        public Achievements.UpdateAchievementResult zzW(final Status status) {
            return new Achievements.UpdateAchievementResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public String getAchievementId() {
                    return UpdateImpl.this.zzwN;
                }
            };
        }

        public /* synthetic */ Result zzb(Status status) {
            return this.zzW(status);
        }
    }

    private static abstract class LoadImpl
    extends Games.BaseGamesApiMethodImpl<Achievements.LoadAchievementsResult> {
        private LoadImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Achievements.LoadAchievementsResult zzV(final Status status) {
            return new Achievements.LoadAchievementsResult(){

                public Status getStatus() {
                    return status;
                }

                public void release() {
                }

                @Override
                public AchievementBuffer getAchievements() {
                    return new AchievementBuffer(DataHolder.zzbu((int)14));
                }
            };
        }

        public /* synthetic */ Result zzb(Status status) {
            return this.zzV(status);
        }
    }
}

