/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.game;

import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.game.GameBadge;
import com.google.android.gms.games.internal.game.GameBadgeEntityCreator;

public final class GameBadgeEntity
extends GamesDowngradeableSafeParcel
implements GameBadge {
    public static final GameBadgeEntityCreator CREATOR = new GameBadgeEntityCreatorCompat();
    private final int mVersionCode;
    private int zzWJ;
    private String zzajf;
    private String zzaqZ;
    private Uri zzatu;

    public GameBadgeEntity(GameBadge gameBadge) {
        this.mVersionCode = 1;
        this.zzWJ = gameBadge.getType();
        this.zzajf = gameBadge.getTitle();
        this.zzaqZ = gameBadge.getDescription();
        this.zzatu = gameBadge.getIconImageUri();
    }

    GameBadgeEntity(int versionCode, int type, String title, String description, Uri iconImageUri) {
        this.mVersionCode = versionCode;
        this.zzWJ = type;
        this.zzajf = title;
        this.zzaqZ = description;
        this.zzatu = iconImageUri;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public int getType() {
        return this.zzWJ;
    }

    @Override
    public String getTitle() {
        return this.zzajf;
    }

    @Override
    public String getDescription() {
        return this.zzaqZ;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzatu;
    }

    public GameBadge zzvk() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameBadgeEntity.zza(this);
    }

    static int zza(GameBadge gameBadge) {
        return zzw.hashCode((Object[])new Object[]{gameBadge.getType(), gameBadge.getTitle(), gameBadge.getDescription(), gameBadge.getIconImageUri()});
    }

    public boolean equals(Object obj) {
        return GameBadgeEntity.zza(this, obj);
    }

    static boolean zza(GameBadge gameBadge, Object object) {
        if (!(object instanceof GameBadge)) {
            return false;
        }
        if (gameBadge == object) {
            return true;
        }
        GameBadge gameBadge2 = (GameBadge)object;
        return zzw.equal((Object)gameBadge2.getType(), (Object)gameBadge.getTitle()) && zzw.equal((Object)gameBadge2.getDescription(), (Object)gameBadge.getIconImageUri());
    }

    public String toString() {
        return GameBadgeEntity.zzb(this);
    }

    static String zzb(GameBadge gameBadge) {
        return zzw.zzv((Object)gameBadge).zzg("Type", (Object)gameBadge.getType()).zzg("Title", (Object)gameBadge.getTitle()).zzg("Description", (Object)gameBadge.getDescription()).zzg("IconImageUri", (Object)gameBadge.getIconImageUri()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzoU()) {
            GameBadgeEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeInt(this.zzWJ);
            dest.writeString(this.zzajf);
            dest.writeString(this.zzaqZ);
            dest.writeString(this.zzatu == null ? null : this.zzatu.toString());
        }
    }

    public /* synthetic */ Object freeze() {
        return this.zzvk();
    }

    static final class GameBadgeEntityCreatorCompat
    extends GameBadgeEntityCreator {
        GameBadgeEntityCreatorCompat() {
        }

        @Override
        public GameBadgeEntity zzea(Parcel parcel) {
            boolean bl = GameBadgeEntity.zzd(GameBadgeEntity.zzoT());
            if (bl || GameBadgeEntity.zzck((String)GameBadgeEntity.class.getCanonicalName())) {
                return super.zzea(parcel);
            }
            int n = parcel.readInt();
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            return new GameBadgeEntity(1, n, string, string2, uri);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzea(x0);
        }
    }
}

