/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerRef;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;

public final class LeaderboardScoreRef
extends zzc
implements LeaderboardScore {
    private final PlayerRef zzaAk;

    LeaderboardScoreRef(DataHolder holder, int dataRow) {
        super(holder, dataRow);
        this.zzaAk = new PlayerRef(holder, dataRow);
    }

    @Override
    public long getRank() {
        return this.getLong("rank");
    }

    @Override
    public String getDisplayRank() {
        return this.getString("display_rank");
    }

    @Override
    public void getDisplayRank(CharArrayBuffer dataOut) {
        this.zza("display_rank", dataOut);
    }

    @Override
    public String getDisplayScore() {
        return this.getString("display_score");
    }

    @Override
    public void getDisplayScore(CharArrayBuffer dataOut) {
        this.zza("display_score", dataOut);
    }

    @Override
    public long getRawScore() {
        return this.getLong("raw_score");
    }

    @Override
    public long getTimestampMillis() {
        return this.getLong("achieved_timestamp");
    }

    @Override
    public String getScoreHolderDisplayName() {
        if (this.zzcg("external_player_id")) {
            return this.getString("default_display_name");
        }
        return this.zzaAk.getDisplayName();
    }

    @Override
    public void getScoreHolderDisplayName(CharArrayBuffer dataOut) {
        if (this.zzcg("external_player_id")) {
            this.zza("default_display_name", dataOut);
            return;
        }
        this.zzaAk.getDisplayName(dataOut);
    }

    @Override
    public Uri getScoreHolderIconImageUri() {
        if (this.zzcg("external_player_id")) {
            return this.zzcf("default_display_image_uri");
        }
        return this.zzaAk.getIconImageUri();
    }

    @Override
    public String getScoreHolderIconImageUrl() {
        if (this.zzcg("external_player_id")) {
            return this.getString("default_display_image_url");
        }
        return this.zzaAk.getIconImageUrl();
    }

    @Override
    public Uri getScoreHolderHiResImageUri() {
        if (this.zzcg("external_player_id")) {
            return null;
        }
        return this.zzaAk.getHiResImageUri();
    }

    @Override
    public String getScoreHolderHiResImageUrl() {
        if (this.zzcg("external_player_id")) {
            return null;
        }
        return this.zzaAk.getHiResImageUrl();
    }

    @Override
    public Player getScoreHolder() {
        if (this.zzcg("external_player_id")) {
            return null;
        }
        return this.zzaAk;
    }

    @Override
    public String getScoreTag() {
        return this.getString("score_tag");
    }

    public LeaderboardScore zzvI() {
        return new LeaderboardScoreEntity(this);
    }

    public int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    public boolean equals(Object obj) {
        return LeaderboardScoreEntity.zza(this, obj);
    }

    public String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    public /* synthetic */ Object freeze() {
        return this.zzvI();
    }
}

