/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerRef;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.ParticipantResult;

public final class ParticipantRef
extends zzc
implements Participant {
    private final PlayerRef zzaAI;

    public ParticipantRef(DataHolder holder, int dataRow) {
        super(holder, dataRow);
        this.zzaAI = new PlayerRef(holder, dataRow);
    }

    public Participant freeze() {
        return new ParticipantEntity(this);
    }

    @Override
    public int getStatus() {
        return this.getInteger("player_status");
    }

    @Override
    public String zzut() {
        return this.getString("client_address");
    }

    @Override
    public boolean isConnectedToRoom() {
        return this.getInteger("connected") > 0;
    }

    @Override
    public String getDisplayName() {
        if (this.zzcg("external_player_id")) {
            return this.getString("default_display_name");
        }
        return this.zzaAI.getDisplayName();
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        if (this.zzcg("external_player_id")) {
            this.zza("default_display_name", dataOut);
            return;
        }
        this.zzaAI.getDisplayName(dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        if (this.zzcg("external_player_id")) {
            return this.zzcf("default_display_image_uri");
        }
        return this.zzaAI.getIconImageUri();
    }

    @Override
    public String getIconImageUrl() {
        if (this.zzcg("external_player_id")) {
            return this.getString("default_display_image_url");
        }
        return this.zzaAI.getIconImageUrl();
    }

    @Override
    public Uri getHiResImageUri() {
        if (this.zzcg("external_player_id")) {
            return this.zzcf("default_display_hi_res_image_uri");
        }
        return this.zzaAI.getHiResImageUri();
    }

    @Override
    public String getHiResImageUrl() {
        if (this.zzcg("external_player_id")) {
            return this.getString("default_display_hi_res_image_url");
        }
        return this.zzaAI.getHiResImageUrl();
    }

    @Override
    public String getParticipantId() {
        return this.getString("external_participant_id");
    }

    @Override
    public Player getPlayer() {
        if (this.zzcg("external_player_id")) {
            return null;
        }
        return this.zzaAI;
    }

    @Override
    public ParticipantResult getResult() {
        if (this.zzcg("result_type")) {
            return null;
        }
        int n = this.getInteger("result_type");
        int n2 = this.getInteger("placing");
        return new ParticipantResult(this.getParticipantId(), n, n2);
    }

    @Override
    public int getCapabilities() {
        return this.getInteger("capabilities");
    }

    public int hashCode() {
        return ParticipantEntity.zza(this);
    }

    public boolean equals(Object obj) {
        return ParticipantEntity.zza(this, obj);
    }

    public String toString() {
        return ParticipantEntity.zzb(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParticipantEntity participantEntity = (ParticipantEntity)this.freeze();
        participantEntity.writeToParcel(dest, flags);
    }
}

