/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.os.Bundle;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RoomConfigImpl;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class RoomConfig {
    protected RoomConfig() {
    }

    public abstract RoomUpdateListener getRoomUpdateListener();

    public abstract String getInvitationId();

    public abstract RoomStatusUpdateListener getRoomStatusUpdateListener();

    public abstract RealTimeMessageReceivedListener getMessageReceivedListener();

    public abstract int getVariant();

    public abstract String[] getInvitedPlayerIds();

    public abstract Bundle getAutoMatchCriteria();

    public static Builder builder(RoomUpdateListener listener) {
        return new Builder(listener);
    }

    public static Bundle createAutoMatchCriteria(int minAutoMatchPlayers, int maxAutoMatchPlayers, long exclusiveBitMask) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", minAutoMatchPlayers);
        bundle.putInt("max_automatch_players", maxAutoMatchPlayers);
        bundle.putLong("exclusive_bit_mask", exclusiveBitMask);
        return bundle;
    }

    public static final class Builder {
        final RoomUpdateListener zzaAO;
        RoomStatusUpdateListener zzaAP;
        RealTimeMessageReceivedListener zzaAQ;
        String zzaAR = null;
        int zzaAD = -1;
        ArrayList<String> zzaAS = new ArrayList();
        Bundle zzaAT;

        private Builder(RoomUpdateListener updateListener) {
            this.zzaAO = (RoomUpdateListener)zzx.zzb((Object)updateListener, (Object)"Must provide a RoomUpdateListener");
        }

        public Builder setInvitationIdToAccept(String invitationId) {
            zzx.zzw((Object)invitationId);
            this.zzaAR = invitationId;
            return this;
        }

        public Builder setRoomStatusUpdateListener(RoomStatusUpdateListener listener) {
            this.zzaAP = listener;
            return this;
        }

        public Builder setMessageReceivedListener(RealTimeMessageReceivedListener listener) {
            this.zzaAQ = listener;
            return this;
        }

        public Builder addPlayersToInvite(String ... playerIds) {
            zzx.zzw((Object)playerIds);
            this.zzaAS.addAll(Arrays.asList(playerIds));
            return this;
        }

        public Builder addPlayersToInvite(ArrayList<String> playerIds) {
            zzx.zzw(playerIds);
            this.zzaAS.addAll(playerIds);
            return this;
        }

        public Builder setVariant(int variant) {
            zzx.zzb((variant == -1 || variant > 0 ? 1 : 0) != 0, (Object)"Variant must be a positive integer or Room.ROOM_VARIANT_ANY");
            this.zzaAD = variant;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle autoMatchCriteria) {
            this.zzaAT = autoMatchCriteria;
            return this;
        }

        public RoomConfig build() {
            return new RoomConfigImpl(this);
        }
    }
}

