/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomEntityCreator;
import com.google.android.gms.internal.zzmo;
import java.util.ArrayList;

public final class RoomEntity
extends GamesDowngradeableSafeParcel
implements Room {
    public static final Parcelable.Creator<RoomEntity> CREATOR = new RoomEntityCreatorCompat();
    private final int mVersionCode;
    private final String zzavE;
    private final String zzaAV;
    private final long zzaAz;
    private final int zzaAW;
    private final String zzaqZ;
    private final int zzaAD;
    private final Bundle zzaAT;
    private final ArrayList<ParticipantEntity> zzaAC;
    private final int zzaAX;

    public RoomEntity(Room room) {
        this.mVersionCode = 2;
        this.zzavE = room.getRoomId();
        this.zzaAV = room.getCreatorId();
        this.zzaAz = room.getCreationTimestamp();
        this.zzaAW = room.getStatus();
        this.zzaqZ = room.getDescription();
        this.zzaAD = room.getVariant();
        this.zzaAT = room.getAutoMatchCriteria();
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        this.zzaAC = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzaAC.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
        this.zzaAX = room.getAutoMatchWaitEstimateSeconds();
    }

    RoomEntity(int versionCode, String roomId, String creatorId, long creationTimestamp, int roomStatus, String description, int variant, Bundle autoMatchCriteria, ArrayList<ParticipantEntity> participants, int autoMatchWaitEstimateSeconds) {
        this.mVersionCode = versionCode;
        this.zzavE = roomId;
        this.zzaAV = creatorId;
        this.zzaAz = creationTimestamp;
        this.zzaAW = roomStatus;
        this.zzaqZ = description;
        this.zzaAD = variant;
        this.zzaAT = autoMatchCriteria;
        this.zzaAC = participants;
        this.zzaAX = autoMatchWaitEstimateSeconds;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getRoomId() {
        return this.zzavE;
    }

    @Override
    public String getCreatorId() {
        return this.zzaAV;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzaAz;
    }

    @Override
    public int getStatus() {
        return this.zzaAW;
    }

    @Override
    public String getDescription() {
        return this.zzaqZ;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzmo.zzb((String)this.zzaqZ, (CharArrayBuffer)dataOut);
    }

    @Override
    public int getVariant() {
        return this.zzaAD;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.zzaAT;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzaAC);
    }

    @Override
    public int getAutoMatchWaitEstimateSeconds() {
        return this.zzaAX;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        return RoomEntity.zza((Room)this, participantId);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return RoomEntity.zzc(this);
    }

    @Override
    public String getParticipantId(String playerId) {
        return RoomEntity.zzb(this, playerId);
    }

    @Override
    public Participant getParticipant(String participantId) {
        return RoomEntity.zzc(this, participantId);
    }

    public Room freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return RoomEntity.zza(this);
    }

    static int zza(Room room) {
        return zzw.hashCode((Object[])new Object[]{room.getRoomId(), room.getCreatorId(), room.getCreationTimestamp(), room.getStatus(), room.getDescription(), room.getVariant(), room.getAutoMatchCriteria(), room.getParticipants(), room.getAutoMatchWaitEstimateSeconds()});
    }

    public boolean equals(Object obj) {
        return RoomEntity.zza((Room)this, obj);
    }

    static boolean zza(Room room, Object object) {
        if (!(object instanceof Room)) {
            return false;
        }
        if (room == object) {
            return true;
        }
        Room room2 = (Room)object;
        return zzw.equal((Object)room2.getRoomId(), (Object)room.getRoomId()) && zzw.equal((Object)room2.getCreatorId(), (Object)room.getCreatorId()) && zzw.equal((Object)room2.getCreationTimestamp(), (Object)room.getCreationTimestamp()) && zzw.equal((Object)room2.getStatus(), (Object)room.getStatus()) && zzw.equal((Object)room2.getDescription(), (Object)room.getDescription()) && zzw.equal((Object)room2.getVariant(), (Object)room.getVariant()) && zzw.equal((Object)room2.getAutoMatchCriteria(), (Object)room.getAutoMatchCriteria()) && zzw.equal((Object)room2.getParticipants(), (Object)room.getParticipants()) && zzw.equal((Object)room2.getAutoMatchWaitEstimateSeconds(), (Object)room.getAutoMatchWaitEstimateSeconds());
    }

    public String toString() {
        return RoomEntity.zzb(this);
    }

    static String zzb(Room room) {
        return zzw.zzv((Object)room).zzg("RoomId", (Object)room.getRoomId()).zzg("CreatorId", (Object)room.getCreatorId()).zzg("CreationTimestamp", (Object)room.getCreationTimestamp()).zzg("RoomStatus", (Object)room.getStatus()).zzg("Description", (Object)room.getDescription()).zzg("Variant", (Object)room.getVariant()).zzg("AutoMatchCriteria", (Object)room.getAutoMatchCriteria()).zzg("Participants", (Object)room.getParticipants()).zzg("AutoMatchWaitEstimateSeconds", (Object)room.getAutoMatchWaitEstimateSeconds()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzoU()) {
            RoomEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeString(this.zzavE);
            dest.writeString(this.zzaAV);
            dest.writeLong(this.zzaAz);
            dest.writeInt(this.zzaAW);
            dest.writeString(this.zzaqZ);
            dest.writeInt(this.zzaAD);
            dest.writeBundle(this.zzaAT);
            int n = this.zzaAC.size();
            dest.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.zzaAC.get(i).writeToParcel(dest, flags);
            }
        }
    }

    static int zza(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + string + " is not in room " + room.getRoomId());
    }

    static ArrayList<String> zzc(Room room) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String zzb(Room room, String string) {
        String string2 = null;
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant zzc(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        throw new IllegalStateException("Participant " + string + " is not in match " + room.getRoomId());
    }

    static final class RoomEntityCreatorCompat
    extends RoomEntityCreator {
        RoomEntityCreatorCompat() {
        }

        @Override
        public RoomEntity zzei(Parcel parcel) {
            int n;
            boolean bl = RoomEntity.zzd(RoomEntity.zzoT());
            if (bl || RoomEntity.zzck((String)RoomEntity.class.getCanonicalName())) {
                return super.zzei(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            long l = parcel.readLong();
            int n2 = parcel.readInt();
            String string3 = parcel.readString();
            int n3 = parcel.readInt();
            Bundle bundle = parcel.readBundle();
            int n4 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n4);
            for (n = 0; n < n4; ++n) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n = -1;
            return new RoomEntity(2, string, string2, l, n2, string3, n3, bundle, arrayList, n);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzei(x0);
        }
    }
}

