/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfigImpl;
import java.util.ArrayList;

public abstract class TurnBasedMatchConfig {
    protected TurnBasedMatchConfig() {
    }

    public abstract int getVariant();

    public abstract int zzvN();

    public abstract String[] getInvitedPlayerIds();

    public abstract Bundle getAutoMatchCriteria();

    public static Builder builder() {
        return new Builder();
    }

    public static Bundle createAutoMatchCriteria(int minAutoMatchPlayers, int maxAutoMatchPlayers, long exclusiveBitMask) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", minAutoMatchPlayers);
        bundle.putInt("max_automatch_players", maxAutoMatchPlayers);
        bundle.putLong("exclusive_bit_mask", exclusiveBitMask);
        return bundle;
    }

    public static final class Builder {
        int zzaAD = -1;
        ArrayList<String> zzaAS = new ArrayList();
        Bundle zzaAT = null;
        int zzaBc = 2;

        private Builder() {
        }

        public Builder addInvitedPlayer(String playerId) {
            zzx.zzw((Object)playerId);
            this.zzaAS.add(playerId);
            return this;
        }

        public Builder addInvitedPlayers(ArrayList<String> playerIds) {
            zzx.zzw(playerIds);
            this.zzaAS.addAll(playerIds);
            return this;
        }

        public Builder setVariant(int variant) {
            zzx.zzb((variant == -1 || variant > 0 ? 1 : 0) != 0, (Object)"Variant must be a positive integer or TurnBasedMatch.MATCH_VARIANT_ANY");
            this.zzaAD = variant;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle autoMatchCriteria) {
            this.zzaAT = autoMatchCriteria;
            return this;
        }

        public TurnBasedMatchConfig build() {
            return new TurnBasedMatchConfigImpl(this);
        }
    }
}

