/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.graphics.Bitmap;
import android.net.Uri;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeEntity;

public abstract class SnapshotMetadataChange {
    public static final SnapshotMetadataChange EMPTY_CHANGE = new SnapshotMetadataChangeEntity();

    protected SnapshotMetadataChange() {
    }

    public abstract String getDescription();

    public abstract Long getPlayedTimeMillis();

    public abstract BitmapTeleporter zzvS();

    public abstract Bitmap getCoverImage();

    public abstract Long getProgressValue();

    public static final class Builder {
        private String zzaqZ;
        private Long zzaBH;
        private Long zzaBI;
        private BitmapTeleporter zzaBJ;
        private Uri zzaBK;

        public Builder setDescription(String description) {
            this.zzaqZ = description;
            return this;
        }

        public Builder setPlayedTimeMillis(long playedTimeMillis) {
            this.zzaBH = playedTimeMillis;
            return this;
        }

        public Builder setProgressValue(long progressValue) {
            this.zzaBI = progressValue;
            return this;
        }

        public Builder setCoverImage(Bitmap coverImage) {
            this.zzaBJ = new BitmapTeleporter(coverImage);
            this.zzaBK = null;
            return this;
        }

        public Builder fromMetadata(SnapshotMetadata metadata) {
            this.zzaqZ = metadata.getDescription();
            this.zzaBH = metadata.getPlayedTime();
            this.zzaBI = metadata.getProgressValue();
            if (this.zzaBH == -1L) {
                this.zzaBH = null;
            }
            this.zzaBK = metadata.getCoverImageUri();
            if (this.zzaBK != null) {
                this.zzaBJ = null;
            }
            return this;
        }

        public SnapshotMetadataChange build() {
            return new SnapshotMetadataChangeEntity(this.zzaqZ, this.zzaBH, this.zzaBJ, this.zzaBK, this.zzaBI);
        }
    }
}

