/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntityCreator;
import com.google.android.gms.internal.zzmo;

public final class SnapshotMetadataEntity
implements SafeParcelable,
SnapshotMetadata {
    public static final Parcelable.Creator<SnapshotMetadataEntity> CREATOR = new SnapshotMetadataEntityCreator();
    private final int mVersionCode;
    private final GameEntity zzaAy;
    private final PlayerEntity zzaBN;
    private final String zzavx;
    private final Uri zzaBK;
    private final String zzaBO;
    private final String zzajf;
    private final String zzaqZ;
    private final long zzaBP;
    private final long zzaBQ;
    private final float zzaBR;
    private final String zzaBS;
    private final boolean zzaBT;
    private final long zzaBU;
    private final String zzaBV;

    public SnapshotMetadataEntity(SnapshotMetadata snapshotMetadata) {
        this.mVersionCode = 6;
        this.zzaAy = new GameEntity(snapshotMetadata.getGame());
        this.zzaBN = new PlayerEntity(snapshotMetadata.getOwner());
        this.zzavx = snapshotMetadata.getSnapshotId();
        this.zzaBK = snapshotMetadata.getCoverImageUri();
        this.zzaBO = snapshotMetadata.getCoverImageUrl();
        this.zzaBR = snapshotMetadata.getCoverImageAspectRatio();
        this.zzajf = snapshotMetadata.getTitle();
        this.zzaqZ = snapshotMetadata.getDescription();
        this.zzaBP = snapshotMetadata.getLastModifiedTimestamp();
        this.zzaBQ = snapshotMetadata.getPlayedTime();
        this.zzaBS = snapshotMetadata.getUniqueName();
        this.zzaBT = snapshotMetadata.hasChangePending();
        this.zzaBU = snapshotMetadata.getProgressValue();
        this.zzaBV = snapshotMetadata.getDeviceName();
    }

    SnapshotMetadataEntity(int versionCode, GameEntity game, PlayerEntity owner, String snapshotId, Uri coverImageUri, String coverImageUrl, String title, String description, long lastModifiedTimestamp, long playedTime, float coverImageAspectRatio, String uniqueName, boolean changePending, long progressValue, String deviceName) {
        this.mVersionCode = versionCode;
        this.zzaAy = game;
        this.zzaBN = owner;
        this.zzavx = snapshotId;
        this.zzaBK = coverImageUri;
        this.zzaBO = coverImageUrl;
        this.zzaBR = coverImageAspectRatio;
        this.zzajf = title;
        this.zzaqZ = description;
        this.zzaBP = lastModifiedTimestamp;
        this.zzaBQ = playedTime;
        this.zzaBS = uniqueName;
        this.zzaBT = changePending;
        this.zzaBU = progressValue;
        this.zzaBV = deviceName;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public Game getGame() {
        return this.zzaAy;
    }

    @Override
    public Player getOwner() {
        return this.zzaBN;
    }

    @Override
    public String getSnapshotId() {
        return this.zzavx;
    }

    @Override
    public Uri getCoverImageUri() {
        return this.zzaBK;
    }

    @Override
    public String getCoverImageUrl() {
        return this.zzaBO;
    }

    @Override
    public float getCoverImageAspectRatio() {
        return this.zzaBR;
    }

    @Override
    public String getUniqueName() {
        return this.zzaBS;
    }

    @Override
    public String getTitle() {
        return this.zzajf;
    }

    @Override
    public String getDescription() {
        return this.zzaqZ;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzmo.zzb((String)this.zzaqZ, (CharArrayBuffer)dataOut);
    }

    @Override
    public long getLastModifiedTimestamp() {
        return this.zzaBP;
    }

    @Override
    public long getPlayedTime() {
        return this.zzaBQ;
    }

    @Override
    public boolean hasChangePending() {
        return this.zzaBT;
    }

    @Override
    public long getProgressValue() {
        return this.zzaBU;
    }

    @Override
    public String getDeviceName() {
        return this.zzaBV;
    }

    public SnapshotMetadata freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return SnapshotMetadataEntity.zza(this);
    }

    static int zza(SnapshotMetadata snapshotMetadata) {
        return zzw.hashCode((Object[])new Object[]{snapshotMetadata.getGame(), snapshotMetadata.getOwner(), snapshotMetadata.getSnapshotId(), snapshotMetadata.getCoverImageUri(), Float.valueOf(snapshotMetadata.getCoverImageAspectRatio()), snapshotMetadata.getTitle(), snapshotMetadata.getDescription(), snapshotMetadata.getLastModifiedTimestamp(), snapshotMetadata.getPlayedTime(), snapshotMetadata.getUniqueName(), snapshotMetadata.hasChangePending(), snapshotMetadata.getProgressValue(), snapshotMetadata.getDeviceName()});
    }

    public boolean equals(Object obj) {
        return SnapshotMetadataEntity.zza(this, obj);
    }

    static boolean zza(SnapshotMetadata snapshotMetadata, Object object) {
        if (!(object instanceof SnapshotMetadata)) {
            return false;
        }
        if (snapshotMetadata == object) {
            return true;
        }
        SnapshotMetadata snapshotMetadata2 = (SnapshotMetadata)object;
        return zzw.equal((Object)snapshotMetadata2.getGame(), (Object)snapshotMetadata.getGame()) && zzw.equal((Object)snapshotMetadata2.getOwner(), (Object)snapshotMetadata.getOwner()) && zzw.equal((Object)snapshotMetadata2.getSnapshotId(), (Object)snapshotMetadata.getSnapshotId()) && zzw.equal((Object)snapshotMetadata2.getCoverImageUri(), (Object)snapshotMetadata.getCoverImageUri()) && zzw.equal((Object)Float.valueOf(snapshotMetadata2.getCoverImageAspectRatio()), (Object)Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())) && zzw.equal((Object)snapshotMetadata2.getTitle(), (Object)snapshotMetadata.getTitle()) && zzw.equal((Object)snapshotMetadata2.getDescription(), (Object)snapshotMetadata.getDescription()) && zzw.equal((Object)snapshotMetadata2.getLastModifiedTimestamp(), (Object)snapshotMetadata.getLastModifiedTimestamp()) && zzw.equal((Object)snapshotMetadata2.getPlayedTime(), (Object)snapshotMetadata.getPlayedTime()) && zzw.equal((Object)snapshotMetadata2.getUniqueName(), (Object)snapshotMetadata.getUniqueName()) && zzw.equal((Object)snapshotMetadata2.hasChangePending(), (Object)snapshotMetadata.hasChangePending()) && zzw.equal((Object)snapshotMetadata2.getProgressValue(), (Object)snapshotMetadata.getProgressValue()) && zzw.equal((Object)snapshotMetadata2.getDeviceName(), (Object)snapshotMetadata.getDeviceName());
    }

    public String toString() {
        return SnapshotMetadataEntity.zzb(this);
    }

    static String zzb(SnapshotMetadata snapshotMetadata) {
        return zzw.zzv((Object)snapshotMetadata).zzg("Game", (Object)snapshotMetadata.getGame()).zzg("Owner", (Object)snapshotMetadata.getOwner()).zzg("SnapshotId", (Object)snapshotMetadata.getSnapshotId()).zzg("CoverImageUri", (Object)snapshotMetadata.getCoverImageUri()).zzg("CoverImageUrl", (Object)snapshotMetadata.getCoverImageUrl()).zzg("CoverImageAspectRatio", (Object)Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())).zzg("Description", (Object)snapshotMetadata.getDescription()).zzg("LastModifiedTimestamp", (Object)snapshotMetadata.getLastModifiedTimestamp()).zzg("PlayedTime", (Object)snapshotMetadata.getPlayedTime()).zzg("UniqueName", (Object)snapshotMetadata.getUniqueName()).zzg("ChangePending", (Object)snapshotMetadata.hasChangePending()).zzg("ProgressValue", (Object)snapshotMetadata.getProgressValue()).zzg("DeviceName", (Object)snapshotMetadata.getDeviceName()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        SnapshotMetadataEntityCreator.zza(this, out, flags);
    }
}

