/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.appcontent;

import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.appcontent.AppContentAction;
import com.google.android.gms.games.appcontent.AppContentActionEntity;
import com.google.android.gms.games.appcontent.AppContentAnnotation;
import com.google.android.gms.games.appcontent.AppContentAnnotationEntity;
import com.google.android.gms.games.appcontent.AppContentCard;
import com.google.android.gms.games.appcontent.AppContentCardEntity;
import com.google.android.gms.games.appcontent.AppContentSection;
import com.google.android.gms.games.appcontent.AppContentSectionEntityCreator;
import java.util.ArrayList;
import java.util.List;

public final class AppContentSectionEntity
implements SafeParcelable,
AppContentSection {
    public static final AppContentSectionEntityCreator CREATOR = new AppContentSectionEntityCreator();
    private final int mVersionCode;
    private final ArrayList<AppContentActionEntity> mActions;
    private final ArrayList<AppContentCardEntity> zzaDO;
    private final String zzaDw;
    private final Bundle mExtras;
    private final String zzaDH;
    private final String zzapg;
    private final String zzJN;
    private final String zzyv;
    private final String zzaDP;
    private final ArrayList<AppContentAnnotationEntity> zzaDF;

    public AppContentSectionEntity(AppContentSection section) {
        this.mVersionCode = 5;
        this.zzaDP = section.zzwl();
        this.zzaDw = section.zzvQ();
        this.mExtras = section.getExtras();
        this.zzyv = section.getId();
        this.zzaDH = section.zzwc();
        this.zzapg = section.getTitle();
        this.zzJN = section.getType();
        List<AppContentAction> list = section.getActions();
        int n = list.size();
        this.mActions = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.mActions.add((AppContentActionEntity)list.get(i).freeze());
        }
        List<AppContentCard> list2 = section.zzwk();
        n = list2.size();
        this.zzaDO = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzaDO.add((AppContentCardEntity)list2.get(i).freeze());
        }
        List<AppContentAnnotation> list3 = section.zzwa();
        n = list3.size();
        this.zzaDF = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzaDF.add((AppContentAnnotationEntity)list3.get(i).freeze());
        }
    }

    AppContentSectionEntity(int versionCode, ArrayList<AppContentActionEntity> actions, ArrayList<AppContentCardEntity> cards, String contentDescription, Bundle extras, String subtitle, String title, String type, String id, String cardType, ArrayList<AppContentAnnotationEntity> annotations) {
        this.mVersionCode = versionCode;
        this.mActions = actions;
        this.zzaDF = annotations;
        this.zzaDO = cards;
        this.zzaDP = cardType;
        this.zzaDw = contentDescription;
        this.mExtras = extras;
        this.zzyv = id;
        this.zzaDH = subtitle;
        this.zzapg = title;
        this.zzJN = type;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public List<AppContentAction> getActions() {
        return new ArrayList<AppContentAction>(this.mActions);
    }

    @Override
    public List<AppContentAnnotation> zzwa() {
        return new ArrayList<AppContentAnnotation>(this.zzaDF);
    }

    @Override
    public List<AppContentCard> zzwk() {
        return new ArrayList<AppContentCard>(this.zzaDO);
    }

    @Override
    public String zzwl() {
        return this.zzaDP;
    }

    @Override
    public String zzvQ() {
        return this.zzaDw;
    }

    @Override
    public Bundle getExtras() {
        return this.mExtras;
    }

    @Override
    public String zzwc() {
        return this.zzaDH;
    }

    @Override
    public String getId() {
        return this.zzyv;
    }

    @Override
    public String getTitle() {
        return this.zzapg;
    }

    @Override
    public String getType() {
        return this.zzJN;
    }

    public AppContentSection zzwm() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return AppContentSectionEntity.zza(this);
    }

    static int zza(AppContentSection appContentSection) {
        return zzw.hashCode((Object[])new Object[]{appContentSection.getActions(), appContentSection.zzwa(), appContentSection.zzwk(), appContentSection.zzwl(), appContentSection.zzvQ(), appContentSection.getExtras(), appContentSection.getId(), appContentSection.zzwc(), appContentSection.getTitle(), appContentSection.getType()});
    }

    public boolean equals(Object obj) {
        return AppContentSectionEntity.zza(this, obj);
    }

    static boolean zza(AppContentSection appContentSection, Object object) {
        if (!(object instanceof AppContentSection)) {
            return false;
        }
        if (appContentSection == object) {
            return true;
        }
        AppContentSection appContentSection2 = (AppContentSection)object;
        return zzw.equal(appContentSection2.getActions(), appContentSection.getActions()) && zzw.equal(appContentSection2.zzwa(), appContentSection.zzwa()) && zzw.equal(appContentSection2.zzwk(), appContentSection.zzwk()) && zzw.equal((Object)appContentSection2.zzwl(), (Object)appContentSection.zzwl()) && zzw.equal((Object)appContentSection2.zzvQ(), (Object)appContentSection.zzvQ()) && zzw.equal((Object)appContentSection2.getExtras(), (Object)appContentSection.getExtras()) && zzw.equal((Object)appContentSection2.getId(), (Object)appContentSection.getId()) && zzw.equal((Object)appContentSection2.zzwc(), (Object)appContentSection.zzwc()) && zzw.equal((Object)appContentSection2.getTitle(), (Object)appContentSection.getTitle()) && zzw.equal((Object)appContentSection2.getType(), (Object)appContentSection.getType());
    }

    public String toString() {
        return AppContentSectionEntity.zzb(this);
    }

    static String zzb(AppContentSection appContentSection) {
        return zzw.zzy((Object)appContentSection).zzg("Actions", appContentSection.getActions()).zzg("Annotations", appContentSection.zzwa()).zzg("Cards", appContentSection.zzwk()).zzg("CardType", (Object)appContentSection.zzwl()).zzg("ContentDescription", (Object)appContentSection.zzvQ()).zzg("Extras", (Object)appContentSection.getExtras()).zzg("Id", (Object)appContentSection.getId()).zzg("Subtitle", (Object)appContentSection.zzwc()).zzg("Title", (Object)appContentSection.getTitle()).zzg("Type", (Object)appContentSection.getType()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        AppContentSectionEntityCreator.zza(this, out, flags);
    }

    public /* synthetic */ Object freeze() {
        return this.zzwm();
    }
}

