/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.request;

import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.internal.constants.RequestUpdateResultOutcome;
import java.util.HashMap;
import java.util.Set;

public final class RequestUpdateOutcomes {
    private static final String[] zzaIX = new String[]{"requestId", "outcome"};
    private final int zzade;
    private final HashMap<String, Integer> zzaIY;

    private RequestUpdateOutcomes(int statusCode, HashMap<String, Integer> outcomeMap) {
        this.zzade = statusCode;
        this.zzaIY = outcomeMap;
    }

    public int getRequestOutcome(String requestId) {
        zzx.zzb((boolean)this.zzaIY.containsKey(requestId), (Object)("Request " + requestId + " was not part of the update operation!"));
        return this.zzaIY.get(requestId);
    }

    public Set<String> getRequestIds() {
        return this.zzaIY.keySet();
    }

    public static RequestUpdateOutcomes zzab(DataHolder dataHolder) {
        Builder builder = new Builder();
        builder.zzgG(dataHolder.getStatusCode());
        int n = dataHolder.getCount();
        for (int i = 0; i < n; ++i) {
            int n2 = dataHolder.zzbH(i);
            builder.zzx(dataHolder.zzd("requestId", i, n2), dataHolder.zzc("outcome", i, n2));
        }
        return builder.zzxH();
    }

    public static final class Builder {
        private HashMap<String, Integer> zzaIY = new HashMap();
        private int zzade = 0;

        public Builder zzx(String string, int n) {
            if (RequestUpdateResultOutcome.isValid(n)) {
                this.zzaIY.put(string, n);
            }
            return this;
        }

        public Builder zzgG(int n) {
            this.zzade = n;
            return this;
        }

        public RequestUpdateOutcomes zzxH() {
            return new RequestUpdateOutcomes(this.zzade, this.zzaIY);
        }
    }
}

