/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestEntityCreator;
import com.google.android.gms.internal.zzms;
import java.util.ArrayList;
import java.util.List;

public final class QuestEntity
implements SafeParcelable,
Quest {
    public static final Parcelable.Creator<QuestEntity> CREATOR = new QuestEntityCreator();
    private final int mVersionCode;
    private final GameEntity zzaJE;
    private final String zzaKw;
    private final long zzaKx;
    private final Uri zzaKy;
    private final String zzaKz;
    private final String zzaxl;
    private final long zzaKA;
    private final long zzaDt;
    private final Uri zzaKB;
    private final String zzaKC;
    private final String mName;
    private final long zzaKD;
    private final long zzaKE;
    private final int mState;
    private final int zzabB;
    private final ArrayList<MilestoneEntity> zzaKF;

    public QuestEntity(Quest quest) {
        this.mVersionCode = 2;
        this.zzaJE = new GameEntity(quest.getGame());
        this.zzaKw = quest.getQuestId();
        this.zzaKx = quest.getAcceptedTimestamp();
        this.zzaxl = quest.getDescription();
        this.zzaKy = quest.getBannerImageUri();
        this.zzaKz = quest.getBannerImageUrl();
        this.zzaKA = quest.getEndTimestamp();
        this.zzaKB = quest.getIconImageUri();
        this.zzaKC = quest.getIconImageUrl();
        this.zzaDt = quest.getLastUpdatedTimestamp();
        this.mName = quest.getName();
        this.zzaKD = quest.zzxS();
        this.zzaKE = quest.getStartTimestamp();
        this.mState = quest.getState();
        this.zzabB = quest.getType();
        List<Milestone> list = quest.zzxR();
        int n = list.size();
        this.zzaKF = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzaKF.add((MilestoneEntity)list.get(i).freeze());
        }
    }

    QuestEntity(int versionCode, GameEntity game, String questId, long acceptedTimestamp, Uri bannerImageUri, String bannerImageUrl, String description, long endTimestamp, long lastUpdatedTimestamp, Uri iconImageUri, String iconImageUrl, String name, long notifyTimestamp, long startTimestamp, int state, int type, ArrayList<MilestoneEntity> milestones) {
        this.mVersionCode = versionCode;
        this.zzaJE = game;
        this.zzaKw = questId;
        this.zzaKx = acceptedTimestamp;
        this.zzaKy = bannerImageUri;
        this.zzaKz = bannerImageUrl;
        this.zzaxl = description;
        this.zzaKA = endTimestamp;
        this.zzaDt = lastUpdatedTimestamp;
        this.zzaKB = iconImageUri;
        this.zzaKC = iconImageUrl;
        this.mName = name;
        this.zzaKD = notifyTimestamp;
        this.zzaKE = startTimestamp;
        this.mState = state;
        this.zzabB = type;
        this.zzaKF = milestones;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getQuestId() {
        return this.zzaKw;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        zzms.zzb((String)this.mName, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDescription() {
        return this.zzaxl;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzms.zzb((String)this.zzaxl, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzaKB;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzaKC;
    }

    @Override
    public Uri getBannerImageUri() {
        return this.zzaKy;
    }

    @Override
    public String getBannerImageUrl() {
        return this.zzaKz;
    }

    @Override
    public Milestone getCurrentMilestone() {
        return this.zzxR().get(0);
    }

    @Override
    public List<Milestone> zzxR() {
        return new ArrayList<Milestone>(this.zzaKF);
    }

    @Override
    public Game getGame() {
        return this.zzaJE;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getType() {
        return this.zzabB;
    }

    @Override
    public long getAcceptedTimestamp() {
        return this.zzaKx;
    }

    @Override
    public long getEndTimestamp() {
        return this.zzaKA;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzaDt;
    }

    @Override
    public long zzxS() {
        return this.zzaKD;
    }

    @Override
    public long getStartTimestamp() {
        return this.zzaKE;
    }

    @Override
    public boolean isEndingSoon() {
        return this.zzaKD <= System.currentTimeMillis() + 1800000L;
    }

    public Quest freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return QuestEntity.zza(this);
    }

    static int zza(Quest quest) {
        return zzw.hashCode((Object[])new Object[]{quest.getGame(), quest.getQuestId(), quest.getAcceptedTimestamp(), quest.getBannerImageUri(), quest.getDescription(), quest.getEndTimestamp(), quest.getIconImageUri(), quest.getLastUpdatedTimestamp(), quest.zzxR(), quest.getName(), quest.zzxS(), quest.getStartTimestamp(), quest.getState()});
    }

    public boolean equals(Object obj) {
        return QuestEntity.zza(this, obj);
    }

    static boolean zza(Quest quest, Object object) {
        if (!(object instanceof Quest)) {
            return false;
        }
        if (quest == object) {
            return true;
        }
        Quest quest2 = (Quest)object;
        return zzw.equal((Object)quest2.getGame(), (Object)quest.getGame()) && zzw.equal((Object)quest2.getQuestId(), (Object)quest.getQuestId()) && zzw.equal((Object)quest2.getAcceptedTimestamp(), (Object)quest.getAcceptedTimestamp()) && zzw.equal((Object)quest2.getBannerImageUri(), (Object)quest.getBannerImageUri()) && zzw.equal((Object)quest2.getDescription(), (Object)quest.getDescription()) && zzw.equal((Object)quest2.getEndTimestamp(), (Object)quest.getEndTimestamp()) && zzw.equal((Object)quest2.getIconImageUri(), (Object)quest.getIconImageUri()) && zzw.equal((Object)quest2.getLastUpdatedTimestamp(), (Object)quest.getLastUpdatedTimestamp()) && zzw.equal(quest2.zzxR(), quest.zzxR()) && zzw.equal((Object)quest2.getName(), (Object)quest.getName()) && zzw.equal((Object)quest2.zzxS(), (Object)quest.zzxS()) && zzw.equal((Object)quest2.getStartTimestamp(), (Object)quest.getStartTimestamp()) && zzw.equal((Object)quest2.getState(), (Object)quest.getState());
    }

    public String toString() {
        return QuestEntity.zzb(this);
    }

    static String zzb(Quest quest) {
        return zzw.zzy((Object)quest).zzg("Game", (Object)quest.getGame()).zzg("QuestId", (Object)quest.getQuestId()).zzg("AcceptedTimestamp", (Object)quest.getAcceptedTimestamp()).zzg("BannerImageUri", (Object)quest.getBannerImageUri()).zzg("BannerImageUrl", (Object)quest.getBannerImageUrl()).zzg("Description", (Object)quest.getDescription()).zzg("EndTimestamp", (Object)quest.getEndTimestamp()).zzg("IconImageUri", (Object)quest.getIconImageUri()).zzg("IconImageUrl", (Object)quest.getIconImageUrl()).zzg("LastUpdatedTimestamp", (Object)quest.getLastUpdatedTimestamp()).zzg("Milestones", quest.zzxR()).zzg("Name", (Object)quest.getName()).zzg("NotifyTimestamp", (Object)quest.zzxS()).zzg("StartTimestamp", (Object)quest.getStartTimestamp()).zzg("State", (Object)quest.getState()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        QuestEntityCreator.zza(this, out, flags);
    }
}

