/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomEntityCreator;
import java.util.ArrayList;

public final class RoomEntity
extends GamesDowngradeableSafeParcel
implements Room {
    public static final Parcelable.Creator<RoomEntity> CREATOR = new RoomEntityCreatorCompat();
    private final int mVersionCode;
    private final String zzaLv;
    private final String zzaRd;
    private final long zzaQH;
    private final int zzaRe;
    private final String zzVw;
    private final int zzaQL;
    private final Bundle zzaRb;
    private final ArrayList<ParticipantEntity> zzaQK;
    private final int zzaRf;

    public RoomEntity(Room room) {
        this.mVersionCode = 2;
        this.zzaLv = room.getRoomId();
        this.zzaRd = room.getCreatorId();
        this.zzaQH = room.getCreationTimestamp();
        this.zzaRe = room.getStatus();
        this.zzVw = room.getDescription();
        this.zzaQL = room.getVariant();
        this.zzaRb = room.getAutoMatchCriteria();
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        this.zzaQK = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzaQK.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
        this.zzaRf = room.getAutoMatchWaitEstimateSeconds();
    }

    RoomEntity(int n, String string, String string2, long l, int n2, String string3, int n3, Bundle bundle, ArrayList<ParticipantEntity> arrayList, int n4) {
        this.mVersionCode = n;
        this.zzaLv = string;
        this.zzaRd = string2;
        this.zzaQH = l;
        this.zzaRe = n2;
        this.zzVw = string3;
        this.zzaQL = n3;
        this.zzaRb = bundle;
        this.zzaQK = arrayList;
        this.zzaRf = n4;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getRoomId() {
        return this.zzaLv;
    }

    @Override
    public String getCreatorId() {
        return this.zzaRd;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzaQH;
    }

    @Override
    public int getStatus() {
        return this.zzaRe;
    }

    @Override
    public String getDescription() {
        return this.zzVw;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzVw, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public int getVariant() {
        return this.zzaQL;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.zzaRb;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzaQK);
    }

    @Override
    public int getAutoMatchWaitEstimateSeconds() {
        return this.zzaRf;
    }

    @Override
    public int getParticipantStatus(String string) {
        return RoomEntity.zza((Room)this, string);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return RoomEntity.zzc(this);
    }

    @Override
    public String getParticipantId(String string) {
        return RoomEntity.zzb(this, string);
    }

    @Override
    public Participant getParticipant(String string) {
        return RoomEntity.zzc(this, string);
    }

    public Room freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return RoomEntity.zza(this);
    }

    static int zza(Room room) {
        return zzz.hashCode((Object[])new Object[]{room.getRoomId(), room.getCreatorId(), room.getCreationTimestamp(), room.getStatus(), room.getDescription(), room.getVariant(), room.getAutoMatchCriteria(), room.getParticipants(), room.getAutoMatchWaitEstimateSeconds()});
    }

    public boolean equals(Object object) {
        return RoomEntity.zza((Room)this, object);
    }

    static boolean zza(Room room, Object object) {
        if (!(object instanceof Room)) {
            return false;
        }
        if (room == object) {
            return true;
        }
        Room room2 = (Room)object;
        return zzz.equal((Object)room2.getRoomId(), (Object)room.getRoomId()) && zzz.equal((Object)room2.getCreatorId(), (Object)room.getCreatorId()) && zzz.equal((Object)room2.getCreationTimestamp(), (Object)room.getCreationTimestamp()) && zzz.equal((Object)room2.getStatus(), (Object)room.getStatus()) && zzz.equal((Object)room2.getDescription(), (Object)room.getDescription()) && zzz.equal((Object)room2.getVariant(), (Object)room.getVariant()) && zzz.equal((Object)room2.getAutoMatchCriteria(), (Object)room.getAutoMatchCriteria()) && zzz.equal((Object)room2.getParticipants(), (Object)room.getParticipants()) && zzz.equal((Object)room2.getAutoMatchWaitEstimateSeconds(), (Object)room.getAutoMatchWaitEstimateSeconds());
    }

    public String toString() {
        return RoomEntity.zzb(this);
    }

    static String zzb(Room room) {
        return zzz.zzy((Object)room).zzg("RoomId", (Object)room.getRoomId()).zzg("CreatorId", (Object)room.getCreatorId()).zzg("CreationTimestamp", (Object)room.getCreationTimestamp()).zzg("RoomStatus", (Object)room.getStatus()).zzg("Description", (Object)room.getDescription()).zzg("Variant", (Object)room.getVariant()).zzg("AutoMatchCriteria", (Object)room.getAutoMatchCriteria()).zzg("Participants", (Object)room.getParticipants()).zzg("AutoMatchWaitEstimateSeconds", (Object)room.getAutoMatchWaitEstimateSeconds()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (!this.zztG()) {
            RoomEntityCreator.zza(this, parcel, n);
        } else {
            parcel.writeString(this.zzaLv);
            parcel.writeString(this.zzaRd);
            parcel.writeLong(this.zzaQH);
            parcel.writeInt(this.zzaRe);
            parcel.writeString(this.zzVw);
            parcel.writeInt(this.zzaQL);
            parcel.writeBundle(this.zzaRb);
            int n2 = this.zzaQK.size();
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                this.zzaQK.get(i).writeToParcel(parcel, n);
            }
        }
    }

    static int zza(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        String string2 = String.valueOf(room.getRoomId());
        throw new IllegalStateException(new StringBuilder(28 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in room ").append(string2).toString());
    }

    static ArrayList<String> zzc(Room room) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String zzb(Room room, String string) {
        String string2 = null;
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant zzc(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        String string2 = String.valueOf(room.getRoomId());
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in match ").append(string2).toString());
    }

    static final class RoomEntityCreatorCompat
    extends RoomEntityCreator {
        RoomEntityCreatorCompat() {
        }

        @Override
        public RoomEntity zzey(Parcel parcel) {
            int n;
            boolean bl = RoomEntity.zzf(RoomEntity.zztF());
            if (bl || RoomEntity.zzde((String)RoomEntity.class.getCanonicalName())) {
                return super.zzey(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            long l = parcel.readLong();
            int n2 = parcel.readInt();
            String string3 = parcel.readString();
            int n3 = parcel.readInt();
            Bundle bundle = parcel.readBundle();
            int n4 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n4);
            for (n = 0; n < n4; ++n) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n = -1;
            return new RoomEntity(2, string, string2, l, n2, string3, n3, bundle, arrayList, -1);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzey(parcel);
        }
    }
}

