/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchEntityCreator;
import java.util.ArrayList;

public final class TurnBasedMatchEntity
extends AbstractSafeParcelable
implements TurnBasedMatch {
    public static final Parcelable.Creator<TurnBasedMatchEntity> CREATOR = new TurnBasedMatchEntityCreator();
    private final int mVersionCode;
    private final GameEntity zzaOX;
    private final String zzaLQ;
    private final String zzaRd;
    private final long zzaQH;
    private final String zzaRl;
    private final long zzaKl;
    private final String zzaRm;
    private final int zzaRn;
    private final int zzaQL;
    private final int mVersion;
    private final byte[] zzaRo;
    private final ArrayList<ParticipantEntity> zzaQK;
    private final String zzaRp;
    private final byte[] zzaRq;
    private final int zzaRr;
    private final Bundle zzaRb;
    private final int zzaRs;
    private final boolean zzaRt;
    private final String zzVw;
    private final String zzaRu;

    public TurnBasedMatchEntity(TurnBasedMatch turnBasedMatch) {
        this.mVersionCode = 2;
        this.zzaOX = new GameEntity(turnBasedMatch.getGame());
        this.zzaLQ = turnBasedMatch.getMatchId();
        this.zzaRd = turnBasedMatch.getCreatorId();
        this.zzaQH = turnBasedMatch.getCreationTimestamp();
        this.zzaRl = turnBasedMatch.getLastUpdaterId();
        this.zzaKl = turnBasedMatch.getLastUpdatedTimestamp();
        this.zzaRm = turnBasedMatch.getPendingParticipantId();
        this.zzaRn = turnBasedMatch.getStatus();
        this.zzaRs = turnBasedMatch.getTurnStatus();
        this.zzaQL = turnBasedMatch.getVariant();
        this.mVersion = turnBasedMatch.getVersion();
        this.zzaRp = turnBasedMatch.getRematchId();
        this.zzaRr = turnBasedMatch.getMatchNumber();
        this.zzaRb = turnBasedMatch.getAutoMatchCriteria();
        this.zzaRt = turnBasedMatch.isLocallyModified();
        this.zzVw = turnBasedMatch.getDescription();
        this.zzaRu = turnBasedMatch.getDescriptionParticipantId();
        byte[] byArray = turnBasedMatch.getData();
        if (byArray == null) {
            this.zzaRo = null;
        } else {
            this.zzaRo = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzaRo, 0, byArray.length);
        }
        byte[] byArray2 = turnBasedMatch.getPreviousMatchData();
        if (byArray2 == null) {
            this.zzaRq = null;
        } else {
            this.zzaRq = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.zzaRq, 0, byArray2.length);
        }
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        this.zzaQK = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzaQK.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
    }

    TurnBasedMatchEntity(int n, GameEntity gameEntity, String string, String string2, long l, String string3, long l2, String string4, int n2, int n3, int n4, byte[] byArray, ArrayList<ParticipantEntity> arrayList, String string5, byte[] byArray2, int n5, Bundle bundle, int n6, boolean bl, String string6, String string7) {
        this.mVersionCode = n;
        this.zzaOX = gameEntity;
        this.zzaLQ = string;
        this.zzaRd = string2;
        this.zzaQH = l;
        this.zzaRl = string3;
        this.zzaKl = l2;
        this.zzaRm = string4;
        this.zzaRn = n2;
        this.zzaRs = n6;
        this.zzaQL = n3;
        this.mVersion = n4;
        this.zzaRo = byArray;
        this.zzaQK = arrayList;
        this.zzaRp = string5;
        this.zzaRq = byArray2;
        this.zzaRr = n5;
        this.zzaRb = bundle;
        this.zzaRt = bl;
        this.zzVw = string6;
        this.zzaRu = string7;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public Game getGame() {
        return this.zzaOX;
    }

    @Override
    public String getMatchId() {
        return this.zzaLQ;
    }

    @Override
    public String getCreatorId() {
        return this.zzaRd;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzaQH;
    }

    @Override
    public String getLastUpdaterId() {
        return this.zzaRl;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzaKl;
    }

    @Override
    public String getPendingParticipantId() {
        return this.zzaRm;
    }

    @Override
    public int getStatus() {
        return this.zzaRn;
    }

    @Override
    public int getTurnStatus() {
        return this.zzaRs;
    }

    @Override
    public String getDescription() {
        return this.zzVw;
    }

    @Override
    public String getDescriptionParticipantId() {
        return this.zzaRu;
    }

    @Override
    public Participant getDescriptionParticipant() {
        String string = this.getDescriptionParticipantId();
        if (string == null) {
            return null;
        }
        return this.getParticipant(string);
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzVw, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public int getVariant() {
        return this.zzaQL;
    }

    @Override
    public byte[] getData() {
        return this.zzaRo;
    }

    @Override
    public int getVersion() {
        return this.mVersion;
    }

    @Override
    public String getRematchId() {
        return this.zzaRp;
    }

    @Override
    public byte[] getPreviousMatchData() {
        return this.zzaRq;
    }

    @Override
    public int getMatchNumber() {
        return this.zzaRr;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.zzaRb;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        if (this.zzaRb == null) {
            return 0;
        }
        return this.zzaRb.getInt("max_automatch_players");
    }

    @Override
    public boolean canRematch() {
        return this.zzaRn == 2 && this.zzaRp == null;
    }

    @Override
    public boolean isLocallyModified() {
        return this.zzaRt;
    }

    @Override
    public int getParticipantStatus(String string) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, string);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.zzc(this);
    }

    @Override
    public String getParticipantId(String string) {
        return TurnBasedMatchEntity.zzb(this, string);
    }

    @Override
    public Participant getParticipant(String string) {
        return TurnBasedMatchEntity.zzc(this, string);
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzaQK);
    }

    public TurnBasedMatch freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return TurnBasedMatchEntity.zza(this);
    }

    static int zza(TurnBasedMatch turnBasedMatch) {
        return zzz.hashCode((Object[])new Object[]{turnBasedMatch.getGame(), turnBasedMatch.getMatchId(), turnBasedMatch.getCreatorId(), turnBasedMatch.getCreationTimestamp(), turnBasedMatch.getLastUpdaterId(), turnBasedMatch.getLastUpdatedTimestamp(), turnBasedMatch.getPendingParticipantId(), turnBasedMatch.getStatus(), turnBasedMatch.getTurnStatus(), turnBasedMatch.getDescription(), turnBasedMatch.getVariant(), turnBasedMatch.getVersion(), turnBasedMatch.getParticipants(), turnBasedMatch.getRematchId(), turnBasedMatch.getMatchNumber(), turnBasedMatch.getAutoMatchCriteria(), turnBasedMatch.getAvailableAutoMatchSlots(), turnBasedMatch.isLocallyModified()});
    }

    public boolean equals(Object object) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, object);
    }

    static boolean zza(TurnBasedMatch turnBasedMatch, Object object) {
        if (!(object instanceof TurnBasedMatch)) {
            return false;
        }
        if (turnBasedMatch == object) {
            return true;
        }
        TurnBasedMatch turnBasedMatch2 = (TurnBasedMatch)object;
        return zzz.equal((Object)turnBasedMatch2.getGame(), (Object)turnBasedMatch.getGame()) && zzz.equal((Object)turnBasedMatch2.getMatchId(), (Object)turnBasedMatch.getMatchId()) && zzz.equal((Object)turnBasedMatch2.getCreatorId(), (Object)turnBasedMatch.getCreatorId()) && zzz.equal((Object)turnBasedMatch2.getCreationTimestamp(), (Object)turnBasedMatch.getCreationTimestamp()) && zzz.equal((Object)turnBasedMatch2.getLastUpdaterId(), (Object)turnBasedMatch.getLastUpdaterId()) && zzz.equal((Object)turnBasedMatch2.getLastUpdatedTimestamp(), (Object)turnBasedMatch.getLastUpdatedTimestamp()) && zzz.equal((Object)turnBasedMatch2.getPendingParticipantId(), (Object)turnBasedMatch.getPendingParticipantId()) && zzz.equal((Object)turnBasedMatch2.getStatus(), (Object)turnBasedMatch.getStatus()) && zzz.equal((Object)turnBasedMatch2.getTurnStatus(), (Object)turnBasedMatch.getTurnStatus()) && zzz.equal((Object)turnBasedMatch2.getDescription(), (Object)turnBasedMatch.getDescription()) && zzz.equal((Object)turnBasedMatch2.getVariant(), (Object)turnBasedMatch.getVariant()) && zzz.equal((Object)turnBasedMatch2.getVersion(), (Object)turnBasedMatch.getVersion()) && zzz.equal((Object)turnBasedMatch2.getParticipants(), (Object)turnBasedMatch.getParticipants()) && zzz.equal((Object)turnBasedMatch2.getRematchId(), (Object)turnBasedMatch.getRematchId()) && zzz.equal((Object)turnBasedMatch2.getMatchNumber(), (Object)turnBasedMatch.getMatchNumber()) && zzz.equal((Object)turnBasedMatch2.getAutoMatchCriteria(), (Object)turnBasedMatch.getAutoMatchCriteria()) && zzz.equal((Object)turnBasedMatch2.getAvailableAutoMatchSlots(), (Object)turnBasedMatch.getAvailableAutoMatchSlots()) && zzz.equal((Object)turnBasedMatch2.isLocallyModified(), (Object)turnBasedMatch.isLocallyModified());
    }

    public String toString() {
        return TurnBasedMatchEntity.zzb(this);
    }

    static String zzb(TurnBasedMatch turnBasedMatch) {
        return zzz.zzy((Object)turnBasedMatch).zzg("Game", (Object)turnBasedMatch.getGame()).zzg("MatchId", (Object)turnBasedMatch.getMatchId()).zzg("CreatorId", (Object)turnBasedMatch.getCreatorId()).zzg("CreationTimestamp", (Object)turnBasedMatch.getCreationTimestamp()).zzg("LastUpdaterId", (Object)turnBasedMatch.getLastUpdaterId()).zzg("LastUpdatedTimestamp", (Object)turnBasedMatch.getLastUpdatedTimestamp()).zzg("PendingParticipantId", (Object)turnBasedMatch.getPendingParticipantId()).zzg("MatchStatus", (Object)turnBasedMatch.getStatus()).zzg("TurnStatus", (Object)turnBasedMatch.getTurnStatus()).zzg("Description", (Object)turnBasedMatch.getDescription()).zzg("Variant", (Object)turnBasedMatch.getVariant()).zzg("Data", (Object)turnBasedMatch.getData()).zzg("Version", (Object)turnBasedMatch.getVersion()).zzg("Participants", (Object)turnBasedMatch.getParticipants()).zzg("RematchId", (Object)turnBasedMatch.getRematchId()).zzg("PreviousData", (Object)turnBasedMatch.getPreviousMatchData()).zzg("MatchNumber", (Object)turnBasedMatch.getMatchNumber()).zzg("AutoMatchCriteria", (Object)turnBasedMatch.getAutoMatchCriteria()).zzg("AvailableAutoMatchSlots", (Object)turnBasedMatch.getAvailableAutoMatchSlots()).zzg("LocallyModified", (Object)turnBasedMatch.isLocallyModified()).zzg("DescriptionParticipantId", (Object)turnBasedMatch.getDescriptionParticipantId()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        TurnBasedMatchEntityCreator.zza(this, parcel, n);
    }

    static int zza(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        String string2 = String.valueOf(turnBasedMatch.getMatchId());
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in match ").append(string2).toString());
    }

    static ArrayList<String> zzc(TurnBasedMatch turnBasedMatch) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String zzb(TurnBasedMatch turnBasedMatch, String string) {
        String string2 = null;
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant zzc(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        String string2 = String.valueOf(turnBasedMatch.getMatchId());
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in match ").append(string2).toString());
    }
}

