/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotContentsEntity;
import com.google.android.gms.games.snapshot.SnapshotEntityCreator;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;

public final class SnapshotEntity
extends AbstractSafeParcelable
implements Snapshot {
    public static final Parcelable.Creator<SnapshotEntity> CREATOR = new SnapshotEntityCreator();
    private final int mVersionCode;
    private final SnapshotMetadataEntity zzaRM;
    private final SnapshotContentsEntity zzaRN;

    public SnapshotEntity(SnapshotMetadata snapshotMetadata, SnapshotContentsEntity snapshotContentsEntity) {
        this(2, snapshotMetadata, snapshotContentsEntity);
    }

    SnapshotEntity(int n, SnapshotMetadata snapshotMetadata, SnapshotContentsEntity snapshotContentsEntity) {
        this.mVersionCode = n;
        this.zzaRM = new SnapshotMetadataEntity(snapshotMetadata);
        this.zzaRN = snapshotContentsEntity;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public SnapshotMetadata getMetadata() {
        return this.zzaRM;
    }

    @Override
    public SnapshotContents getSnapshotContents() {
        return this.isClosed() ? null : this.zzaRN;
    }

    private boolean isClosed() {
        return this.zzaRN.isClosed();
    }

    public Snapshot freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return SnapshotEntity.zzb(this);
    }

    static int zzb(Snapshot snapshot) {
        return zzz.hashCode((Object[])new Object[]{snapshot.getMetadata(), snapshot.getSnapshotContents()});
    }

    public boolean equals(Object object) {
        return SnapshotEntity.zza(this, object);
    }

    static boolean zza(Snapshot snapshot, Object object) {
        if (!(object instanceof Snapshot)) {
            return false;
        }
        if (snapshot == object) {
            return true;
        }
        Snapshot snapshot2 = (Snapshot)object;
        return zzz.equal((Object)snapshot2.getMetadata(), (Object)snapshot.getMetadata()) && zzz.equal((Object)snapshot2.getSnapshotContents(), (Object)snapshot.getSnapshotContents());
    }

    public String toString() {
        return SnapshotEntity.zzc(this);
    }

    static String zzc(Snapshot snapshot) {
        return zzz.zzy((Object)snapshot).zzg("Metadata", (Object)snapshot.getMetadata()).zzg("HasContents", (Object)(snapshot.getSnapshotContents() != null ? 1 : 0)).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        SnapshotEntityCreator.zza(this, parcel, n);
    }
}

