/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.graphics.Bitmap;
import android.net.Uri;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeEntity;

public interface SnapshotMetadataChange {
    public static final SnapshotMetadataChange EMPTY_CHANGE = new SnapshotMetadataChangeEntity();

    public String getDescription();

    public Long getPlayedTimeMillis();

    public BitmapTeleporter zzBy();

    public Bitmap getCoverImage();

    public Long getProgressValue();

    public static final class Builder {
        private String zzVw;
        private Long zzaRO;
        private Long zzaRP;
        private BitmapTeleporter zzaRQ;
        private Uri zzaRR;

        public Builder setDescription(String string) {
            this.zzVw = string;
            return this;
        }

        public Builder setPlayedTimeMillis(long l) {
            this.zzaRO = l;
            return this;
        }

        public Builder setProgressValue(long l) {
            this.zzaRP = l;
            return this;
        }

        public Builder setCoverImage(Bitmap bitmap) {
            this.zzaRQ = new BitmapTeleporter(bitmap);
            this.zzaRR = null;
            return this;
        }

        public Builder fromMetadata(SnapshotMetadata snapshotMetadata) {
            this.zzVw = snapshotMetadata.getDescription();
            this.zzaRO = snapshotMetadata.getPlayedTime();
            this.zzaRP = snapshotMetadata.getProgressValue();
            if (this.zzaRO == -1L) {
                this.zzaRO = null;
            }
            this.zzaRR = snapshotMetadata.getCoverImageUri();
            if (this.zzaRR != null) {
                this.zzaRQ = null;
            }
            return this;
        }

        public SnapshotMetadataChange build() {
            return new SnapshotMetadataChangeEntity(this.zzVw, this.zzaRO, this.zzaRQ, this.zzaRR, this.zzaRP);
        }
    }
}

