/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.games.video.VideoConfigurationCreator;

public final class VideoConfiguration
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<VideoConfiguration> CREATOR = new VideoConfigurationCreator();
    public static final int QUALITY_LEVEL_FULLHD = 3;
    public static final int QUALITY_LEVEL_XHD = 2;
    public static final int QUALITY_LEVEL_HD = 1;
    public static final int QUALITY_LEVEL_SD = 0;
    public static final int QUALITY_LEVEL_UNKNOWN = -1;
    public static final int NUM_QUALITY_LEVEL = 4;
    public static final int CAPTURE_MODE_UNKNOWN = -1;
    public static final int CAPTURE_MODE_FILE = 0;
    public static final int CAPTURE_MODE_STREAM = 1;
    public static final int NUM_CAPTURE_MODE = 2;
    private final int mVersionCode;
    private final int zzaSB;
    private final int zzaSt;
    private final String zzaSC;
    private final String zzaSD;
    private final String zzaSE;
    private final String zzaSF;
    private final boolean zzaSG;

    private VideoConfiguration(int n, int n2, String string, String string2, String string3, String string4, boolean bl) {
        this(2, n, n2, string, string2, string3, string4, bl);
    }

    public VideoConfiguration(int n, int n2, int n3, String string, String string2, String string3, String string4, boolean bl) {
        this.mVersionCode = n;
        zzaa.zzaj((boolean)VideoConfiguration.isValidQualityLevel(n2, false));
        zzaa.zzaj((boolean)VideoConfiguration.isValidCaptureMode(n3, false));
        this.zzaSB = n2;
        this.zzaSt = n3;
        this.zzaSG = bl;
        if (n3 == 1) {
            this.zzaSD = string2;
            this.zzaSC = string;
            this.zzaSE = string3;
            this.zzaSF = string4;
        } else {
            zzaa.zzb((string2 == null ? 1 : 0) != 0, (Object)"Stream key should be null when not streaming");
            zzaa.zzb((string == null ? 1 : 0) != 0, (Object)"Stream url should be null when not streaming");
            zzaa.zzb((string3 == null ? 1 : 0) != 0, (Object)"Stream title should be null when not streaming");
            zzaa.zzb((string4 == null ? 1 : 0) != 0, (Object)"Stream description should be null when not streaming");
            this.zzaSD = null;
            this.zzaSC = null;
            this.zzaSE = null;
            this.zzaSF = null;
        }
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public int getQualityLevel() {
        return this.zzaSB;
    }

    public int getCaptureMode() {
        return this.zzaSt;
    }

    public String zzBG() {
        return this.zzaSD;
    }

    public String getStreamUrl() {
        return this.zzaSC;
    }

    public String zzBH() {
        return this.zzaSE;
    }

    public String zzBI() {
        return this.zzaSF;
    }

    public boolean zzBJ() {
        return this.zzaSG;
    }

    public void writeToParcel(Parcel parcel, int n) {
        VideoConfigurationCreator.zza(this, parcel, n);
    }

    public static boolean isValidQualityLevel(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static boolean isValidCaptureMode(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static final class Builder {
        private int zzaSB;
        private int zzaSt;
        private boolean zzaSG;
        private String zzaSC;
        private String zzaSD;
        private String zzaSE;
        private String zzaSF;

        public Builder(int n, int n2) {
            this.zzaSB = n;
            this.zzaSt = n2;
            this.zzaSG = true;
            this.zzaSC = null;
            this.zzaSD = null;
            this.zzaSE = null;
            this.zzaSF = null;
        }

        public Builder setQualityLevel(int n) {
            this.zzaSB = n;
            return this;
        }

        public Builder setCaptureMode(int n) {
            this.zzaSt = n;
            return this;
        }

        public VideoConfiguration build() {
            return new VideoConfiguration(this.zzaSB, this.zzaSt, null, null, null, null, this.zzaSG);
        }
    }
}

