/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntityCreator;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;

public final class GameEntity
extends GamesDowngradeableSafeParcel
implements Game {
    public static final Parcelable.Creator<GameEntity> CREATOR = new GameEntityCreatorCompat();
    private final int mVersionCode;
    private final String zzaeg;
    private final String zzaco;
    private final String zzaIR;
    private final String zzaIS;
    private final String zzVw;
    private final String zzaIT;
    private final Uri zzaIU;
    private final Uri zzaIV;
    private final Uri zzaIW;
    private final boolean zzaIX;
    private final boolean zzaIY;
    private final String zzaIZ;
    private final int zzaJa;
    private final int zzaJb;
    private final int zzaJc;
    private final boolean zzaJd;
    private final boolean zzaJe;
    private final String zzaJf;
    private final String zzaJg;
    private final String zzaJh;
    private final boolean zzGX;
    private final boolean zzaJi;
    private final boolean zzaJj;
    private final String zzaJk;
    private final boolean zzaJl;

    public GameEntity(Game game) {
        this.mVersionCode = 7;
        this.zzaeg = game.getApplicationId();
        this.zzaIR = game.getPrimaryCategory();
        this.zzaIS = game.getSecondaryCategory();
        this.zzVw = game.getDescription();
        this.zzaIT = game.getDeveloperName();
        this.zzaco = game.getDisplayName();
        this.zzaIU = game.getIconImageUri();
        this.zzaJf = game.getIconImageUrl();
        this.zzaIV = game.getHiResImageUri();
        this.zzaJg = game.getHiResImageUrl();
        this.zzaIW = game.getFeaturedImageUri();
        this.zzaJh = game.getFeaturedImageUrl();
        this.zzaIX = game.zzyJ();
        this.zzaIY = game.zzyL();
        this.zzaIZ = game.zzyM();
        this.zzaJa = 1;
        this.zzaJb = game.getAchievementTotalCount();
        this.zzaJc = game.getLeaderboardCount();
        this.zzaJd = game.isRealTimeMultiplayerEnabled();
        this.zzaJe = game.isTurnBasedMultiplayerEnabled();
        this.zzGX = game.isMuted();
        this.zzaJi = game.zzyK();
        this.zzaJj = game.areSnapshotsEnabled();
        this.zzaJk = game.getThemeColor();
        this.zzaJl = game.hasGamepadSupport();
    }

    GameEntity(int n, String string, String string2, String string3, String string4, String string5, String string6, Uri uri, Uri uri2, Uri uri3, boolean bl, boolean bl2, String string7, int n2, int n3, int n4, boolean bl3, boolean bl4, String string8, String string9, String string10, boolean bl5, boolean bl6, boolean bl7, String string11, boolean bl8) {
        this.mVersionCode = n;
        this.zzaeg = string;
        this.zzaco = string2;
        this.zzaIR = string3;
        this.zzaIS = string4;
        this.zzVw = string5;
        this.zzaIT = string6;
        this.zzaIU = uri;
        this.zzaJf = string8;
        this.zzaIV = uri2;
        this.zzaJg = string9;
        this.zzaIW = uri3;
        this.zzaJh = string10;
        this.zzaIX = bl;
        this.zzaIY = bl2;
        this.zzaIZ = string7;
        this.zzaJa = n2;
        this.zzaJb = n3;
        this.zzaJc = n4;
        this.zzaJd = bl3;
        this.zzaJe = bl4;
        this.zzGX = bl5;
        this.zzaJi = bl6;
        this.zzaJj = bl7;
        this.zzaJk = string11;
        this.zzaJl = bl8;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getApplicationId() {
        return this.zzaeg;
    }

    @Override
    public String getDisplayName() {
        return this.zzaco;
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzaco, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getPrimaryCategory() {
        return this.zzaIR;
    }

    @Override
    public String getSecondaryCategory() {
        return this.zzaIS;
    }

    @Override
    public String getDescription() {
        return this.zzVw;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzVw, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDeveloperName() {
        return this.zzaIT;
    }

    @Override
    public void getDeveloperName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzaIT, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzaIU;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzaJf;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzaIV;
    }

    @Override
    public String getHiResImageUrl() {
        return this.zzaJg;
    }

    @Override
    public Uri getFeaturedImageUri() {
        return this.zzaIW;
    }

    @Override
    public String getFeaturedImageUrl() {
        return this.zzaJh;
    }

    @Override
    public boolean isMuted() {
        return this.zzGX;
    }

    @Override
    public boolean zzyK() {
        return this.zzaJi;
    }

    @Override
    public boolean zzyJ() {
        return this.zzaIX;
    }

    @Override
    public boolean zzyL() {
        return this.zzaIY;
    }

    @Override
    public String zzyM() {
        return this.zzaIZ;
    }

    public int zzyN() {
        return this.zzaJa;
    }

    @Override
    public int getAchievementTotalCount() {
        return this.zzaJb;
    }

    @Override
    public int getLeaderboardCount() {
        return this.zzaJc;
    }

    @Override
    public boolean isRealTimeMultiplayerEnabled() {
        return this.zzaJd;
    }

    @Override
    public boolean isTurnBasedMultiplayerEnabled() {
        return this.zzaJe;
    }

    @Override
    public boolean areSnapshotsEnabled() {
        return this.zzaJj;
    }

    @Override
    public String getThemeColor() {
        return this.zzaJk;
    }

    @Override
    public boolean hasGamepadSupport() {
        return this.zzaJl;
    }

    public Game freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameEntity.zza(this);
    }

    static int zza(Game game) {
        return zzz.hashCode((Object[])new Object[]{game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.zzyJ(), game.zzyL(), game.zzyM(), game.getAchievementTotalCount(), game.getLeaderboardCount(), game.isRealTimeMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled(), game.isMuted(), game.zzyK(), game.areSnapshotsEnabled(), game.getThemeColor(), game.hasGamepadSupport()});
    }

    public boolean equals(Object object) {
        return GameEntity.zza(this, object);
    }

    static boolean zza(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return zzz.equal((Object)game2.getApplicationId(), (Object)game.getApplicationId()) && zzz.equal((Object)game2.getDisplayName(), (Object)game.getDisplayName()) && zzz.equal((Object)game2.getPrimaryCategory(), (Object)game.getPrimaryCategory()) && zzz.equal((Object)game2.getSecondaryCategory(), (Object)game.getSecondaryCategory()) && zzz.equal((Object)game2.getDescription(), (Object)game.getDescription()) && zzz.equal((Object)game2.getDeveloperName(), (Object)game.getDeveloperName()) && zzz.equal((Object)game2.getIconImageUri(), (Object)game.getIconImageUri()) && zzz.equal((Object)game2.getHiResImageUri(), (Object)game.getHiResImageUri()) && zzz.equal((Object)game2.getFeaturedImageUri(), (Object)game.getFeaturedImageUri()) && zzz.equal((Object)game2.zzyJ(), (Object)game.zzyJ()) && zzz.equal((Object)game2.zzyL(), (Object)game.zzyL()) && zzz.equal((Object)game2.zzyM(), (Object)game.zzyM()) && zzz.equal((Object)game2.getAchievementTotalCount(), (Object)game.getAchievementTotalCount()) && zzz.equal((Object)game2.getLeaderboardCount(), (Object)game.getLeaderboardCount()) && zzz.equal((Object)game2.isRealTimeMultiplayerEnabled(), (Object)game.isRealTimeMultiplayerEnabled()) && zzz.equal((Object)game2.isTurnBasedMultiplayerEnabled(), (Object)(game.isTurnBasedMultiplayerEnabled() && zzz.equal((Object)game2.isMuted(), (Object)game.isMuted()) && zzz.equal((Object)game2.zzyK(), (Object)game.zzyK()) ? 1 : 0)) && zzz.equal((Object)game2.areSnapshotsEnabled(), (Object)game.areSnapshotsEnabled()) && zzz.equal((Object)game2.getThemeColor(), (Object)game.getThemeColor()) && zzz.equal((Object)game2.hasGamepadSupport(), (Object)game.hasGamepadSupport());
    }

    public String toString() {
        return GameEntity.zzb(this);
    }

    static String zzb(Game game) {
        return zzz.zzy((Object)game).zzg("ApplicationId", (Object)game.getApplicationId()).zzg("DisplayName", (Object)game.getDisplayName()).zzg("PrimaryCategory", (Object)game.getPrimaryCategory()).zzg("SecondaryCategory", (Object)game.getSecondaryCategory()).zzg("Description", (Object)game.getDescription()).zzg("DeveloperName", (Object)game.getDeveloperName()).zzg("IconImageUri", (Object)game.getIconImageUri()).zzg("IconImageUrl", (Object)game.getIconImageUrl()).zzg("HiResImageUri", (Object)game.getHiResImageUri()).zzg("HiResImageUrl", (Object)game.getHiResImageUrl()).zzg("FeaturedImageUri", (Object)game.getFeaturedImageUri()).zzg("FeaturedImageUrl", (Object)game.getFeaturedImageUrl()).zzg("PlayEnabledGame", (Object)game.zzyJ()).zzg("InstanceInstalled", (Object)game.zzyL()).zzg("InstancePackageName", (Object)game.zzyM()).zzg("AchievementTotalCount", (Object)game.getAchievementTotalCount()).zzg("LeaderboardCount", (Object)game.getLeaderboardCount()).zzg("RealTimeMultiplayerEnabled", (Object)game.isRealTimeMultiplayerEnabled()).zzg("TurnBasedMultiplayerEnabled", (Object)game.isTurnBasedMultiplayerEnabled()).zzg("AreSnapshotsEnabled", (Object)game.areSnapshotsEnabled()).zzg("ThemeColor", (Object)game.getThemeColor()).zzg("HasGamepadSupport", (Object)game.hasGamepadSupport()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (!this.zztG()) {
            GameEntityCreator.zza(this, parcel, n);
        } else {
            parcel.writeString(this.zzaeg);
            parcel.writeString(this.zzaco);
            parcel.writeString(this.zzaIR);
            parcel.writeString(this.zzaIS);
            parcel.writeString(this.zzVw);
            parcel.writeString(this.zzaIT);
            parcel.writeString(this.zzaIU == null ? null : this.zzaIU.toString());
            parcel.writeString(this.zzaIV == null ? null : this.zzaIV.toString());
            parcel.writeString(this.zzaIW == null ? null : this.zzaIW.toString());
            parcel.writeInt(this.zzaIX ? 1 : 0);
            parcel.writeInt(this.zzaIY ? 1 : 0);
            parcel.writeString(this.zzaIZ);
            parcel.writeInt(this.zzaJa);
            parcel.writeInt(this.zzaJb);
            parcel.writeInt(this.zzaJc);
        }
    }

    static final class GameEntityCreatorCompat
    extends GameEntityCreator {
        GameEntityCreatorCompat() {
        }

        @Override
        public GameEntity zzea(Parcel parcel) {
            boolean bl = GameEntity.zzf(GameEntity.zztF());
            if (bl || GameEntity.zzde((String)GameEntity.class.getCanonicalName())) {
                return super.zzea(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            String string7 = parcel.readString();
            Uri uri = string7 == null ? null : Uri.parse((String)string7);
            String string8 = parcel.readString();
            Uri uri2 = string8 == null ? null : Uri.parse((String)string8);
            String string9 = parcel.readString();
            Uri uri3 = string9 == null ? null : Uri.parse((String)string9);
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            String string10 = parcel.readString();
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            boolean bl4 = false;
            boolean bl5 = false;
            Object var23_23 = null;
            Object var24_24 = null;
            Object var25_25 = null;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            Object var29_29 = null;
            boolean bl9 = false;
            return new GameEntity(7, string, string2, string3, string4, string5, string6, uri, uri2, uri3, bl2, bl3, string10, n, n2, n3, false, false, null, null, null, false, false, false, null, false);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzea(parcel);
        }
    }
}

