/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.PlayerLevel;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoRef;
import com.google.android.gms.games.internal.player.PlayerColumnNames;

public final class PlayerRef
extends zzc
implements Player {
    private final PlayerColumnNames zzaJZ;
    private final PlayerLevelInfo zzaJI;
    private final MostRecentGameInfoRef zzaKa;

    public PlayerRef(DataHolder dataHolder, int n) {
        this(dataHolder, n, null);
    }

    public PlayerRef(DataHolder dataHolder, int n, String string) {
        super(dataHolder, n);
        this.zzaJZ = new PlayerColumnNames(string);
        this.zzaKa = new MostRecentGameInfoRef(dataHolder, n, this.zzaJZ);
        if (this.zzyX()) {
            PlayerLevel playerLevel;
            int n2 = this.getInteger(this.zzaJZ.zzaPw);
            int n3 = this.getInteger(this.zzaJZ.zzaPz);
            PlayerLevel playerLevel2 = playerLevel = new PlayerLevel(n2, this.getLong(this.zzaJZ.zzaPx), this.getLong(this.zzaJZ.zzaPy));
            if (n2 != n3) {
                playerLevel2 = new PlayerLevel(n3, this.getLong(this.zzaJZ.zzaPy), this.getLong(this.zzaJZ.zzaPA));
            }
            this.zzaJI = new PlayerLevelInfo(this.getLong(this.zzaJZ.zzaPv), this.getLong(this.zzaJZ.zzaPB), playerLevel, playerLevel2);
        } else {
            this.zzaJI = null;
        }
    }

    @Override
    public String getPlayerId() {
        return this.getString(this.zzaJZ.zzaPm);
    }

    @Override
    public String getDisplayName() {
        return this.getString(this.zzaJZ.zzaPn);
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        this.zza(this.zzaJZ.zzaPn, charArrayBuffer);
    }

    @Override
    public String zzyQ() {
        return this.getString(this.zzaJZ.zzaPL);
    }

    @Override
    public String getName() {
        return this.getString(this.zzaJZ.name);
    }

    @Override
    public boolean zzyR() {
        return this.getBoolean(this.zzaJZ.zzaPK);
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzcZ(this.zzaJZ.zzaPo);
    }

    @Override
    public String getIconImageUrl() {
        return this.getString(this.zzaJZ.zzaPp);
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzcZ(this.zzaJZ.zzaPq);
    }

    @Override
    public String getHiResImageUrl() {
        return this.getString(this.zzaJZ.zzaPr);
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.getLong(this.zzaJZ.zzaPs);
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        if (!this.zzcY(this.zzaJZ.zzaPu) || this.zzda(this.zzaJZ.zzaPu)) {
            return -1L;
        }
        return this.getLong(this.zzaJZ.zzaPu);
    }

    @Override
    public int zzyS() {
        return this.getInteger(this.zzaJZ.zzaPt);
    }

    @Override
    public boolean zzyT() {
        return this.getBoolean(this.zzaJZ.zzaPD);
    }

    @Override
    public String getTitle() {
        return this.getString(this.zzaJZ.title);
    }

    @Override
    public void getTitle(CharArrayBuffer charArrayBuffer) {
        this.zza(this.zzaJZ.title, charArrayBuffer);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.zzaJI;
    }

    @Override
    public MostRecentGameInfo zzyU() {
        if (this.zzda(this.zzaJZ.zzaPE)) {
            return null;
        }
        return this.zzaKa;
    }

    @Override
    public Uri getBannerImageLandscapeUri() {
        return this.zzcZ(this.zzaJZ.zzaPM);
    }

    @Override
    public String getBannerImageLandscapeUrl() {
        return this.getString(this.zzaJZ.zzaPN);
    }

    @Override
    public Uri getBannerImagePortraitUri() {
        return this.zzcZ(this.zzaJZ.zzaPO);
    }

    @Override
    public String getBannerImagePortraitUrl() {
        return this.getString(this.zzaJZ.zzaPP);
    }

    @Override
    public int zzyV() {
        return this.getInteger(this.zzaJZ.zzaPQ);
    }

    @Override
    public long zzyW() {
        return this.getLong(this.zzaJZ.zzaPR);
    }

    @Override
    public boolean isMuted() {
        return this.getBoolean(this.zzaJZ.zzaPS);
    }

    public Player freeze() {
        return new PlayerEntity(this);
    }

    public int hashCode() {
        return PlayerEntity.zzb(this);
    }

    public boolean equals(Object object) {
        return PlayerEntity.zza(this, object);
    }

    public String toString() {
        return PlayerEntity.zzc(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        PlayerEntity playerEntity = (PlayerEntity)((Player)this.freeze());
        playerEntity.writeToParcel(parcel, n);
    }

    private boolean zzyX() {
        if (this.zzda(this.zzaJZ.zzaPv)) {
            return false;
        }
        return this.getLong(this.zzaJZ.zzaPv) != -1L;
    }
}

