/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.game;

import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.game.GameBadge;
import com.google.android.gms.games.internal.game.GameBadgeEntityCreator;

public final class GameBadgeEntity
extends GamesDowngradeableSafeParcel
implements GameBadge {
    public static final GameBadgeEntityCreator CREATOR = new GameBadgeEntityCreatorCompat();
    private final int mVersionCode;
    private int zzagd;
    private String zzavG;
    private String zzVw;
    private Uri zzaIU;

    public GameBadgeEntity(GameBadge gameBadge) {
        this.mVersionCode = 1;
        this.zzagd = gameBadge.getType();
        this.zzavG = gameBadge.getTitle();
        this.zzVw = gameBadge.getDescription();
        this.zzaIU = gameBadge.getIconImageUri();
    }

    GameBadgeEntity(int n, int n2, String string, String string2, Uri uri) {
        this.mVersionCode = n;
        this.zzagd = n2;
        this.zzavG = string;
        this.zzVw = string2;
        this.zzaIU = uri;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public int getType() {
        return this.zzagd;
    }

    @Override
    public String getTitle() {
        return this.zzavG;
    }

    @Override
    public String getDescription() {
        return this.zzVw;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzaIU;
    }

    public GameBadge zzAO() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameBadgeEntity.zza(this);
    }

    static int zza(GameBadge gameBadge) {
        return zzz.hashCode((Object[])new Object[]{gameBadge.getType(), gameBadge.getTitle(), gameBadge.getDescription(), gameBadge.getIconImageUri()});
    }

    public boolean equals(Object object) {
        return GameBadgeEntity.zza(this, object);
    }

    static boolean zza(GameBadge gameBadge, Object object) {
        if (!(object instanceof GameBadge)) {
            return false;
        }
        if (gameBadge == object) {
            return true;
        }
        GameBadge gameBadge2 = (GameBadge)object;
        return zzz.equal((Object)gameBadge2.getType(), (Object)gameBadge.getTitle()) && zzz.equal((Object)gameBadge2.getDescription(), (Object)gameBadge.getIconImageUri());
    }

    public String toString() {
        return GameBadgeEntity.zzb(this);
    }

    static String zzb(GameBadge gameBadge) {
        return zzz.zzy((Object)gameBadge).zzg("Type", (Object)gameBadge.getType()).zzg("Title", (Object)gameBadge.getTitle()).zzg("Description", (Object)gameBadge.getDescription()).zzg("IconImageUri", (Object)gameBadge.getIconImageUri()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (!this.zztG()) {
            GameBadgeEntityCreator.zza(this, parcel, n);
        } else {
            parcel.writeInt(this.zzagd);
            parcel.writeString(this.zzavG);
            parcel.writeString(this.zzVw);
            parcel.writeString(this.zzaIU == null ? null : this.zzaIU.toString());
        }
    }

    public /* synthetic */ Object freeze() {
        return this.zzAO();
    }

    static final class GameBadgeEntityCreatorCompat
    extends GameBadgeEntityCreator {
        GameBadgeEntityCreatorCompat() {
        }

        @Override
        public GameBadgeEntity zzeo(Parcel parcel) {
            boolean bl = GameBadgeEntity.zzf(GameBadgeEntity.zztF());
            if (bl || GameBadgeEntity.zzde((String)GameBadgeEntity.class.getCanonicalName())) {
                return super.zzeo(parcel);
            }
            int n = parcel.readInt();
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            return new GameBadgeEntity(1, n, string, string2, uri);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzeo(parcel);
        }
    }
}

