/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationEntityCreator;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import java.util.ArrayList;

public final class InvitationEntity
extends GamesDowngradeableSafeParcel
implements Invitation {
    public static final Parcelable.Creator<InvitationEntity> CREATOR = new InvitationEntityCreatorCompat();
    private final int mVersionCode;
    private final GameEntity zzaOX;
    private final String zzaaF;
    private final long zzaQH;
    private final int zzaQI;
    private final ParticipantEntity zzaQJ;
    private final ArrayList<ParticipantEntity> zzaQK;
    private final int zzaQL;
    private final int zzaQM;

    InvitationEntity(Invitation invitation) {
        this.mVersionCode = 2;
        this.zzaOX = new GameEntity(invitation.getGame());
        this.zzaaF = invitation.getInvitationId();
        this.zzaQH = invitation.getCreationTimestamp();
        this.zzaQI = invitation.getInvitationType();
        this.zzaQL = invitation.getVariant();
        this.zzaQM = invitation.getAvailableAutoMatchSlots();
        String string = invitation.getInviter().getParticipantId();
        Participant participant = null;
        ArrayList arrayList = invitation.getParticipants();
        int n = arrayList.size();
        this.zzaQK = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Participant participant2 = (Participant)arrayList.get(i);
            if (participant2.getParticipantId().equals(string)) {
                participant = participant2;
            }
            this.zzaQK.add((ParticipantEntity)participant2.freeze());
        }
        zzaa.zzb(participant, (Object)"Must have a valid inviter!");
        this.zzaQJ = (ParticipantEntity)participant.freeze();
    }

    InvitationEntity(int n, GameEntity gameEntity, String string, long l, int n2, ParticipantEntity participantEntity, ArrayList<ParticipantEntity> arrayList, int n3, int n4) {
        this.mVersionCode = n;
        this.zzaOX = gameEntity;
        this.zzaaF = string;
        this.zzaQH = l;
        this.zzaQI = n2;
        this.zzaQJ = participantEntity;
        this.zzaQK = arrayList;
        this.zzaQL = n3;
        this.zzaQM = n4;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public Game getGame() {
        return this.zzaOX;
    }

    @Override
    public String getInvitationId() {
        return this.zzaaF;
    }

    @Override
    public Participant getInviter() {
        return this.zzaQJ;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzaQH;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzaQK);
    }

    @Override
    public int getInvitationType() {
        return this.zzaQI;
    }

    @Override
    public int getVariant() {
        return this.zzaQL;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        return this.zzaQM;
    }

    public Invitation freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return InvitationEntity.zza(this);
    }

    static int zza(Invitation invitation) {
        return zzz.hashCode((Object[])new Object[]{invitation.getGame(), invitation.getInvitationId(), invitation.getCreationTimestamp(), invitation.getInvitationType(), invitation.getInviter(), invitation.getParticipants(), invitation.getVariant(), invitation.getAvailableAutoMatchSlots()});
    }

    public boolean equals(Object object) {
        return InvitationEntity.zza(this, object);
    }

    static boolean zza(Invitation invitation, Object object) {
        if (!(object instanceof Invitation)) {
            return false;
        }
        if (invitation == object) {
            return true;
        }
        Invitation invitation2 = (Invitation)object;
        return zzz.equal((Object)invitation2.getGame(), (Object)invitation.getGame()) && zzz.equal((Object)invitation2.getInvitationId(), (Object)invitation.getInvitationId()) && zzz.equal((Object)invitation2.getCreationTimestamp(), (Object)invitation.getCreationTimestamp()) && zzz.equal((Object)invitation2.getInvitationType(), (Object)invitation.getInvitationType()) && zzz.equal((Object)invitation2.getInviter(), (Object)invitation.getInviter()) && zzz.equal((Object)invitation2.getParticipants(), (Object)invitation.getParticipants()) && zzz.equal((Object)invitation2.getVariant(), (Object)invitation.getVariant()) && zzz.equal((Object)invitation2.getAvailableAutoMatchSlots(), (Object)invitation.getAvailableAutoMatchSlots());
    }

    public String toString() {
        return InvitationEntity.zzb(this);
    }

    static String zzb(Invitation invitation) {
        return zzz.zzy((Object)invitation).zzg("Game", (Object)invitation.getGame()).zzg("InvitationId", (Object)invitation.getInvitationId()).zzg("CreationTimestamp", (Object)invitation.getCreationTimestamp()).zzg("InvitationType", (Object)invitation.getInvitationType()).zzg("Inviter", (Object)invitation.getInviter()).zzg("Participants", (Object)invitation.getParticipants()).zzg("Variant", (Object)invitation.getVariant()).zzg("AvailableAutoMatchSlots", (Object)invitation.getAvailableAutoMatchSlots()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (!this.zztG()) {
            InvitationEntityCreator.zza(this, parcel, n);
        } else {
            this.zzaOX.writeToParcel(parcel, n);
            parcel.writeString(this.zzaaF);
            parcel.writeLong(this.zzaQH);
            parcel.writeInt(this.zzaQI);
            this.zzaQJ.writeToParcel(parcel, n);
            int n2 = this.zzaQK.size();
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                this.zzaQK.get(i).writeToParcel(parcel, n);
            }
        }
    }

    static final class InvitationEntityCreatorCompat
    extends InvitationEntityCreator {
        InvitationEntityCreatorCompat() {
        }

        @Override
        public InvitationEntity zzeu(Parcel parcel) {
            int n;
            boolean bl = InvitationEntity.zzf(InvitationEntity.zztF());
            if (bl || InvitationEntity.zzde((String)InvitationEntity.class.getCanonicalName())) {
                return super.zzeu(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            String string = parcel.readString();
            long l = parcel.readLong();
            int n2 = parcel.readInt();
            ParticipantEntity participantEntity = (ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel);
            int n3 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n3);
            for (n = 0; n < n3; ++n) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n = -1;
            boolean bl2 = false;
            return new InvitationEntity(2, gameEntity, string, l, n2, participantEntity, arrayList, -1, 0);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzeu(parcel);
        }
    }
}

