/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.os.Bundle;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RoomConfigImpl;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class RoomConfig {
    protected RoomConfig() {
    }

    public abstract RoomUpdateListener getRoomUpdateListener();

    public abstract String getInvitationId();

    public abstract RoomStatusUpdateListener getRoomStatusUpdateListener();

    public abstract RealTimeMessageReceivedListener getMessageReceivedListener();

    public abstract int getVariant();

    public abstract String[] getInvitedPlayerIds();

    public abstract Bundle getAutoMatchCriteria();

    public static Builder builder(RoomUpdateListener roomUpdateListener) {
        return new Builder(roomUpdateListener);
    }

    public static Bundle createAutoMatchCriteria(int n, int n2, long l) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", n);
        bundle.putInt("max_automatch_players", n2);
        bundle.putLong("exclusive_bit_mask", l);
        return bundle;
    }

    public static final class Builder {
        final RoomUpdateListener zzaQW;
        RoomStatusUpdateListener zzaQX;
        RealTimeMessageReceivedListener zzaQY;
        String zzaQZ = null;
        int zzaQL = -1;
        ArrayList<String> zzaRa = new ArrayList();
        Bundle zzaRb;

        private Builder(RoomUpdateListener roomUpdateListener) {
            this.zzaQW = (RoomUpdateListener)zzaa.zzb((Object)roomUpdateListener, (Object)"Must provide a RoomUpdateListener");
        }

        public Builder setInvitationIdToAccept(String string) {
            zzaa.zzz((Object)string);
            this.zzaQZ = string;
            return this;
        }

        public Builder setRoomStatusUpdateListener(RoomStatusUpdateListener roomStatusUpdateListener) {
            this.zzaQX = roomStatusUpdateListener;
            return this;
        }

        public Builder setMessageReceivedListener(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            this.zzaQY = realTimeMessageReceivedListener;
            return this;
        }

        public Builder addPlayersToInvite(String ... stringArray) {
            zzaa.zzz((Object)stringArray);
            this.zzaRa.addAll(Arrays.asList(stringArray));
            return this;
        }

        public Builder addPlayersToInvite(ArrayList<String> arrayList) {
            zzaa.zzz(arrayList);
            this.zzaRa.addAll(arrayList);
            return this;
        }

        public Builder setVariant(int n) {
            zzaa.zzb((n == -1 || n > 0 ? 1 : 0) != 0, (Object)"Variant must be a positive integer or Room.ROOM_VARIANT_ANY");
            this.zzaQL = n;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle bundle) {
            this.zzaRb = bundle;
            return this;
        }

        public RoomConfig build() {
            return new RoomConfigImpl(this);
        }
    }
}

