/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.internal.constants.TurnBasedMatchTurnStatus;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;

public final class LoadMatchesResponse {
    private final InvitationBuffer zzaRg;
    private final TurnBasedMatchBuffer zzaRh;
    private final TurnBasedMatchBuffer zzaRi;
    private final TurnBasedMatchBuffer zzaRj;

    public LoadMatchesResponse(Bundle bundle) {
        DataHolder dataHolder = LoadMatchesResponse.zza(bundle, 0);
        this.zzaRg = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.zza(bundle, 1);
        this.zzaRh = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.zza(bundle, 2);
        this.zzaRi = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.zza(bundle, 3);
        this.zzaRj = dataHolder4 != null ? new TurnBasedMatchBuffer(dataHolder4) : null;
    }

    private static DataHolder zza(Bundle bundle, int n) {
        String string = TurnBasedMatchTurnStatus.zzgS(n);
        if (!bundle.containsKey(string)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string);
    }

    public InvitationBuffer getInvitations() {
        return this.zzaRg;
    }

    public TurnBasedMatchBuffer getMyTurnMatches() {
        return this.zzaRh;
    }

    public TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.zzaRi;
    }

    public TurnBasedMatchBuffer getCompletedMatches() {
        return this.zzaRj;
    }

    @Deprecated
    public void close() {
        this.release();
    }

    public void release() {
        if (this.zzaRg != null) {
            this.zzaRg.release();
        }
        if (this.zzaRh != null) {
            this.zzaRh.release();
        }
        if (this.zzaRi != null) {
            this.zzaRi.release();
        }
        if (this.zzaRj != null) {
            this.zzaRj.release();
        }
    }

    public boolean hasData() {
        if (this.zzaRg != null && this.zzaRg.getCount() > 0) {
            return true;
        }
        if (this.zzaRh != null && this.zzaRh.getCount() > 0) {
            return true;
        }
        if (this.zzaRi != null && this.zzaRi.getCount() > 0) {
            return true;
        }
        return this.zzaRj != null && this.zzaRj.getCount() > 0;
    }
}

