/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfigImpl;
import java.util.ArrayList;

public abstract class TurnBasedMatchConfig {
    protected TurnBasedMatchConfig() {
    }

    public abstract int getVariant();

    public abstract int zzBt();

    public abstract String[] getInvitedPlayerIds();

    public abstract Bundle getAutoMatchCriteria();

    public static Builder builder() {
        return new Builder();
    }

    public static Bundle createAutoMatchCriteria(int n, int n2, long l) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", n);
        bundle.putInt("max_automatch_players", n2);
        bundle.putLong("exclusive_bit_mask", l);
        return bundle;
    }

    public static final class Builder {
        int zzaQL = -1;
        ArrayList<String> zzaRa = new ArrayList();
        Bundle zzaRb = null;
        int zzaRk = 2;

        private Builder() {
        }

        public Builder addInvitedPlayer(String string) {
            zzaa.zzz((Object)string);
            this.zzaRa.add(string);
            return this;
        }

        public Builder addInvitedPlayers(ArrayList<String> arrayList) {
            zzaa.zzz(arrayList);
            this.zzaRa.addAll(arrayList);
            return this;
        }

        public Builder setVariant(int n) {
            zzaa.zzb((n == -1 || n > 0 ? 1 : 0) != 0, (Object)"Variant must be a positive integer or TurnBasedMatch.MATCH_VARIANT_ANY");
            this.zzaQL = n;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle bundle) {
            this.zzaRb = bundle;
            return this;
        }

        public TurnBasedMatchConfig build() {
            return new TurnBasedMatchConfigImpl(this);
        }
    }
}

