/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestEntityCreator;
import java.util.ArrayList;
import java.util.List;

public final class QuestEntity
extends AbstractSafeParcelable
implements Quest {
    public static final Parcelable.Creator<QuestEntity> CREATOR = new QuestEntityCreator();
    private final int mVersionCode;
    private final GameEntity zzaOX;
    private final String zzaRy;
    private final long zzaRz;
    private final Uri zzaRA;
    private final String zzaRB;
    private final String zzVw;
    private final long zzaRC;
    private final long zzaKl;
    private final Uri mIconUri;
    private final String zzaRD;
    private final String mName;
    private final long zzaRE;
    private final long zzaRF;
    private final int mState;
    private final int zzagd;
    private final ArrayList<MilestoneEntity> zzaRG;

    public QuestEntity(Quest quest) {
        this.mVersionCode = 2;
        this.zzaOX = new GameEntity(quest.getGame());
        this.zzaRy = quest.getQuestId();
        this.zzaRz = quest.getAcceptedTimestamp();
        this.zzVw = quest.getDescription();
        this.zzaRA = quest.getBannerImageUri();
        this.zzaRB = quest.getBannerImageUrl();
        this.zzaRC = quest.getEndTimestamp();
        this.mIconUri = quest.getIconImageUri();
        this.zzaRD = quest.getIconImageUrl();
        this.zzaKl = quest.getLastUpdatedTimestamp();
        this.mName = quest.getName();
        this.zzaRE = quest.zzBw();
        this.zzaRF = quest.getStartTimestamp();
        this.mState = quest.getState();
        this.zzagd = quest.getType();
        List<Milestone> list = quest.zzBv();
        int n = list.size();
        this.zzaRG = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzaRG.add((MilestoneEntity)list.get(i).freeze());
        }
    }

    QuestEntity(int n, GameEntity gameEntity, String string, long l, Uri uri, String string2, String string3, long l2, long l3, Uri uri2, String string4, String string5, long l4, long l5, int n2, int n3, ArrayList<MilestoneEntity> arrayList) {
        this.mVersionCode = n;
        this.zzaOX = gameEntity;
        this.zzaRy = string;
        this.zzaRz = l;
        this.zzaRA = uri;
        this.zzaRB = string2;
        this.zzVw = string3;
        this.zzaRC = l2;
        this.zzaKl = l3;
        this.mIconUri = uri2;
        this.zzaRD = string4;
        this.mName = string5;
        this.zzaRE = l4;
        this.zzaRF = l5;
        this.mState = n2;
        this.zzagd = n3;
        this.zzaRG = arrayList;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getQuestId() {
        return this.zzaRy;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDescription() {
        return this.zzVw;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzVw, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        return this.mIconUri;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzaRD;
    }

    @Override
    public Uri getBannerImageUri() {
        return this.zzaRA;
    }

    @Override
    public String getBannerImageUrl() {
        return this.zzaRB;
    }

    @Override
    public Milestone getCurrentMilestone() {
        return this.zzBv().get(0);
    }

    @Override
    public List<Milestone> zzBv() {
        return new ArrayList<Milestone>(this.zzaRG);
    }

    @Override
    public Game getGame() {
        return this.zzaOX;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getType() {
        return this.zzagd;
    }

    @Override
    public long getAcceptedTimestamp() {
        return this.zzaRz;
    }

    @Override
    public long getEndTimestamp() {
        return this.zzaRC;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzaKl;
    }

    @Override
    public long zzBw() {
        return this.zzaRE;
    }

    @Override
    public long getStartTimestamp() {
        return this.zzaRF;
    }

    @Override
    public boolean isEndingSoon() {
        return this.zzaRE <= System.currentTimeMillis() + 1800000L;
    }

    public Quest freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return QuestEntity.zza(this);
    }

    static int zza(Quest quest) {
        return zzz.hashCode((Object[])new Object[]{quest.getGame(), quest.getQuestId(), quest.getAcceptedTimestamp(), quest.getBannerImageUri(), quest.getDescription(), quest.getEndTimestamp(), quest.getIconImageUri(), quest.getLastUpdatedTimestamp(), quest.zzBv(), quest.getName(), quest.zzBw(), quest.getStartTimestamp(), quest.getState()});
    }

    public boolean equals(Object object) {
        return QuestEntity.zza(this, object);
    }

    static boolean zza(Quest quest, Object object) {
        if (!(object instanceof Quest)) {
            return false;
        }
        if (quest == object) {
            return true;
        }
        Quest quest2 = (Quest)object;
        return zzz.equal((Object)quest2.getGame(), (Object)quest.getGame()) && zzz.equal((Object)quest2.getQuestId(), (Object)quest.getQuestId()) && zzz.equal((Object)quest2.getAcceptedTimestamp(), (Object)quest.getAcceptedTimestamp()) && zzz.equal((Object)quest2.getBannerImageUri(), (Object)quest.getBannerImageUri()) && zzz.equal((Object)quest2.getDescription(), (Object)quest.getDescription()) && zzz.equal((Object)quest2.getEndTimestamp(), (Object)quest.getEndTimestamp()) && zzz.equal((Object)quest2.getIconImageUri(), (Object)quest.getIconImageUri()) && zzz.equal((Object)quest2.getLastUpdatedTimestamp(), (Object)quest.getLastUpdatedTimestamp()) && zzz.equal(quest2.zzBv(), quest.zzBv()) && zzz.equal((Object)quest2.getName(), (Object)quest.getName()) && zzz.equal((Object)quest2.zzBw(), (Object)quest.zzBw()) && zzz.equal((Object)quest2.getStartTimestamp(), (Object)quest.getStartTimestamp()) && zzz.equal((Object)quest2.getState(), (Object)quest.getState());
    }

    public String toString() {
        return QuestEntity.zzb(this);
    }

    static String zzb(Quest quest) {
        return zzz.zzy((Object)quest).zzg("Game", (Object)quest.getGame()).zzg("QuestId", (Object)quest.getQuestId()).zzg("AcceptedTimestamp", (Object)quest.getAcceptedTimestamp()).zzg("BannerImageUri", (Object)quest.getBannerImageUri()).zzg("BannerImageUrl", (Object)quest.getBannerImageUrl()).zzg("Description", (Object)quest.getDescription()).zzg("EndTimestamp", (Object)quest.getEndTimestamp()).zzg("IconImageUri", (Object)quest.getIconImageUri()).zzg("IconImageUrl", (Object)quest.getIconImageUrl()).zzg("LastUpdatedTimestamp", (Object)quest.getLastUpdatedTimestamp()).zzg("Milestones", quest.zzBv()).zzg("Name", (Object)quest.getName()).zzg("NotifyTimestamp", (Object)quest.zzBw()).zzg("StartTimestamp", (Object)quest.getStartTimestamp()).zzg("State", (Object)quest.getState()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        QuestEntityCreator.zza(this, parcel, n);
    }
}

