/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntityCreator;

public final class SnapshotMetadataEntity
extends AbstractSafeParcelable
implements SnapshotMetadata {
    public static final Parcelable.Creator<SnapshotMetadataEntity> CREATOR = new SnapshotMetadataEntityCreator();
    private final int mVersionCode;
    private final GameEntity zzaOX;
    private final PlayerEntity zzaRU;
    private final String zzaLo;
    private final Uri zzaRR;
    private final String zzaRV;
    private final String zzavG;
    private final String zzVw;
    private final long zzaRW;
    private final long zzaRX;
    private final float zzaRY;
    private final String zzaRZ;
    private final boolean zzaSa;
    private final long zzaSb;
    private final String zzaSc;

    public SnapshotMetadataEntity(SnapshotMetadata snapshotMetadata) {
        this.mVersionCode = 6;
        this.zzaOX = new GameEntity(snapshotMetadata.getGame());
        this.zzaRU = new PlayerEntity(snapshotMetadata.getOwner());
        this.zzaLo = snapshotMetadata.getSnapshotId();
        this.zzaRR = snapshotMetadata.getCoverImageUri();
        this.zzaRV = snapshotMetadata.getCoverImageUrl();
        this.zzaRY = snapshotMetadata.getCoverImageAspectRatio();
        this.zzavG = snapshotMetadata.getTitle();
        this.zzVw = snapshotMetadata.getDescription();
        this.zzaRW = snapshotMetadata.getLastModifiedTimestamp();
        this.zzaRX = snapshotMetadata.getPlayedTime();
        this.zzaRZ = snapshotMetadata.getUniqueName();
        this.zzaSa = snapshotMetadata.hasChangePending();
        this.zzaSb = snapshotMetadata.getProgressValue();
        this.zzaSc = snapshotMetadata.getDeviceName();
    }

    SnapshotMetadataEntity(int n, GameEntity gameEntity, PlayerEntity playerEntity, String string, Uri uri, String string2, String string3, String string4, long l, long l2, float f, String string5, boolean bl, long l3, String string6) {
        this.mVersionCode = n;
        this.zzaOX = gameEntity;
        this.zzaRU = playerEntity;
        this.zzaLo = string;
        this.zzaRR = uri;
        this.zzaRV = string2;
        this.zzaRY = f;
        this.zzavG = string3;
        this.zzVw = string4;
        this.zzaRW = l;
        this.zzaRX = l2;
        this.zzaRZ = string5;
        this.zzaSa = bl;
        this.zzaSb = l3;
        this.zzaSc = string6;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public Game getGame() {
        return this.zzaOX;
    }

    @Override
    public Player getOwner() {
        return this.zzaRU;
    }

    @Override
    public String getSnapshotId() {
        return this.zzaLo;
    }

    @Override
    public Uri getCoverImageUri() {
        return this.zzaRR;
    }

    @Override
    public String getCoverImageUrl() {
        return this.zzaRV;
    }

    @Override
    public float getCoverImageAspectRatio() {
        return this.zzaRY;
    }

    @Override
    public String getUniqueName() {
        return this.zzaRZ;
    }

    @Override
    public String getTitle() {
        return this.zzavG;
    }

    @Override
    public String getDescription() {
        return this.zzVw;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzVw, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public long getLastModifiedTimestamp() {
        return this.zzaRW;
    }

    @Override
    public long getPlayedTime() {
        return this.zzaRX;
    }

    @Override
    public boolean hasChangePending() {
        return this.zzaSa;
    }

    @Override
    public long getProgressValue() {
        return this.zzaSb;
    }

    @Override
    public String getDeviceName() {
        return this.zzaSc;
    }

    public SnapshotMetadata freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return SnapshotMetadataEntity.zza(this);
    }

    static int zza(SnapshotMetadata snapshotMetadata) {
        return zzz.hashCode((Object[])new Object[]{snapshotMetadata.getGame(), snapshotMetadata.getOwner(), snapshotMetadata.getSnapshotId(), snapshotMetadata.getCoverImageUri(), Float.valueOf(snapshotMetadata.getCoverImageAspectRatio()), snapshotMetadata.getTitle(), snapshotMetadata.getDescription(), snapshotMetadata.getLastModifiedTimestamp(), snapshotMetadata.getPlayedTime(), snapshotMetadata.getUniqueName(), snapshotMetadata.hasChangePending(), snapshotMetadata.getProgressValue(), snapshotMetadata.getDeviceName()});
    }

    public boolean equals(Object object) {
        return SnapshotMetadataEntity.zza(this, object);
    }

    static boolean zza(SnapshotMetadata snapshotMetadata, Object object) {
        if (!(object instanceof SnapshotMetadata)) {
            return false;
        }
        if (snapshotMetadata == object) {
            return true;
        }
        SnapshotMetadata snapshotMetadata2 = (SnapshotMetadata)object;
        return zzz.equal((Object)snapshotMetadata2.getGame(), (Object)snapshotMetadata.getGame()) && zzz.equal((Object)snapshotMetadata2.getOwner(), (Object)snapshotMetadata.getOwner()) && zzz.equal((Object)snapshotMetadata2.getSnapshotId(), (Object)snapshotMetadata.getSnapshotId()) && zzz.equal((Object)snapshotMetadata2.getCoverImageUri(), (Object)snapshotMetadata.getCoverImageUri()) && zzz.equal((Object)Float.valueOf(snapshotMetadata2.getCoverImageAspectRatio()), (Object)Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())) && zzz.equal((Object)snapshotMetadata2.getTitle(), (Object)snapshotMetadata.getTitle()) && zzz.equal((Object)snapshotMetadata2.getDescription(), (Object)snapshotMetadata.getDescription()) && zzz.equal((Object)snapshotMetadata2.getLastModifiedTimestamp(), (Object)snapshotMetadata.getLastModifiedTimestamp()) && zzz.equal((Object)snapshotMetadata2.getPlayedTime(), (Object)snapshotMetadata.getPlayedTime()) && zzz.equal((Object)snapshotMetadata2.getUniqueName(), (Object)snapshotMetadata.getUniqueName()) && zzz.equal((Object)snapshotMetadata2.hasChangePending(), (Object)snapshotMetadata.hasChangePending()) && zzz.equal((Object)snapshotMetadata2.getProgressValue(), (Object)snapshotMetadata.getProgressValue()) && zzz.equal((Object)snapshotMetadata2.getDeviceName(), (Object)snapshotMetadata.getDeviceName());
    }

    public String toString() {
        return SnapshotMetadataEntity.zzb(this);
    }

    static String zzb(SnapshotMetadata snapshotMetadata) {
        return zzz.zzy((Object)snapshotMetadata).zzg("Game", (Object)snapshotMetadata.getGame()).zzg("Owner", (Object)snapshotMetadata.getOwner()).zzg("SnapshotId", (Object)snapshotMetadata.getSnapshotId()).zzg("CoverImageUri", (Object)snapshotMetadata.getCoverImageUri()).zzg("CoverImageUrl", (Object)snapshotMetadata.getCoverImageUrl()).zzg("CoverImageAspectRatio", (Object)Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())).zzg("Description", (Object)snapshotMetadata.getDescription()).zzg("LastModifiedTimestamp", (Object)snapshotMetadata.getLastModifiedTimestamp()).zzg("PlayedTime", (Object)snapshotMetadata.getPlayedTime()).zzg("UniqueName", (Object)snapshotMetadata.getUniqueName()).zzg("ChangePending", (Object)snapshotMetadata.hasChangePending()).zzg("ProgressValue", (Object)snapshotMetadata.getProgressValue()).zzg("DeviceName", (Object)snapshotMetadata.getDeviceName()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        SnapshotMetadataEntityCreator.zza(this, parcel, n);
    }
}

