/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.event;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.event.Event;
import com.google.android.gms.games.event.EventEntityCreator;

public final class EventEntity
extends AbstractSafeParcelable
implements Event {
    public static final EventEntityCreator CREATOR = new EventEntityCreator();
    private final int mVersionCode;
    private final String Sv;
    private final String mName;
    private final String zzcvi;
    private final Uri QE;
    private final String QP;
    private final PlayerEntity RS;
    private final long zzcvh;
    private final String Sw;
    private final boolean zzaqs;

    public EventEntity(Event event) {
        this.mVersionCode = 1;
        this.Sv = event.getEventId();
        this.mName = event.getName();
        this.zzcvi = event.getDescription();
        this.QE = event.getIconImageUri();
        this.QP = event.getIconImageUrl();
        this.RS = (PlayerEntity)event.getPlayer().freeze();
        this.zzcvh = event.getValue();
        this.Sw = event.getFormattedValue();
        this.zzaqs = event.isVisible();
    }

    EventEntity(int n, String string, String string2, String string3, Uri uri, String string4, Player player, long l, String string5, boolean bl) {
        this.mVersionCode = n;
        this.Sv = string;
        this.mName = string2;
        this.zzcvi = string3;
        this.QE = uri;
        this.QP = string4;
        this.RS = new PlayerEntity(player);
        this.zzcvh = l;
        this.Sw = string5;
        this.zzaqs = bl;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getEventId() {
        return this.Sv;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDescription() {
        return this.zzcvi;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzcvi, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        return this.QE;
    }

    @Override
    public String getIconImageUrl() {
        return this.QP;
    }

    @Override
    public Player getPlayer() {
        return this.RS;
    }

    @Override
    public long getValue() {
        return this.zzcvh;
    }

    @Override
    public String getFormattedValue() {
        return this.Sw;
    }

    @Override
    public void getFormattedValue(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.Sw, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public boolean isVisible() {
        return this.zzaqs;
    }

    public Event freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return EventEntity.zza(this);
    }

    static int zza(Event event) {
        return zzaa.hashCode((Object[])new Object[]{event.getEventId(), event.getName(), event.getDescription(), event.getIconImageUri(), event.getIconImageUrl(), event.getPlayer(), event.getValue(), event.getFormattedValue(), event.isVisible()});
    }

    public boolean equals(Object object) {
        return EventEntity.zza(this, object);
    }

    static boolean zza(Event event, Object object) {
        if (!(object instanceof Event)) {
            return false;
        }
        if (event == object) {
            return true;
        }
        Event event2 = (Event)object;
        return zzaa.equal((Object)event2.getEventId(), (Object)event.getEventId()) && zzaa.equal((Object)event2.getName(), (Object)event.getName()) && zzaa.equal((Object)event2.getDescription(), (Object)event.getDescription()) && zzaa.equal((Object)event2.getIconImageUri(), (Object)event.getIconImageUri()) && zzaa.equal((Object)event2.getIconImageUrl(), (Object)event.getIconImageUrl()) && zzaa.equal((Object)event2.getPlayer(), (Object)event.getPlayer()) && zzaa.equal((Object)event2.getValue(), (Object)event.getValue()) && zzaa.equal((Object)event2.getFormattedValue(), (Object)event.getFormattedValue()) && zzaa.equal((Object)event2.isVisible(), (Object)event.isVisible());
    }

    public String toString() {
        return EventEntity.zzb(this);
    }

    static String zzb(Event event) {
        return zzaa.zzz((Object)event).zzg("Id", (Object)event.getEventId()).zzg("Name", (Object)event.getName()).zzg("Description", (Object)event.getDescription()).zzg("IconImageUri", (Object)event.getIconImageUri()).zzg("IconImageUrl", (Object)event.getIconImageUrl()).zzg("Player", (Object)event.getPlayer()).zzg("Value", (Object)event.getValue()).zzg("FormattedValue", (Object)event.getFormattedValue()).zzg("isVisible", (Object)event.isVisible()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        EventEntityCreator.zza(this, parcel, n);
    }
}

