/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotContentsEntity;
import com.google.android.gms.games.snapshot.SnapshotEntityCreator;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;

public final class SnapshotEntity
extends AbstractSafeParcelable
implements Snapshot {
    public static final Parcelable.Creator<SnapshotEntity> CREATOR = new SnapshotEntityCreator();
    private final int mVersionCode;
    private final SnapshotMetadataEntity Zv;
    private final SnapshotContentsEntity Zw;

    public SnapshotEntity(SnapshotMetadata snapshotMetadata, SnapshotContentsEntity snapshotContentsEntity) {
        this(2, snapshotMetadata, snapshotContentsEntity);
    }

    SnapshotEntity(int n, SnapshotMetadata snapshotMetadata, SnapshotContentsEntity snapshotContentsEntity) {
        this.mVersionCode = n;
        this.Zv = new SnapshotMetadataEntity(snapshotMetadata);
        this.Zw = snapshotContentsEntity;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public SnapshotMetadata getMetadata() {
        return this.Zv;
    }

    @Override
    public SnapshotContents getSnapshotContents() {
        return this.isClosed() ? null : this.Zw;
    }

    private boolean isClosed() {
        return this.Zw.isClosed();
    }

    public Snapshot freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return SnapshotEntity.zzb(this);
    }

    static int zzb(Snapshot snapshot) {
        return zzaa.hashCode((Object[])new Object[]{snapshot.getMetadata(), snapshot.getSnapshotContents()});
    }

    public boolean equals(Object object) {
        return SnapshotEntity.zza(this, object);
    }

    static boolean zza(Snapshot snapshot, Object object) {
        if (!(object instanceof Snapshot)) {
            return false;
        }
        if (snapshot == object) {
            return true;
        }
        Snapshot snapshot2 = (Snapshot)object;
        return zzaa.equal((Object)snapshot2.getMetadata(), (Object)snapshot.getMetadata()) && zzaa.equal((Object)snapshot2.getSnapshotContents(), (Object)snapshot.getSnapshotContents());
    }

    public String toString() {
        return SnapshotEntity.zzc(this);
    }

    static String zzc(Snapshot snapshot) {
        return zzaa.zzz((Object)snapshot).zzg("Metadata", (Object)snapshot.getMetadata()).zzg("HasContents", (Object)(snapshot.getSnapshotContents() != null ? 1 : 0)).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        SnapshotEntityCreator.zza(this, parcel, n);
    }
}

