/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntityCreator;

public final class SnapshotMetadataEntity
extends AbstractSafeParcelable
implements SnapshotMetadata {
    public static final Parcelable.Creator<SnapshotMetadataEntity> CREATOR = new SnapshotMetadataEntityCreator();
    private final int mVersionCode;
    private final GameEntity WG;
    private final PlayerEntity ZD;
    private final String SX;
    private final Uri ZA;
    private final String ZE;
    private final String Fx;
    private final String zzcvi;
    private final long ZF;
    private final long ZG;
    private final float ZH;
    private final String ZI;
    private final boolean ZJ;
    private final long ZK;
    private final String ZL;

    public SnapshotMetadataEntity(SnapshotMetadata snapshotMetadata) {
        this.mVersionCode = 6;
        this.WG = new GameEntity(snapshotMetadata.getGame());
        this.ZD = new PlayerEntity(snapshotMetadata.getOwner());
        this.SX = snapshotMetadata.getSnapshotId();
        this.ZA = snapshotMetadata.getCoverImageUri();
        this.ZE = snapshotMetadata.getCoverImageUrl();
        this.ZH = snapshotMetadata.getCoverImageAspectRatio();
        this.Fx = snapshotMetadata.getTitle();
        this.zzcvi = snapshotMetadata.getDescription();
        this.ZF = snapshotMetadata.getLastModifiedTimestamp();
        this.ZG = snapshotMetadata.getPlayedTime();
        this.ZI = snapshotMetadata.getUniqueName();
        this.ZJ = snapshotMetadata.hasChangePending();
        this.ZK = snapshotMetadata.getProgressValue();
        this.ZL = snapshotMetadata.getDeviceName();
    }

    SnapshotMetadataEntity(int n, GameEntity gameEntity, PlayerEntity playerEntity, String string, Uri uri, String string2, String string3, String string4, long l, long l2, float f, String string5, boolean bl, long l3, String string6) {
        this.mVersionCode = n;
        this.WG = gameEntity;
        this.ZD = playerEntity;
        this.SX = string;
        this.ZA = uri;
        this.ZE = string2;
        this.ZH = f;
        this.Fx = string3;
        this.zzcvi = string4;
        this.ZF = l;
        this.ZG = l2;
        this.ZI = string5;
        this.ZJ = bl;
        this.ZK = l3;
        this.ZL = string6;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public Game getGame() {
        return this.WG;
    }

    @Override
    public Player getOwner() {
        return this.ZD;
    }

    @Override
    public String getSnapshotId() {
        return this.SX;
    }

    @Override
    public Uri getCoverImageUri() {
        return this.ZA;
    }

    @Override
    public String getCoverImageUrl() {
        return this.ZE;
    }

    @Override
    public float getCoverImageAspectRatio() {
        return this.ZH;
    }

    @Override
    public String getUniqueName() {
        return this.ZI;
    }

    @Override
    public String getTitle() {
        return this.Fx;
    }

    @Override
    public String getDescription() {
        return this.zzcvi;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzcvi, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public long getLastModifiedTimestamp() {
        return this.ZF;
    }

    @Override
    public long getPlayedTime() {
        return this.ZG;
    }

    @Override
    public boolean hasChangePending() {
        return this.ZJ;
    }

    @Override
    public long getProgressValue() {
        return this.ZK;
    }

    @Override
    public String getDeviceName() {
        return this.ZL;
    }

    public SnapshotMetadata freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return SnapshotMetadataEntity.zza(this);
    }

    static int zza(SnapshotMetadata snapshotMetadata) {
        return zzaa.hashCode((Object[])new Object[]{snapshotMetadata.getGame(), snapshotMetadata.getOwner(), snapshotMetadata.getSnapshotId(), snapshotMetadata.getCoverImageUri(), Float.valueOf(snapshotMetadata.getCoverImageAspectRatio()), snapshotMetadata.getTitle(), snapshotMetadata.getDescription(), snapshotMetadata.getLastModifiedTimestamp(), snapshotMetadata.getPlayedTime(), snapshotMetadata.getUniqueName(), snapshotMetadata.hasChangePending(), snapshotMetadata.getProgressValue(), snapshotMetadata.getDeviceName()});
    }

    public boolean equals(Object object) {
        return SnapshotMetadataEntity.zza(this, object);
    }

    static boolean zza(SnapshotMetadata snapshotMetadata, Object object) {
        if (!(object instanceof SnapshotMetadata)) {
            return false;
        }
        if (snapshotMetadata == object) {
            return true;
        }
        SnapshotMetadata snapshotMetadata2 = (SnapshotMetadata)object;
        return zzaa.equal((Object)snapshotMetadata2.getGame(), (Object)snapshotMetadata.getGame()) && zzaa.equal((Object)snapshotMetadata2.getOwner(), (Object)snapshotMetadata.getOwner()) && zzaa.equal((Object)snapshotMetadata2.getSnapshotId(), (Object)snapshotMetadata.getSnapshotId()) && zzaa.equal((Object)snapshotMetadata2.getCoverImageUri(), (Object)snapshotMetadata.getCoverImageUri()) && zzaa.equal((Object)Float.valueOf(snapshotMetadata2.getCoverImageAspectRatio()), (Object)Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())) && zzaa.equal((Object)snapshotMetadata2.getTitle(), (Object)snapshotMetadata.getTitle()) && zzaa.equal((Object)snapshotMetadata2.getDescription(), (Object)snapshotMetadata.getDescription()) && zzaa.equal((Object)snapshotMetadata2.getLastModifiedTimestamp(), (Object)snapshotMetadata.getLastModifiedTimestamp()) && zzaa.equal((Object)snapshotMetadata2.getPlayedTime(), (Object)snapshotMetadata.getPlayedTime()) && zzaa.equal((Object)snapshotMetadata2.getUniqueName(), (Object)snapshotMetadata.getUniqueName()) && zzaa.equal((Object)snapshotMetadata2.hasChangePending(), (Object)snapshotMetadata.hasChangePending()) && zzaa.equal((Object)snapshotMetadata2.getProgressValue(), (Object)snapshotMetadata.getProgressValue()) && zzaa.equal((Object)snapshotMetadata2.getDeviceName(), (Object)snapshotMetadata.getDeviceName());
    }

    public String toString() {
        return SnapshotMetadataEntity.zzb(this);
    }

    static String zzb(SnapshotMetadata snapshotMetadata) {
        return zzaa.zzz((Object)snapshotMetadata).zzg("Game", (Object)snapshotMetadata.getGame()).zzg("Owner", (Object)snapshotMetadata.getOwner()).zzg("SnapshotId", (Object)snapshotMetadata.getSnapshotId()).zzg("CoverImageUri", (Object)snapshotMetadata.getCoverImageUri()).zzg("CoverImageUrl", (Object)snapshotMetadata.getCoverImageUrl()).zzg("CoverImageAspectRatio", (Object)Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())).zzg("Description", (Object)snapshotMetadata.getDescription()).zzg("LastModifiedTimestamp", (Object)snapshotMetadata.getLastModifiedTimestamp()).zzg("PlayedTime", (Object)snapshotMetadata.getPlayedTime()).zzg("UniqueName", (Object)snapshotMetadata.getUniqueName()).zzg("ChangePending", (Object)snapshotMetadata.hasChangePending()).zzg("ProgressValue", (Object)snapshotMetadata.getProgressValue()).zzg("DeviceName", (Object)snapshotMetadata.getDeviceName()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        SnapshotMetadataEntityCreator.zza(this, parcel, n);
    }
}

