/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.games.PlayerLevelCreator;

public final class PlayerLevel
implements SafeParcelable {
    public static final Parcelable.Creator<PlayerLevel> CREATOR = new PlayerLevelCreator();
    private final int mVersionCode;
    private final int RC;
    private final long RD;
    private final long RE;

    public PlayerLevel(int n, long l, long l2) {
        this(1, n, l, l2);
    }

    PlayerLevel(int n, int n2, long l, long l2) {
        zzab.zza((l >= 0L ? 1 : 0) != 0, (Object)"Min XP must be positive!");
        zzab.zza((l2 > l ? 1 : 0) != 0, (Object)"Max XP must be more than min XP!");
        this.mVersionCode = n;
        this.RC = n2;
        this.RD = l;
        this.RE = l2;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public int getLevelNumber() {
        return this.RC;
    }

    public long getMinXp() {
        return this.RD;
    }

    public long getMaxXp() {
        return this.RE;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.RC, this.RD, this.RE});
    }

    public boolean equals(Object object) {
        if (!(object instanceof PlayerLevel)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        PlayerLevel playerLevel = (PlayerLevel)object;
        return zzaa.equal((Object)playerLevel.getLevelNumber(), (Object)this.getLevelNumber()) && zzaa.equal((Object)playerLevel.getMinXp(), (Object)this.getMinXp()) && zzaa.equal((Object)playerLevel.getMaxXp(), (Object)this.getMaxXp());
    }

    public String toString() {
        return zzaa.zzz((Object)this).zzg("LevelNumber", (Object)this.getLevelNumber()).zzg("MinXp", (Object)this.getMinXp()).zzg("MaxXp", (Object)this.getMaxXp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        PlayerLevelCreator.zza(this, parcel, n);
    }
}

