/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntityCreator;

public final class MilestoneEntity
extends AbstractSafeParcelable
implements Milestone {
    public static final Parcelable.Creator<MilestoneEntity> CREATOR = new MilestoneEntityCreator();
    private final int mVersionCode;
    private final String TK;
    private final long Ze;
    private final long Zf;
    private final byte[] Zg;
    private final int mState;
    private final String Sv;

    public MilestoneEntity(Milestone milestone) {
        this.mVersionCode = 4;
        this.TK = milestone.getMilestoneId();
        this.Ze = milestone.getCurrentProgress();
        this.Zf = milestone.getTargetProgress();
        this.mState = milestone.getState();
        this.Sv = milestone.getEventId();
        byte[] byArray = milestone.getCompletionRewardData();
        if (byArray == null) {
            this.Zg = null;
        } else {
            this.Zg = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.Zg, 0, byArray.length);
        }
    }

    MilestoneEntity(int n, String string, long l, long l2, byte[] byArray, int n2, String string2) {
        this.mVersionCode = n;
        this.TK = string;
        this.Ze = l;
        this.Zf = l2;
        this.Zg = byArray;
        this.mState = n2;
        this.Sv = string2;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getEventId() {
        return this.Sv;
    }

    @Override
    public String getMilestoneId() {
        return this.TK;
    }

    @Override
    public long getCurrentProgress() {
        return this.Ze;
    }

    @Override
    public long getTargetProgress() {
        return this.Zf;
    }

    @Override
    public byte[] getCompletionRewardData() {
        return this.Zg;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    public Milestone freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return MilestoneEntity.zza(this);
    }

    static int zza(Milestone milestone) {
        return zzaa.hashCode((Object[])new Object[]{milestone.getMilestoneId(), milestone.getCurrentProgress(), milestone.getTargetProgress(), milestone.getState(), milestone.getEventId()});
    }

    public boolean equals(Object object) {
        return MilestoneEntity.zza(this, object);
    }

    static boolean zza(Milestone milestone, Object object) {
        if (!(object instanceof Milestone)) {
            return false;
        }
        if (milestone == object) {
            return true;
        }
        Milestone milestone2 = (Milestone)object;
        return zzaa.equal((Object)milestone2.getMilestoneId(), (Object)milestone.getMilestoneId()) && zzaa.equal((Object)milestone2.getCurrentProgress(), (Object)milestone.getCurrentProgress()) && zzaa.equal((Object)milestone2.getTargetProgress(), (Object)milestone.getTargetProgress()) && zzaa.equal((Object)milestone2.getState(), (Object)milestone.getState()) && zzaa.equal((Object)milestone2.getEventId(), (Object)milestone.getEventId());
    }

    public String toString() {
        return MilestoneEntity.zzb(this);
    }

    static String zzb(Milestone milestone) {
        return zzaa.zzz((Object)milestone).zzg("MilestoneId", (Object)milestone.getMilestoneId()).zzg("CurrentProgress", (Object)milestone.getCurrentProgress()).zzg("TargetProgress", (Object)milestone.getTargetProgress()).zzg("State", (Object)milestone.getState()).zzg("CompletionRewardData", (Object)milestone.getCompletionRewardData()).zzg("EventId", (Object)milestone.getEventId()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        MilestoneEntityCreator.zza(this, parcel, n);
    }
}

