/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestEntityCreator;
import java.util.ArrayList;
import java.util.List;

public final class QuestEntity
extends AbstractSafeParcelable
implements Quest {
    public static final Parcelable.Creator<QuestEntity> CREATOR = new QuestEntityCreator();
    private final int mVersionCode;
    private final GameEntity WG;
    private final String Zh;
    private final long Zi;
    private final Uri Zj;
    private final String Zk;
    private final String zzcvi;
    private final long Zl;
    private final long RV;
    private final Uri mIconUri;
    private final String Zm;
    private final String mName;
    private final long Zn;
    private final long Zo;
    private final int mState;
    private final int it;
    private final ArrayList<MilestoneEntity> Zp;

    public QuestEntity(Quest quest) {
        this.mVersionCode = 2;
        this.WG = new GameEntity(quest.getGame());
        this.Zh = quest.getQuestId();
        this.Zi = quest.getAcceptedTimestamp();
        this.zzcvi = quest.getDescription();
        this.Zj = quest.getBannerImageUri();
        this.Zk = quest.getBannerImageUrl();
        this.Zl = quest.getEndTimestamp();
        this.mIconUri = quest.getIconImageUri();
        this.Zm = quest.getIconImageUrl();
        this.RV = quest.getLastUpdatedTimestamp();
        this.mName = quest.getName();
        this.Zn = quest.zzblj();
        this.Zo = quest.getStartTimestamp();
        this.mState = quest.getState();
        this.it = quest.getType();
        List<Milestone> list = quest.zzbli();
        int n = list.size();
        this.Zp = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.Zp.add((MilestoneEntity)list.get(i).freeze());
        }
    }

    QuestEntity(int n, GameEntity gameEntity, String string, long l, Uri uri, String string2, String string3, long l2, long l3, Uri uri2, String string4, String string5, long l4, long l5, int n2, int n3, ArrayList<MilestoneEntity> arrayList) {
        this.mVersionCode = n;
        this.WG = gameEntity;
        this.Zh = string;
        this.Zi = l;
        this.Zj = uri;
        this.Zk = string2;
        this.zzcvi = string3;
        this.Zl = l2;
        this.RV = l3;
        this.mIconUri = uri2;
        this.Zm = string4;
        this.mName = string5;
        this.Zn = l4;
        this.Zo = l5;
        this.mState = n2;
        this.it = n3;
        this.Zp = arrayList;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getQuestId() {
        return this.Zh;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDescription() {
        return this.zzcvi;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzcvi, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        return this.mIconUri;
    }

    @Override
    public String getIconImageUrl() {
        return this.Zm;
    }

    @Override
    public Uri getBannerImageUri() {
        return this.Zj;
    }

    @Override
    public String getBannerImageUrl() {
        return this.Zk;
    }

    @Override
    public Milestone getCurrentMilestone() {
        return this.zzbli().get(0);
    }

    @Override
    public List<Milestone> zzbli() {
        return new ArrayList<Milestone>(this.Zp);
    }

    @Override
    public Game getGame() {
        return this.WG;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getType() {
        return this.it;
    }

    @Override
    public long getAcceptedTimestamp() {
        return this.Zi;
    }

    @Override
    public long getEndTimestamp() {
        return this.Zl;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.RV;
    }

    @Override
    public long zzblj() {
        return this.Zn;
    }

    @Override
    public long getStartTimestamp() {
        return this.Zo;
    }

    @Override
    public boolean isEndingSoon() {
        return this.Zn <= System.currentTimeMillis() + 1800000L;
    }

    public Quest freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return QuestEntity.zza(this);
    }

    static int zza(Quest quest) {
        return zzaa.hashCode((Object[])new Object[]{quest.getGame(), quest.getQuestId(), quest.getAcceptedTimestamp(), quest.getBannerImageUri(), quest.getDescription(), quest.getEndTimestamp(), quest.getIconImageUri(), quest.getLastUpdatedTimestamp(), quest.zzbli(), quest.getName(), quest.zzblj(), quest.getStartTimestamp(), quest.getState()});
    }

    public boolean equals(Object object) {
        return QuestEntity.zza(this, object);
    }

    static boolean zza(Quest quest, Object object) {
        if (!(object instanceof Quest)) {
            return false;
        }
        if (quest == object) {
            return true;
        }
        Quest quest2 = (Quest)object;
        return zzaa.equal((Object)quest2.getGame(), (Object)quest.getGame()) && zzaa.equal((Object)quest2.getQuestId(), (Object)quest.getQuestId()) && zzaa.equal((Object)quest2.getAcceptedTimestamp(), (Object)quest.getAcceptedTimestamp()) && zzaa.equal((Object)quest2.getBannerImageUri(), (Object)quest.getBannerImageUri()) && zzaa.equal((Object)quest2.getDescription(), (Object)quest.getDescription()) && zzaa.equal((Object)quest2.getEndTimestamp(), (Object)quest.getEndTimestamp()) && zzaa.equal((Object)quest2.getIconImageUri(), (Object)quest.getIconImageUri()) && zzaa.equal((Object)quest2.getLastUpdatedTimestamp(), (Object)quest.getLastUpdatedTimestamp()) && zzaa.equal(quest2.zzbli(), quest.zzbli()) && zzaa.equal((Object)quest2.getName(), (Object)quest.getName()) && zzaa.equal((Object)quest2.zzblj(), (Object)quest.zzblj()) && zzaa.equal((Object)quest2.getStartTimestamp(), (Object)quest.getStartTimestamp()) && zzaa.equal((Object)quest2.getState(), (Object)quest.getState());
    }

    public String toString() {
        return QuestEntity.zzb(this);
    }

    static String zzb(Quest quest) {
        return zzaa.zzz((Object)quest).zzg("Game", (Object)quest.getGame()).zzg("QuestId", (Object)quest.getQuestId()).zzg("AcceptedTimestamp", (Object)quest.getAcceptedTimestamp()).zzg("BannerImageUri", (Object)quest.getBannerImageUri()).zzg("BannerImageUrl", (Object)quest.getBannerImageUrl()).zzg("Description", (Object)quest.getDescription()).zzg("EndTimestamp", (Object)quest.getEndTimestamp()).zzg("IconImageUri", (Object)quest.getIconImageUri()).zzg("IconImageUrl", (Object)quest.getIconImageUrl()).zzg("LastUpdatedTimestamp", (Object)quest.getLastUpdatedTimestamp()).zzg("Milestones", quest.zzbli()).zzg("Name", (Object)quest.getName()).zzg("NotifyTimestamp", (Object)quest.zzblj()).zzg("StartTimestamp", (Object)quest.getStartTimestamp()).zzg("State", (Object)quest.getState()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        QuestEntityCreator.zza(this, parcel, n);
    }
}

