/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.accounts.Account;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.GamesStatusCodes;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.OnNearbyPlayerDetectedListener;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.appcontent.AppContents;
import com.google.android.gms.games.event.EventBuffer;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.AbstractGamesCallbacks;
import com.google.android.gms.games.internal.AbstractGamesClient;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.games.internal.IGamesCallbacks;
import com.google.android.gms.games.internal.IGamesService;
import com.google.android.gms.games.internal.PopupLocationInfoParcelable;
import com.google.android.gms.games.internal.PopupManager;
import com.google.android.gms.games.internal.constants.RequestType;
import com.google.android.gms.games.internal.events.EventIncrementCache;
import com.google.android.gms.games.internal.events.EventIncrementManager;
import com.google.android.gms.games.internal.experience.ExperienceEventBuffer;
import com.google.android.gms.games.internal.game.GameInstanceBuffer;
import com.google.android.gms.games.internal.game.GameSearchSuggestionBuffer;
import com.google.android.gms.games.internal.player.ProfileSettingsEntity;
import com.google.android.gms.games.internal.player.StockProfileImageBuffer;
import com.google.android.gms.games.internal.request.RequestUpdateOutcomes;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomBuffer;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestEntity;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotContentsEntity;
import com.google.android.gms.games.snapshot.SnapshotEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.games.social.OnSocialInviteUpdateReceivedListener;
import com.google.android.gms.games.social.Social;
import com.google.android.gms.games.social.SocialInvite;
import com.google.android.gms.games.social.SocialInviteBuffer;
import com.google.android.gms.games.social.SocialInviteEntity;
import com.google.android.gms.games.stats.PlayerStats;
import com.google.android.gms.games.stats.PlayerStatsBuffer;
import com.google.android.gms.games.stats.PlayerStatsEntity;
import com.google.android.gms.games.stats.Stats;
import com.google.android.gms.games.video.CaptureState;
import com.google.android.gms.games.video.VideoBuffer;
import com.google.android.gms.games.video.VideoCapabilities;
import com.google.android.gms.games.video.VideoConfiguration;
import com.google.android.gms.games.video.Videos;
import com.google.android.gms.internal.zzpm;
import com.google.android.gms.internal.zzps;
import com.google.android.gms.internal.zzpt;
import com.google.android.gms.internal.zzqn;
import com.google.android.gms.signin.internal.zzg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public final class GamesClientImpl
extends zzk<IGamesService> {
    EventIncrementManager Ra = new EventIncrementManager(){

        @Override
        public EventIncrementCache zzbic() {
            return new GameClientEventIncrementCache();
        }
    };
    private final String Rb;
    private PlayerEntity Rc;
    private GameEntity Rd;
    private final PopupManager Re;
    private boolean Rf = false;
    private final Binder Rg;
    private final long Rh;
    private final Games.GamesOptions Ri;

    public GamesClientImpl(Context context, Looper looper, com.google.android.gms.common.internal.zzg zzg2, Games.GamesOptions gamesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 1, zzg2, connectionCallbacks, onConnectionFailedListener);
        this.Rb = zzg2.zzasm();
        this.Rg = new Binder();
        this.Re = PopupManager.zza(this, zzg2.zzasi());
        this.zzq(zzg2.zzaso());
        this.Rh = ((Object)((Object)this)).hashCode();
        this.Ri = gamesOptions;
    }

    public boolean zzafk() {
        return true;
    }

    public void zza(@NonNull IGamesService iGamesService) {
        super.zza((IInterface)iGamesService);
        if (this.Rf) {
            this.Re.zzbiq();
            this.Rf = false;
        }
        if (!this.Ri.PF && !this.Ri.PN) {
            this.zzb(iGamesService);
        }
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        super.onConnectionFailed(connectionResult);
        this.Rf = false;
    }

    public void zzqs(int n) {
        this.Re.setGravity(n);
    }

    public void zzq(View view) {
        this.Re.zzr(view);
    }

    protected Set<Scope> zzc(Set<Scope> set) {
        boolean bl = false;
        boolean bl2 = false;
        Scope scope = new Scope("https://www.googleapis.com/auth/games");
        Scope scope2 = new Scope("https://www.googleapis.com/auth/games.firstparty");
        for (Scope scope3 : set) {
            if (scope3.equals((Object)scope)) {
                bl = true;
                continue;
            }
            if (!scope3.equals((Object)scope2)) continue;
            bl2 = true;
        }
        if (bl2) {
            zzab.zza((!bl ? 1 : 0) != 0, (String)"Cannot have both %s and %s!", (Object[])new Object[]{"https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty"});
        } else {
            zzab.zza((boolean)bl, (String)"Games APIs requires %s to function.", (Object[])new Object[]{"https://www.googleapis.com/auth/games"});
        }
        return set;
    }

    public void zza(zzd.zzf zzf2) {
        this.zzbhd();
        super.zza(zzf2);
    }

    public void disconnect() {
        this.Rf = false;
        if (this.isConnected()) {
            try {
                IGamesService iGamesService = (IGamesService)this.zzasa();
                iGamesService.zzbib();
                this.Ra.flush();
                iGamesService.zzak(this.Rh);
            }
            catch (RemoteException remoteException) {
                GamesLog.zzaf("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        super.disconnect();
    }

    protected String zzqz() {
        return "com.google.android.gms.games.service.START";
    }

    protected String zzra() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    protected IGamesService zzgg(IBinder iBinder) {
        return IGamesService.Stub.zzgj(iBinder);
    }

    public Bundle zzamh() {
        try {
            Bundle bundle = ((IGamesService)this.zzasa()).zzamh();
            if (bundle != null) {
                bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    private void zzbhd() {
        this.Rc = null;
        this.Rd = null;
    }

    protected Bundle zzaeu() {
        String string = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = this.Ri.zzbfe();
        bundle.putString("com.google.android.gms.games.key.gamePackageName", this.Rb);
        bundle.putString("com.google.android.gms.games.key.desiredLocale", string);
        bundle.putParcelable("com.google.android.gms.games.key.popupWindowToken", (Parcelable)new BinderWrapper(this.Re.zzbis()));
        bundle.putInt("com.google.android.gms.games.key.API_VERSION", 4);
        bundle.putBundle("com.google.android.gms.games.key.signInOptions", zzg.zza((com.google.android.gms.common.internal.zzg)this.zzasv()));
        return bundle;
    }

    public void zzb(IGamesService iGamesService) {
        try {
            PopupLocationInfoBinderCallbacks popupLocationInfoBinderCallbacks = new PopupLocationInfoBinderCallbacks(this.Re);
            iGamesService.zza(popupLocationInfoBinderCallbacks, this.Rh);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public String zzbhe() {
        try {
            return ((IGamesService)this.zzasa()).zzbhe();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    public void zzf(zzpm.zzb<Games.GetTokenResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzasa()).zzj(new GetAuthTokenBinderCallbacks(zzb2));
    }

    public void zzb(String string, zzpm.zzb<Games.GetServerAuthCodeResult> zzb2) throws RemoteException {
        zzab.zzh((String)string, (Object)"Please provide a valid serverClientId");
        ((IGamesService)this.zzasa()).zza(string, new GetServerAuthCodeBinderCallbacks(zzb2));
    }

    public String zzbt(boolean bl) {
        if (bl && this.Rc != null) {
            return this.Rc.getPlayerId();
        }
        try {
            return ((IGamesService)this.zzasa()).zzbid();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Player zzbhf() {
        this.zzarz();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.Rc == null) {
                try {
                    PlayerBuffer playerBuffer = new PlayerBuffer(((IGamesService)this.zzasa()).zzbie());
                    try {
                        if (playerBuffer.getCount() > 0) {
                            this.Rc = (PlayerEntity)((Player)playerBuffer.get(0)).freeze();
                        }
                    }
                    finally {
                        playerBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    this.zzb(remoteException);
                }
            }
        }
        return this.Rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Game zzbhg() {
        this.zzarz();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.Rd == null) {
                try {
                    GameBuffer gameBuffer = new GameBuffer(((IGamesService)this.zzasa()).zzbig());
                    try {
                        if (gameBuffer.getCount() > 0) {
                            this.Rd = (GameEntity)((Game)gameBuffer.get(0)).freeze();
                        }
                    }
                    finally {
                        gameBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    this.zzb(remoteException);
                }
            }
        }
        return this.Rd;
    }

    public void zza(zzpm.zzb<Players.LoadPlayersResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzasa()).zzf((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zzpm.zzb<Players.LoadPlayersResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzasa()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), stringArray);
    }

    public void zza(zzpm.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zza(zzpm.zzb<Players.LoadPlayersResult> zzb2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "played_with": {
                break;
            }
            default: {
                String string2 = String.valueOf(string);
                throw new IllegalArgumentException(string2.length() != 0 ? "Invalid player collection: ".concat(string2) : new String("Invalid player collection: "));
            }
        }
        ((IGamesService)this.zzasa()).zzd(new PlayersLoadedBinderCallback(zzb2), string, n, bl, bl2);
    }

    public void zza(zzpm.zzb<Players.LoadPlayersResult> zzb2, String string, String string2, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "circled": 
            case "played_with": 
            case "nearby": {
                break;
            }
            default: {
                String string3 = String.valueOf(string);
                throw new IllegalArgumentException(string3.length() != 0 ? "Invalid player collection: ".concat(string3) : new String("Invalid player collection: "));
            }
        }
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, string2, n, bl, bl2);
    }

    public void zza(zzpm.zzb<Players.LoadPlayersResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzasa()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), bl);
    }

    public Intent zzbhh() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzasa()).zzbhh();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzl(String string, int n, int n2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzasa()).zzm(string, n, n2);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzb(zzpm.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzasa()).zzb((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), bl);
    }

    public void zzb(zzpm.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzasa()).zzc((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zzpm.zzb<Leaderboards.LoadPlayerScoreResult> zzb2, String string, String string2, int n, int n2) throws RemoteException {
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new PlayerLeaderboardScoreLoadedBinderCallback(zzb2), string, string2, n, n2);
    }

    public void zza(zzpm.zzb<Leaderboards.LoadScoresResult> zzb2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, n, n2, n3, bl);
    }

    public void zzb(zzpm.zzb<Leaderboards.LoadScoresResult> zzb2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzasa()).zzb((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, n, n2, n3, bl);
    }

    public void zza(zzpm.zzb<Leaderboards.LoadScoresResult> zzb2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n, int n2) throws RemoteException {
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), leaderboardScoreBuffer.zzbkc().asBundle(), n, n2);
    }

    public void zza(zzpm.zzb<Leaderboards.SubmitScoreResult> zzb2, String string, long l, String string2) throws RemoteException {
        SubmitScoreBinderCallbacks submitScoreBinderCallbacks = zzb2 == null ? null : new SubmitScoreBinderCallbacks(zzb2);
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)submitScoreBinderCallbacks, string, l, string2);
    }

    public Intent zzbhi() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzasa()).zzbhi();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzc(zzpm.zzb<Achievements.LoadAchievementsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new AchievementsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zzpm.zzb<Achievements.UpdateAchievementResult> zzb2, String string) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)achievementUpdatedBinderCallback, string, this.Re.zzbis(), this.Re.zzbir());
    }

    public void zzb(zzpm.zzb<Achievements.UpdateAchievementResult> zzb2, String string) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzasa()).zzb((IGamesCallbacks)achievementUpdatedBinderCallback, string, this.Re.zzbis(), this.Re.zzbir());
    }

    public void zza(zzpm.zzb<Achievements.UpdateAchievementResult> zzb2, String string, int n) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)achievementUpdatedBinderCallback, string, n, this.Re.zzbis(), this.Re.zzbir());
    }

    public void zzb(zzpm.zzb<Achievements.UpdateAchievementResult> zzb2, String string, int n) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzasa()).zzb((IGamesCallbacks)achievementUpdatedBinderCallback, string, n, this.Re.zzbis(), this.Re.zzbir());
    }

    public void zzd(zzpm.zzb<Events.LoadEventsResult> zzb2, boolean bl) throws RemoteException {
        this.Ra.flush();
        ((IGamesService)this.zzasa()).zzf((IGamesCallbacks)new EventsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zzpm.zzb<Events.LoadEventsResult> zzb2, boolean bl, String ... stringArray) throws RemoteException {
        this.Ra.flush();
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new EventsLoadedBinderCallback(zzb2), bl, stringArray);
    }

    public void zzn(String string, int n) {
        this.Ra.zzn(string, n);
    }

    public Intent zzbhj() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzasa()).zzbhj();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzbhk() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzasa()).zzbhk();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzqn<OnInvitationReceivedListener> zzqn2) {
        try {
            InvitationReceivedBinderCallback invitationReceivedBinderCallback = new InvitationReceivedBinderCallback(zzqn2);
            ((IGamesService)this.zzasa()).zza((IGamesCallbacks)invitationReceivedBinderCallback, this.Rh);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzbhl() {
        try {
            ((IGamesService)this.zzasa()).zzal(this.Rh);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzb(zzqn<OnTurnBasedMatchUpdateReceivedListener> zzqn2) {
        try {
            MatchUpdateReceivedBinderCallback matchUpdateReceivedBinderCallback = new MatchUpdateReceivedBinderCallback(zzqn2);
            ((IGamesService)this.zzasa()).zzb((IGamesCallbacks)matchUpdateReceivedBinderCallback, this.Rh);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzbhm() {
        try {
            ((IGamesService)this.zzasa()).zzam(this.Rh);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzc(zzqn<QuestUpdateListener> zzqn2) {
        try {
            QuestUpdateBinderCallback questUpdateBinderCallback = new QuestUpdateBinderCallback(zzqn2);
            ((IGamesService)this.zzasa()).zzd((IGamesCallbacks)questUpdateBinderCallback, this.Rh);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzbhn() {
        try {
            ((IGamesService)this.zzasa()).zzao(this.Rh);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzd(zzqn<OnRequestReceivedListener> zzqn2) {
        try {
            RequestReceivedBinderCallback requestReceivedBinderCallback = new RequestReceivedBinderCallback(zzqn2);
            ((IGamesService)this.zzasa()).zzc((IGamesCallbacks)requestReceivedBinderCallback, this.Rh);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzbho() {
        try {
            ((IGamesService)this.zzasa()).zzan(this.Rh);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public Intent zza(PlayerEntity playerEntity) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzasa()).zza(playerEntity);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzbhp() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzasa()).zzbhp();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zza(Room room, int n) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzasa()).zza((RoomEntity)room.freeze(), n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzbhq() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzasa()).zzbhq();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzg(zzpm.zzb<GamesMetadata.LoadGamesResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzasa()).zzd(new GamesLoadedBinderCallback(zzb2));
    }

    public void zzh(zzpm.zzb<Status> zzb2) throws RemoteException {
        this.Ra.flush();
        ((IGamesService)this.zzasa()).zza(new SignOutCompleteBinderCallbacks(zzb2));
    }

    public int zzbhr() {
        int n = 4368;
        try {
            n = ((IGamesService)this.zzasa()).zzbhr();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public String zzsh() {
        try {
            return ((IGamesService)this.zzasa()).zzsh();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    public void zza(zzpm.zzb<Invitations.LoadInvitationsResult> zzb2, int n) throws RemoteException {
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), n);
    }

    public void zzo(String string, int n) {
        try {
            ((IGamesService)this.zzasa()).zzo(string, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzp(String string, int n) {
        try {
            ((IGamesService)this.zzasa()).zzp(string, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public Intent zzb(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzasa()).zzb(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzpm.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, TurnBasedMatchConfig turnBasedMatchConfig) throws RemoteException {
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.zzbki(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
    }

    public void zzc(zzpm.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzasa()).zzk((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string);
    }

    public void zzd(zzpm.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzasa()).zzl((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string);
    }

    public int zzbhs() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzasa()).zzbhs();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public void zza(zzpm.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2, String string, byte[] byArray, String string2, ParticipantResult[] participantResultArray) throws RemoteException {
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(zzb2), string, byArray, string2, participantResultArray);
    }

    public void zza(zzpm.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2, String string, byte[] byArray, ParticipantResult[] participantResultArray) throws RemoteException {
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(zzb2), string, byArray, participantResultArray);
    }

    public void zze(zzpm.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzasa()).zzn(new TurnBasedMatchLeftBinderCallbacks(zzb2), string);
    }

    public void zza(zzpm.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzasa()).zzc((IGamesCallbacks)new TurnBasedMatchLeftBinderCallbacks(zzb2), string, string2);
    }

    public void zzf(zzpm.zzb<TurnBasedMultiplayer.CancelMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzasa()).zzm((IGamesCallbacks)new TurnBasedMatchCanceledBinderCallbacks(zzb2), string);
    }

    public void zzjl(String string) {
        try {
            ((IGamesService)this.zzasa()).zzjt(string);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zza(zzpm.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2, int n, int[] nArray) throws RemoteException {
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(zzb2), n, nArray);
    }

    public void zzg(zzpm.zzb<TurnBasedMultiplayer.LoadMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzasa()).zzo(new TurnBasedMatchLoadedBinderCallbacks(zzb2), string);
    }

    public Intent zzc(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzasa()).zzc(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzqn<RoomUpdateListener> zzqn2, zzqn<RoomStatusUpdateListener> zzqn3, zzqn<RealTimeMessageReceivedListener> zzqn4, RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(zzqn2, zzqn3, zzqn4);
            ((IGamesService)this.zzasa()).zza((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.Rg, roomConfig.getVariant(), roomConfig.getInvitedPlayerIds(), roomConfig.getAutoMatchCriteria(), false, this.Rh);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzb(zzqn<RoomUpdateListener> zzqn2, zzqn<RoomStatusUpdateListener> zzqn3, zzqn<RealTimeMessageReceivedListener> zzqn4, RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(zzqn2, zzqn3, zzqn4);
            ((IGamesService)this.zzasa()).zza((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.Rg, roomConfig.getInvitationId(), false, this.Rh);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zza(zzqn<RoomUpdateListener> zzqn2, String string) {
        try {
            ((IGamesService)this.zzasa()).zzc((IGamesCallbacks)new RoomBinderCallbacks(zzqn2), string);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public int zza(zzqn<RealTimeMultiplayer.ReliableMessageSentCallback> zzqn2, byte[] byArray, String string, String string2) {
        try {
            return ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new RealTimeReliableMessageBinderCallbacks(zzqn2), byArray, string, string2);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return -1;
        }
    }

    public int zza(byte[] byArray, String string, String[] stringArray) {
        zzab.zzb((Object)stringArray, (Object)"Participant IDs must not be null");
        try {
            return ((IGamesService)this.zzasa()).zzb(byArray, string, stringArray);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return -1;
        }
    }

    public int zze(byte[] byArray, String string) {
        try {
            return ((IGamesService)this.zzasa()).zzb(byArray, string, null);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return -1;
        }
    }

    public void zzqt(int n) {
        try {
            ((IGamesService)this.zzasa()).zzqt(n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public Intent zzbht() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzasa()).zzbht();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zza(int n, byte[] byArray, int n2, Bitmap bitmap, String string) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzasa()).zza(n, byArray, n2, string);
            zzab.zzb((Object)bitmap, (Object)"Must provide a non null icon");
            intent.putExtra("com.google.android.gms.games.REQUEST_ITEM_ICON", (Parcelable)bitmap);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public int zzbhu() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzasa()).zzbhu();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public int zzbhv() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzasa()).zzbhv();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public void zzb(zzpm.zzb<Requests.UpdateRequestsResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), stringArray);
    }

    public void zzc(zzpm.zzb<Requests.UpdateRequestsResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzasa()).zzb((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), stringArray);
    }

    public void zza(zzpm.zzb<Requests.LoadRequestsResult> zzb2, int n, int n2, int n3) throws RemoteException {
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new RequestsLoadedBinderCallbacks(zzb2), n, n2, n3);
    }

    public void zza(zzpm.zzb<AppContents.LoadAppContentResult> zzb2, int n, String string, String[] stringArray, boolean bl) throws RemoteException {
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new AppContentLoadedBinderCallbacks(zzb2), n, string, stringArray, bl);
    }

    public void zze(zzpm.zzb<Stats.LoadPlayerStatsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzasa()).zzi((IGamesCallbacks)new PlayerStatsLoadedBinderCallbacks(zzb2), bl);
    }

    public Intent zzc(int[] nArray) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzasa()).zzc(nArray);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzjm(String string) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzasa()).zzjm(string);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzh(zzpm.zzb<Quests.AcceptQuestResult> zzb2, String string) throws RemoteException {
        this.Ra.flush();
        ((IGamesService)this.zzasa()).zzt(new QuestAcceptedBinderCallbacks(zzb2), string);
    }

    public void zzb(zzpm.zzb<Quests.ClaimMilestoneResult> zzb2, String string, String string2) throws RemoteException {
        this.Ra.flush();
        ((IGamesService)this.zzasa()).zzf((IGamesCallbacks)new QuestMilestoneClaimBinderCallbacks(zzb2, string2), string, string2);
    }

    public void zza(zzpm.zzb<Quests.LoadQuestsResult> zzb2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.Ra.flush();
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), nArray, n, bl);
    }

    public void zzb(zzpm.zzb<Quests.LoadQuestsResult> zzb2, boolean bl, String[] stringArray) throws RemoteException {
        this.Ra.flush();
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), stringArray, bl);
    }

    public void zzjn(String string) {
        try {
            ((IGamesService)this.zzasa()).zza(string, this.Re.zzbis(), this.Re.zzbir());
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zza(zzpm.zzb<Quests.LoadQuestsResult> zzb2, String string, String string2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.Ra.flush();
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), string, string2, nArray, n, bl);
    }

    public void zza(zzpm.zzb<Quests.LoadQuestsResult> zzb2, String string, String string2, boolean bl, String[] stringArray) throws RemoteException {
        this.Ra.flush();
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), string, string2, stringArray, bl);
    }

    public int zzbhw() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzasa()).zzbhw();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public int zzbhx() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzasa()).zzbhx();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public Intent zza(String string, boolean bl, boolean bl2, int n) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzasa()).zza(string, bl, bl2, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzf(zzpm.zzb<Snapshots.LoadSnapshotsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzasa()).zzd((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(zzb2), bl);
    }

    public void zza(zzpm.zzb<Snapshots.OpenSnapshotResult> zzb2, String string, boolean bl, int n) throws RemoteException {
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(zzb2), string, bl, n);
    }

    public void zza(zzpm.zzb<Snapshots.CommitSnapshotResult> zzb2, Snapshot snapshot, SnapshotMetadataChange snapshotMetadataChange) throws RemoteException {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        zzab.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzbkn();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzd(this.getContext().getCacheDir());
        }
        Contents contents = snapshotContents.zzayw();
        snapshotContents.close();
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new SnapshotCommittedBinderCallbacks(zzb2), snapshot.getMetadata().getSnapshotId(), (SnapshotMetadataChangeEntity)snapshotMetadataChange, contents);
    }

    public void zza(Snapshot snapshot) {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        zzab.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        Contents contents = snapshotContents.zzayw();
        snapshotContents.close();
        try {
            ((IGamesService)this.zzasa()).zza(contents);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzi(zzpm.zzb<Snapshots.DeleteSnapshotResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzasa()).zzq(new SnapshotDeletedBinderCallbacks(zzb2), string);
    }

    public void zza(zzpm.zzb<Snapshots.OpenSnapshotResult> zzb2, String string, String string2, SnapshotMetadataChange snapshotMetadataChange, SnapshotContents snapshotContents) throws RemoteException {
        zzab.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"SnapshotContents already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzbkn();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzd(this.getContext().getCacheDir());
        }
        Contents contents = snapshotContents.zzayw();
        snapshotContents.close();
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(zzb2), string, string2, (SnapshotMetadataChangeEntity)snapshotMetadataChange, contents);
    }

    public void zzi(zzpm.zzb<Videos.CaptureCapabilitiesResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzasa()).zzl(new CaptureCapabilitiesBinderCallback(zzb2));
    }

    public Intent zzbhy() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzasa()).zzbim();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzj(zzpm.zzb<Videos.CaptureStateResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzasa()).zzv(new CaptureStateBinderCallbacks(zzb2));
    }

    public void zzk(zzpm.zzb<Videos.CaptureStreamingAvailabilityResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzasa()).zzs(new CaptureStreamingAvailabilityBinderCallback(zzb2));
    }

    public void zzl(zzpm.zzb<Videos.CaptureStreamingMetadataResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzasa()).zzq(new CaptureStreamingMetadataBinderCallback(zzb2));
    }

    public void zzm(zzpm.zzb<Videos.CaptureStreamingUrlResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzasa()).zzr(new CaptureStreamingUrlBinderCallback(zzb2));
    }

    public void zzn(zzpm.zzb<Status> zzb2) throws RemoteException {
        ((IGamesService)this.zzasa()).zzt(new HeadlessCaptureEnabledBinderCallback(zzb2));
    }

    public void zzb(zzpm.zzb<Videos.CaptureAvailableResult> zzb2, int n) throws RemoteException {
        ((IGamesService)this.zzasa()).zzc((IGamesCallbacks)new CaptureAvailableBinderCallback(zzb2), n);
    }

    public boolean zzbhz() {
        boolean bl = false;
        try {
            bl = ((IGamesService)this.zzasa()).zzbhz();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return bl;
    }

    public void zzo(zzpm.zzb<Status> zzb2) throws RemoteException {
        ((IGamesService)this.zzasa()).zzo(new CaptureStreamingEnabledBinderCallback(zzb2));
    }

    public void zza(Games.BaseGamesApiMethodImpl<Status> baseGamesApiMethodImpl, String string, VideoConfiguration videoConfiguration) throws RemoteException {
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new CaptureLaunchGameAndOverlayBinderCallback(baseGamesApiMethodImpl), string, videoConfiguration);
    }

    public void zzp(zzpm.zzb<Videos.ListVideosResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzasa()).zzk(new ListVideosBinderCallback(zzb2));
    }

    public void zzc(zzpm.zzb<Videos.ListVideosResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzasa()).zzd((IGamesCallbacks)new ListVideosBinderCallback(zzb2), string, n);
    }

    public void zze(zzqn<Videos.CaptureOverlayStateListener> zzqn2) {
        try {
            CaptureOverlayStateBinderCallback captureOverlayStateBinderCallback = new CaptureOverlayStateBinderCallback(zzqn2);
            ((IGamesService)this.zzasa()).zzf((IGamesCallbacks)captureOverlayStateBinderCallback, this.Rh);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzg(zzpm.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzasa()).zzm((IGamesCallbacks)new CapturePausedBinderCallback(zzb2), bl);
    }

    public void zza(zzpm.zzb<Status> zzb2, VideoConfiguration videoConfiguration, Videos.CaptureRuntimeErrorCallback captureRuntimeErrorCallback) throws RemoteException {
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new CaptureStartedBinderCallbacks(zzb2, captureRuntimeErrorCallback), videoConfiguration);
    }

    public void zzq(zzpm.zzb<Videos.CaptureStoppedResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzasa()).zzu(new CaptureStoppedBinderCallbacks(zzb2));
    }

    public void zzbia() {
        try {
            ((IGamesService)this.zzasa()).zzar(this.Rh);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzc(zzpm.zzb<Status> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzasa()).zzh(new UpdateHeadlessCapturePermissionBinderCallback(zzb2), string, bl);
    }

    public void zzj(zzpm.zzb<GamesMetadata.LoadGameInstancesResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzasa()).zzf((IGamesCallbacks)new GameInstancesLoadedBinderCallback(zzb2), string);
    }

    public void zzk(zzpm.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzasa()).zzp(new GameSearchSuggestionsLoadedBinderCallback(zzb2), string);
    }

    public void zzd(zzpm.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzasa()).zzd((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zzpm.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzasa()).zzb((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, string2, bl);
    }

    public void zza(zzpm.zzb<Leaderboards.LoadScoresResult> zzb2, String string, String string2, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, string2, n, n2, n3, bl);
    }

    public void zzb(zzpm.zzb<Leaderboards.LoadScoresResult> zzb2, String string, String string2, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzasa()).zzb(new LeaderboardScoresLoadedBinderCallback(zzb2), string, string2, n, n2, n3, bl);
    }

    public void zzb(zzpm.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzasa()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzc(zzpm.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzasa()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzd(zzpm.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzasa()).zze(new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzb(zzpm.zzb<Players.LoadPlayersResult> zzb2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzasa()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, n, bl, bl2);
    }

    public void zzb(zzpm.zzb<Players.LoadPlayersResult> zzb2, String string, String string2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzasa()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, string2, n, bl, bl2);
    }

    public void zzl(zzpm.zzb<Players.LoadXpForGameCategoriesResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzasa()).zzr(new PlayerXpForGameCategoriesLoadedBinderCallback(zzb2), string);
    }

    public void zzd(zzpm.zzb<Players.LoadXpStreamResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzasa()).zzb((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(zzb2), string, n);
    }

    public void zze(zzpm.zzb<Players.LoadXpStreamResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzasa()).zzc((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(zzb2), string, n);
    }

    public void zza(zzpm.zzb<Players.LoadProfileSettingsResult> zzb2, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new ProfileSettingsLoadedBinderCallback(zzb2), bl, bl2);
    }

    public void zzh(zzpm.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzasa()).zzh((IGamesCallbacks)new ProfileSettingsUpdatedBinderCallback(zzb2), bl);
    }

    public void zza(zzpm.zzb<Players.LoadPlayersResult> zzb2, Account account) throws RemoteException {
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), account);
    }

    public void zzr(zzpm.zzb<Players.LoadStockProfileImagesResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzasa()).zzp(new StockProfileImagesLoadedBinderCallback(zzb2));
    }

    public void zza(zzpm.zzb<Players.UpdateGamerProfileResult> zzb2, String string, boolean bl, String string2, boolean bl2, boolean bl3) throws RemoteException {
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new GamerProfileUpdatedBinderCallback(zzb2), string, bl, string2, bl2, bl3);
    }

    public void zzi(zzpm.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzasa()).zzj((IGamesCallbacks)new DeletePlayerBinderCallback(zzb2), bl);
    }

    public void zzj(zzpm.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzasa()).zzk((IGamesCallbacks)new UpdateAutoSignInBinderCallback(zzb2), bl);
    }

    public void zzk(zzpm.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzasa()).zzl((IGamesCallbacks)new UpdateProfileDiscoverabilityBinderCallback(zzb2), bl);
    }

    public void zzb(zzpm.zzb<Achievements.LoadAchievementsResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new AchievementsLoadedBinderCallback(zzb2), string, string2, bl);
    }

    public void zzc(zzpm.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzasa()).zzd((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string, string2);
    }

    public void zzd(zzpm.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzasa()).zze((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string, string2);
    }

    public void zzf(zzpm.zzb<Invitations.LoadInvitationsResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzasa()).zzb((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), string, n, false);
    }

    public void zzm(zzpm.zzb<Invitations.LoadInvitationsResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzasa()).zzj((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), string);
    }

    public void zza(zzpm.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2, String string, int n, int[] nArray) throws RemoteException {
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(zzb2), string, n, nArray);
    }

    public void zze(zzpm.zzb<Notifications.GameMuteStatusChangeResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new GameMuteStatusChangedBinderCallback(zzb2), string, bl);
    }

    public void zzn(zzpm.zzb<Notifications.GameMuteStatusLoadResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzasa()).zzi((IGamesCallbacks)new GameMuteStatusLoadedBinderCallback(zzb2), string);
    }

    public void zzl(zzpm.zzb<Notifications.ContactSettingLoadResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzasa()).zze((IGamesCallbacks)new ContactSettingsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zzpm.zzb<Status> zzb2, boolean bl, boolean bl2, Bundle bundle) throws RemoteException {
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new ContactSettingsUpdatedBinderCallback(zzb2), bl, bl2, bundle);
    }

    public void zzs(zzpm.zzb<Notifications.InboxCountResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzasa()).zzs(new InboxCountsLoadedBinderCallback(zzb2), null);
    }

    public void zza(zzpm.zzb<Requests.SendRequestResult> zzb2, String string, String[] stringArray, int n, byte[] byArray, int n2) throws RemoteException {
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new RequestSentBinderCallbacks(zzb2), string, stringArray, n, byArray, n2);
    }

    public void zza(zzpm.zzb<Requests.UpdateRequestsResult> zzb2, String string, String string2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), string, string2, stringArray);
    }

    public void zza(zzpm.zzb<Requests.LoadRequestsResult> zzb2, String string, String string2, int n, int n2, int n3) throws RemoteException {
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new RequestsLoadedBinderCallbacks(zzb2), string, string2, n, n2, n3);
    }

    public void zzg(zzpm.zzb<Requests.LoadRequestSummariesResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzasa()).zza((IGamesCallbacks)new RequestSummariesLoadedBinderCallbacks(zzb2), string, n);
    }

    public void zzc(zzpm.zzb<Snapshots.LoadSnapshotsResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzasa()).zzc((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(zzb2), string, string2, bl);
    }

    public void zza(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.zzasa()).zza(iBinder, bundle);
            }
            catch (RemoteException remoteException) {
                this.zzb(remoteException);
            }
        }
    }

    public void zzbib() {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.zzasa()).zzbib();
            }
            catch (RemoteException remoteException) {
                this.zzb(remoteException);
            }
        }
    }

    private void zzb(RemoteException remoteException) {
        GamesLog.zzc("GamesClientImpl", "service died", remoteException);
    }

    private static Room zzbi(DataHolder dataHolder) {
        RoomBuffer roomBuffer = new RoomBuffer(dataHolder);
        Room room = null;
        try {
            if (roomBuffer.getCount() > 0) {
                room = (Room)((Room)roomBuffer.get(0)).freeze();
            }
        }
        finally {
            roomBuffer.release();
        }
        return room;
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (n == 0 && bundle != null) {
            bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            this.Rf = bundle.getBoolean("show_welcome_popup");
            this.Rc = (PlayerEntity)bundle.getParcelable("com.google.android.gms.games.current_player");
            this.Rd = (GameEntity)bundle.getParcelable("com.google.android.gms.games.current_game");
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public void zzo(zzpm.zzb<Social.InviteUpdateResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzasa()).zzu(new SendFriendInviteFirstPartyBinderCallback(zzb2), string);
    }

    public void zzp(zzpm.zzb<Social.InviteUpdateResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzasa()).zzv(new AcceptFriendInviteFirstPartyBinderCallback(zzb2), string);
    }

    public void zzq(zzpm.zzb<Social.InviteUpdateResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzasa()).zzw(new IgnoreFriendInviteFirstPartyBinderCallback(zzb2), string);
    }

    public void zzr(zzpm.zzb<Social.InviteUpdateResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzasa()).zzx(new CancelFriendInviteFirstPartyBinderCallback(zzb2), string);
    }

    public void zze(zzpm.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzasa()).zzf(new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzs(zzpm.zzb<Players.LoadPlayersResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzasa()).zzy(new PlayerUnfriendedBinderCallback(zzb2), string);
    }

    public void zzf(zzpm.zzb<Players.LoadPlayersResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzasa()).zzg(new SetPlayerMutedBinderCallback(zzb2), string, bl);
    }

    public void zzc(zzpm.zzb<Social.LoadInvitesResult> zzb2, int n) throws RemoteException {
        ((IGamesService)this.zzasa()).zzb((IGamesCallbacks)new InvitesLoadedBinderCallback(zzb2), n);
    }

    public void zza(Account account, byte[] byArray) throws RemoteException {
        ((IGamesService)this.zzasa()).zza(account, byArray);
    }

    public void zze(Account account) throws RemoteException {
        ((IGamesService)this.zzasa()).zze(account);
    }

    protected /* synthetic */ IInterface zzbb(IBinder iBinder) {
        return this.zzgg(iBinder);
    }

    private static final class ListVideosResultImpl
    extends GamesDataHolderResult
    implements Videos.ListVideosResult {
        private final VideoBuffer RG;

        public ListVideosResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.RG = new VideoBuffer(dataHolder);
        }
    }

    private static final class CaptureStreamingUrlResultImpl
    implements Videos.CaptureStreamingUrlResult {
        private final Status bY;
        private final String zzae;

        CaptureStreamingUrlResultImpl(Status status, String string) {
            this.bY = status;
            this.zzae = string;
        }

        public Status getStatus() {
            return this.bY;
        }

        @Override
        public String getUrl() {
            return this.zzae;
        }
    }

    private static final class CaptureStreamingMetadataResultImpl
    implements Videos.CaptureStreamingMetadataResult {
        private final Status bY;
        private final String DZ;
        private final String zzcvf;

        CaptureStreamingMetadataResultImpl(Status status, String string, String string2) {
            this.bY = status;
            this.DZ = string;
            this.zzcvf = string2;
        }

        public Status getStatus() {
            return this.bY;
        }
    }

    private static final class CaptureStreamingEnabledResultImpl
    implements Result {
        public Status getStatus() {
            return null;
        }
    }

    private static final class CaptureStreamingAvailabilityResultImpl
    implements Videos.CaptureStreamingAvailabilityResult {
        private final Status bY;
        private final boolean Ro;
        private final boolean Rv;

        CaptureStreamingAvailabilityResultImpl(Status status, boolean bl, boolean bl2) {
            this.bY = status;
            this.Ro = bl;
            this.Rv = bl2;
        }

        public Status getStatus() {
            return this.bY;
        }
    }

    private static final class CaptureStoppedResultImpl
    implements Videos.CaptureStoppedResult {
        private final Status bY;
        private final Uri Ru;

        CaptureStoppedResultImpl(Status status, Uri uri) {
            this.bY = status;
            this.Ru = uri;
        }

        public Status getStatus() {
            return this.bY;
        }
    }

    private static final class CaptureStateResultImpl
    implements Videos.CaptureStateResult {
        private final Status bY;
        private final CaptureState Rt;

        CaptureStateResultImpl(Status status, CaptureState captureState) {
            this.bY = status;
            this.Rt = captureState;
        }

        public Status getStatus() {
            return this.bY;
        }

        @Override
        public CaptureState getCaptureState() {
            return this.Rt;
        }
    }

    private static final class CaptureCapabilitiesResultImpl
    implements Videos.CaptureCapabilitiesResult {
        private final Status bY;
        private final VideoCapabilities Rp;

        CaptureCapabilitiesResultImpl(Status status, VideoCapabilities videoCapabilities) {
            this.bY = status;
            this.Rp = videoCapabilities;
        }

        public Status getStatus() {
            return this.bY;
        }

        @Override
        public VideoCapabilities getCapabilities() {
            return this.Rp;
        }
    }

    private static final class CaptureAvailableResultImpl
    implements Videos.CaptureAvailableResult {
        private final Status bY;
        private final boolean Ro;

        CaptureAvailableResultImpl(Status status, boolean bl) {
            this.bY = status;
            this.Ro = bl;
        }

        public Status getStatus() {
            return this.bY;
        }

        @Override
        public boolean isAvailable() {
            return this.Ro;
        }
    }

    private static final class InviteUpdateResultImpl
    extends GamesDataHolderResult
    implements Social.InviteUpdateResult {
        private final SocialInvite RD;

        InviteUpdateResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            SocialInviteBuffer socialInviteBuffer = new SocialInviteBuffer(dataHolder);
            try {
                this.RD = socialInviteBuffer.getCount() > 0 ? new SocialInviteEntity((SocialInvite)socialInviteBuffer.get(0)) : null;
            }
            finally {
                socialInviteBuffer.release();
            }
        }
    }

    private static final class DeleteSnapshotResultImpl
    implements Snapshots.DeleteSnapshotResult {
        private final Status bY;
        private final String Ry;

        DeleteSnapshotResultImpl(int n, String string) {
            this.bY = GamesStatusCodes.zzpw(n);
            this.Ry = string;
        }

        public Status getStatus() {
            return this.bY;
        }

        @Override
        public String getSnapshotId() {
            return this.Ry;
        }
    }

    private static final class CommitSnapshotResultImpl
    extends GamesDataHolderResult
    implements Snapshots.CommitSnapshotResult {
        private final SnapshotMetadata Rx;

        CommitSnapshotResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                this.Rx = snapshotMetadataBuffer.getCount() > 0 ? new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0)) : null;
            }
            finally {
                snapshotMetadataBuffer.release();
            }
        }

        @Override
        public SnapshotMetadata getSnapshotMetadata() {
            return this.Rx;
        }
    }

    private static final class OpenSnapshotResultImpl
    extends GamesDataHolderResult
    implements Snapshots.OpenSnapshotResult {
        private final Snapshot Sd;
        private final String Se;
        private final Snapshot Sf;
        private final Contents Sg;
        private final SnapshotContents Sh;

        OpenSnapshotResultImpl(DataHolder dataHolder, Contents contents) {
            this(dataHolder, null, contents, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        OpenSnapshotResultImpl(DataHolder dataHolder, String string, Contents contents, Contents contents2, Contents contents3) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                if (snapshotMetadataBuffer.getCount() == 0) {
                    this.Sd = null;
                    this.Sf = null;
                } else if (snapshotMetadataBuffer.getCount() == 1) {
                    zzb.zzbn((dataHolder.getStatusCode() != 4004 ? 1 : 0) != 0);
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.Sd = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContentsEntity(contents));
                    this.Sf = null;
                } else {
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.Sd = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContentsEntity(contents));
                    SnapshotMetadataEntity snapshotMetadataEntity2 = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(1));
                    this.Sf = new SnapshotEntity(snapshotMetadataEntity2, new SnapshotContentsEntity(contents2));
                }
            }
            finally {
                snapshotMetadataBuffer.release();
            }
            this.Se = string;
            this.Sg = contents3;
            this.Sh = new SnapshotContentsEntity(contents3);
        }

        @Override
        public Snapshot getSnapshot() {
            return this.Sd;
        }

        @Override
        public String getConflictId() {
            return this.Se;
        }

        @Override
        public Snapshot getConflictingSnapshot() {
            return this.Sf;
        }

        @Override
        public SnapshotContents getResolutionSnapshotContents() {
            return this.Sh;
        }
    }

    private static final class LoadSnapshotsResultImpl
    extends GamesDataHolderResult
    implements Snapshots.LoadSnapshotsResult {
        LoadSnapshotsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public SnapshotMetadataBuffer getSnapshots() {
            return new SnapshotMetadataBuffer(this.tu);
        }
    }

    private static final class LoadPlayerStatsResultImpl
    extends GamesDataHolderResult
    implements Stats.LoadPlayerStatsResult {
        private final PlayerStats RR;

        LoadPlayerStatsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            PlayerStatsBuffer playerStatsBuffer = new PlayerStatsBuffer(dataHolder);
            try {
                this.RR = playerStatsBuffer.getCount() > 0 ? new PlayerStatsEntity((PlayerStats)playerStatsBuffer.get(0)) : null;
            }
            finally {
                playerStatsBuffer.release();
            }
        }

        @Override
        public PlayerStats getPlayerStats() {
            return this.RR;
        }
    }

    private static final class LoadAppContentsResultImpl
    extends GamesDataHolderResult
    implements AppContents.LoadAppContentResult {
        private final ArrayList<DataHolder> RI;

        LoadAppContentsResultImpl(DataHolder[] dataHolderArray) {
            super(dataHolderArray[0]);
            this.RI = new ArrayList<DataHolder>(Arrays.asList(dataHolderArray));
        }
    }

    private static final class ClaimMilestoneResultImpl
    extends GamesDataHolderResult
    implements Quests.ClaimMilestoneResult {
        private final Milestone Rw;
        private final Quest Rl;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClaimMilestoneResultImpl(DataHolder dataHolder, String string) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                if (questBuffer.getCount() > 0) {
                    this.Rl = new QuestEntity((Quest)questBuffer.get(0));
                    List<Milestone> list = this.Rl.zzbkk();
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        if (!list.get(i).getMilestoneId().equals(string)) continue;
                        this.Rw = list.get(i);
                        return;
                    }
                    this.Rw = null;
                } else {
                    this.Rw = null;
                    this.Rl = null;
                }
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Milestone getMilestone() {
            return this.Rw;
        }

        @Override
        public Quest getQuest() {
            return this.Rl;
        }
    }

    private static final class AcceptQuestResultImpl
    extends GamesDataHolderResult
    implements Quests.AcceptQuestResult {
        private final Quest Rl;

        AcceptQuestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                this.Rl = questBuffer.getCount() > 0 ? new QuestEntity((Quest)questBuffer.get(0)) : null;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Quest getQuest() {
            return this.Rl;
        }
    }

    private static final class LoadQuestsResultImpl
    extends GamesDataHolderResult
    implements Quests.LoadQuestsResult {
        private final DataHolder tu;

        LoadQuestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.tu = dataHolder;
        }

        @Override
        public QuestBuffer getQuests() {
            return new QuestBuffer(this.tu);
        }
    }

    private static final class LoadRequestSummariesResultImpl
    extends GamesDataHolderResult
    implements Requests.LoadRequestSummariesResult {
        LoadRequestSummariesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadRequestsResultImpl
    implements Requests.LoadRequestsResult {
        private final Status bY;
        private final Bundle RT;

        LoadRequestsResultImpl(Status status, Bundle bundle) {
            this.bY = status;
            this.RT = bundle;
        }

        public Status getStatus() {
            return this.bY;
        }

        @Override
        public GameRequestBuffer getRequests(int n) {
            String string = RequestType.zzqw(n);
            if (!this.RT.containsKey(string)) {
                return null;
            }
            DataHolder dataHolder = (DataHolder)this.RT.get(string);
            return new GameRequestBuffer(dataHolder);
        }

        public void release() {
            for (String string : this.RT.keySet()) {
                DataHolder dataHolder = (DataHolder)this.RT.getParcelable(string);
                if (dataHolder == null) continue;
                dataHolder.close();
            }
        }
    }

    private static final class UpdateRequestsResultImpl
    extends GamesDataHolderResult
    implements Requests.UpdateRequestsResult {
        private final RequestUpdateOutcomes SK;

        UpdateRequestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.SK = RequestUpdateOutcomes.zzbl(dataHolder);
        }

        @Override
        public int getRequestOutcome(String string) {
            return this.SK.getRequestOutcome(string);
        }

        @Override
        public Set<String> getRequestIds() {
            return this.SK.getRequestIds();
        }
    }

    private static final class SendRequestResultImpl
    extends GamesDataHolderResult
    implements Requests.SendRequestResult {
        private final GameRequest Sq;

        SendRequestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            try {
                this.Sq = gameRequestBuffer.getCount() > 0 ? (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze() : null;
            }
            finally {
                gameRequestBuffer.release();
            }
        }
    }

    private static final class InboxCountResultImpl
    implements Notifications.InboxCountResult {
        private final Status bY;
        private final Bundle RB;

        InboxCountResultImpl(Status status, Bundle bundle) {
            this.bY = status;
            this.RB = bundle;
        }

        public Status getStatus() {
            return this.bY;
        }
    }

    private static final class GetServerAuthCodeResultImpl
    implements Games.GetServerAuthCodeResult {
        private final Status bY;
        private final String RA;

        GetServerAuthCodeResultImpl(Status status, String string) {
            this.bY = status;
            this.RA = string;
        }

        public Status getStatus() {
            return this.bY;
        }

        @Override
        public String getCode() {
            return this.RA;
        }
    }

    private static final class GetTokenResultImpl
    implements Games.GetTokenResult {
        private final Status bY;
        private final String co;

        GetTokenResultImpl(Status status, String string) {
            this.bY = status;
            this.co = string;
        }

        public Status getStatus() {
            return this.bY;
        }
    }

    private static final class ContactSettingLoadResultImpl
    extends GamesDataHolderResult
    implements Notifications.ContactSettingLoadResult {
        ContactSettingLoadResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class GameMuteStatusLoadResultImpl
    implements Notifications.GameMuteStatusLoadResult {
        private final Status bY;
        private final String Rz;
        private final boolean zzcqc;

        public GameMuteStatusLoadResultImpl(DataHolder dataHolder) {
            try {
                this.bY = GamesStatusCodes.zzpw(dataHolder.getStatusCode());
                if (dataHolder.getCount() > 0) {
                    this.Rz = dataHolder.zzd("external_game_id", 0, 0);
                    this.zzcqc = dataHolder.zze("muted", 0, 0);
                } else {
                    this.Rz = null;
                    this.zzcqc = false;
                }
            }
            finally {
                dataHolder.close();
            }
        }

        public Status getStatus() {
            return this.bY;
        }
    }

    private static final class GameMuteStatusChangeResultImpl
    implements Notifications.GameMuteStatusChangeResult {
        private final Status bY;
        private final String Rz;
        private final boolean zzcqc;

        public GameMuteStatusChangeResultImpl(int n, String string, boolean bl) {
            this.bY = GamesStatusCodes.zzpw(n);
            this.Rz = string;
            this.zzcqc = bl;
        }

        public Status getStatus() {
            return this.bY;
        }
    }

    private static final class CancelMatchResultImpl
    implements TurnBasedMultiplayer.CancelMatchResult {
        private final Status bY;
        private final String Rn;

        CancelMatchResultImpl(Status status, String string) {
            this.bY = status;
            this.Rn = string;
        }

        public Status getStatus() {
            return this.bY;
        }

        @Override
        public String getMatchId() {
            return this.Rn;
        }
    }

    private static final class LeaveMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LeaveMatchResult {
        LeaveMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class UpdateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.UpdateMatchResult {
        UpdateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class InitiateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.InitiateMatchResult {
        InitiateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LoadMatchResult {
        LoadMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static abstract class TurnBasedMatchResult
    extends GamesDataHolderResult {
        final TurnBasedMatch Sb;

        TurnBasedMatchResult(DataHolder dataHolder) {
            super(dataHolder);
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            try {
                this.Sb = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
            }
            finally {
                turnBasedMatchBuffer.release();
            }
        }

        public TurnBasedMatch getMatch() {
            return this.Sb;
        }
    }

    private static final class SubmitScoreResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.SubmitScoreResult {
        private final ScoreSubmissionData SC;

        public SubmitScoreResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try {
                this.SC = new ScoreSubmissionData(dataHolder);
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public ScoreSubmissionData getScoreData() {
            return this.SC;
        }
    }

    private static final class UpdateGamerProfileResultImpl
    implements Players.UpdateGamerProfileResult {
        private final Status bY;
        private final Bundle SJ;

        UpdateGamerProfileResultImpl(int n, Bundle bundle) {
            this.bY = new Status(n);
            this.SJ = bundle;
        }

        public Status getStatus() {
            return this.bY;
        }
    }

    private static final class LoadStockProfileImagesResultImpl
    extends GamesDataHolderResult
    implements Players.LoadStockProfileImagesResult {
        private final StockProfileImageBuffer RW;

        LoadStockProfileImagesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.RW = new StockProfileImageBuffer(dataHolder);
        }

        public Status getStatus() {
            return this.bY;
        }
    }

    private static final class LoadXpStreamResultImpl
    extends GamesDataHolderResult
    implements Players.LoadXpStreamResult {
        private final ExperienceEventBuffer RZ;

        LoadXpStreamResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.RZ = new ExperienceEventBuffer(dataHolder);
        }
    }

    private static final class LoadXpForGameCategoriesResultImpl
    implements Players.LoadXpForGameCategoriesResult {
        private final Status bY;
        private final List<String> RX;
        private final Bundle RY;

        LoadXpForGameCategoriesResultImpl(Status status, Bundle bundle) {
            this.bY = status;
            this.RX = bundle.getStringArrayList("game_category_list");
            this.RY = bundle;
        }

        public Status getStatus() {
            return this.bY;
        }
    }

    private static final class LoadInvitesResultImpl
    extends GamesDataHolderResult
    implements Social.LoadInvitesResult {
        private final SocialInviteBuffer RO;

        LoadInvitesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.RO = new SocialInviteBuffer(dataHolder);
        }
    }

    private static final class LoadPlayersResultImpl
    extends GamesDataHolderResult
    implements Players.LoadPlayersResult {
        private final PlayerBuffer RS;

        LoadPlayersResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.RS = new PlayerBuffer(dataHolder);
        }

        @Override
        public PlayerBuffer getPlayers() {
            return this.RS;
        }
    }

    private static final class LoadMatchesResultImpl
    implements TurnBasedMultiplayer.LoadMatchesResult {
        private final Status bY;
        private final LoadMatchesResponse RP;

        LoadMatchesResultImpl(Status status, Bundle bundle) {
            this.bY = status;
            this.RP = new LoadMatchesResponse(bundle);
        }

        public Status getStatus() {
            return this.bY;
        }

        @Override
        public LoadMatchesResponse getMatches() {
            return this.RP;
        }

        public void release() {
            this.RP.release();
        }
    }

    private static final class LoadInvitationsResultImpl
    extends GamesDataHolderResult
    implements Invitations.LoadInvitationsResult {
        private final InvitationBuffer RN;

        LoadInvitationsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.RN = new InvitationBuffer(dataHolder);
        }

        @Override
        public InvitationBuffer getInvitations() {
            return this.RN;
        }
    }

    private static final class LoadPlayerScoreResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LoadPlayerScoreResult {
        private final LeaderboardScoreEntity RQ;

        LoadPlayerScoreResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(dataHolder);
            try {
                this.RQ = leaderboardScoreBuffer.getCount() > 0 ? (LeaderboardScoreEntity)((LeaderboardScore)leaderboardScoreBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardScoreBuffer.release();
            }
        }

        @Override
        public LeaderboardScore getScore() {
            return this.RQ;
        }
    }

    private static final class LoadScoresResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LoadScoresResult {
        private final LeaderboardEntity RU;
        private final LeaderboardScoreBuffer RV;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadScoresResultImpl(DataHolder dataHolder, DataHolder dataHolder2) {
            super(dataHolder2);
            LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(dataHolder);
            try {
                this.RU = leaderboardBuffer.getCount() > 0 ? (LeaderboardEntity)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardBuffer.release();
            }
            this.RV = new LeaderboardScoreBuffer(dataHolder2);
        }

        @Override
        public Leaderboard getLeaderboard() {
            return this.RU;
        }

        @Override
        public LeaderboardScoreBuffer getScores() {
            return this.RV;
        }
    }

    private static final class LeaderboardMetadataResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LeaderboardMetadataResult {
        private final LeaderboardBuffer RE;

        LeaderboardMetadataResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.RE = new LeaderboardBuffer(dataHolder);
        }

        @Override
        public LeaderboardBuffer getLeaderboards() {
            return this.RE;
        }
    }

    private static final class LoadGameSearchSuggestionsResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGameSearchSuggestionsResult {
        private final GameSearchSuggestionBuffer RL;

        LoadGameSearchSuggestionsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.RL = new GameSearchSuggestionBuffer(dataHolder);
        }
    }

    private static final class LoadGameInstancesResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGameInstancesResult {
        private final GameInstanceBuffer RK;

        LoadGameInstancesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.RK = new GameInstanceBuffer(dataHolder);
        }
    }

    private static final class LoadGamesResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGamesResult {
        private final GameBuffer RM;

        LoadGamesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.RM = new GameBuffer(dataHolder);
        }

        @Override
        public GameBuffer getGames() {
            return this.RM;
        }
    }

    private static final class LoadEventResultImpl
    extends GamesDataHolderResult
    implements Events.LoadEventsResult {
        private final EventBuffer RJ;

        LoadEventResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.RJ = new EventBuffer(dataHolder);
        }

        @Override
        public EventBuffer getEvents() {
            return this.RJ;
        }
    }

    private static final class UpdateAchievementResultImpl
    implements Achievements.UpdateAchievementResult {
        private final Status bY;
        private final String Qn;

        UpdateAchievementResultImpl(int n, String string) {
            this.bY = GamesStatusCodes.zzpw(n);
            this.Qn = string;
        }

        public Status getStatus() {
            return this.bY;
        }

        @Override
        public String getAchievementId() {
            return this.Qn;
        }
    }

    private static final class LoadAchievementsResultImpl
    extends GamesDataHolderResult
    implements Achievements.LoadAchievementsResult {
        private final AchievementBuffer RH;

        LoadAchievementsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.RH = new AchievementBuffer(dataHolder);
        }

        @Override
        public AchievementBuffer getAchievements() {
            return this.RH;
        }
    }

    private static abstract class GamesDataHolderResult
    extends zzpt {
        protected GamesDataHolderResult(DataHolder dataHolder) {
            super(dataHolder, GamesStatusCodes.zzpw(dataHolder.getStatusCode()));
        }
    }

    private static final class RealTimeMessageSentNotifier
    implements zzqn.zzb<RealTimeMultiplayer.ReliableMessageSentCallback> {
        private final int ok;
        private final String Sn;
        private final int So;

        RealTimeMessageSentNotifier(int n, int n2, String string) {
            this.ok = n;
            this.So = n2;
            this.Sn = string;
        }

        public void zza(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback) {
            if (reliableMessageSentCallback != null) {
                reliableMessageSentCallback.onRealTimeMessageSent(this.ok, this.So, this.Sn);
            }
        }

        public void zzapj() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((RealTimeMultiplayer.ReliableMessageSentCallback)object);
        }
    }

    private static final class MessageReceivedNotifier
    implements zzqn.zzb<RealTimeMessageReceivedListener> {
        private final RealTimeMessage Sc;

        MessageReceivedNotifier(RealTimeMessage realTimeMessage) {
            this.Sc = realTimeMessage;
        }

        public void zza(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            realTimeMessageReceivedListener.onRealTimeMessageReceived(this.Sc);
        }

        public void zzapj() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((RealTimeMessageReceivedListener)object);
        }
    }

    private static final class P2PDisconnectedNotifier
    implements zzqn.zzb<RoomStatusUpdateListener> {
        private final String Si;

        P2PDisconnectedNotifier(String string) {
            this.Si = string;
        }

        public void zza(RoomStatusUpdateListener roomStatusUpdateListener) {
            roomStatusUpdateListener.onP2PDisconnected(this.Si);
        }

        public void zzapj() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((RoomStatusUpdateListener)object);
        }
    }

    private static final class P2PConnectedNotifier
    implements zzqn.zzb<RoomStatusUpdateListener> {
        private final String Si;

        P2PConnectedNotifier(String string) {
            this.Si = string;
        }

        public void zza(RoomStatusUpdateListener roomStatusUpdateListener) {
            roomStatusUpdateListener.onP2PConnected(this.Si);
        }

        public void zzapj() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((RoomStatusUpdateListener)object);
        }
    }

    private static final class PeerDisconnectedNotifier
    extends AbstractPeerStatusNotifier {
        PeerDisconnectedNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    private static final class PeerConnectedNotifier
    extends AbstractPeerStatusNotifier {
        PeerConnectedNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    private static final class PeerDeclinedNotifier
    extends AbstractPeerStatusNotifier {
        PeerDeclinedNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    private static final class PeerLeftRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerLeftRoomNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    private static final class PeerJoinedRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerJoinedRoomNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    private static final class PeerInvitedToRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerInvitedToRoomNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    private static final class DisconnectedFromRoomNotifier
    extends AbstractRoomStatusNotifier {
        DisconnectedFromRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    private static final class ConnectedToRoomNotifier
    extends AbstractRoomStatusNotifier {
        ConnectedToRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    private static final class RoomAutoMatchingNotifier
    extends AbstractRoomStatusNotifier {
        RoomAutoMatchingNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    private static final class RoomConnectingNotifier
    extends AbstractRoomStatusNotifier {
        RoomConnectingNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    private static final class RoomConnectedNotifier
    extends AbstractRoomNotifier {
        RoomConnectedNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomConnected(n, room);
        }
    }

    private static final class LeftRoomNotifier
    implements zzqn.zzb<RoomUpdateListener> {
        private final int ok;
        private final String RF;

        LeftRoomNotifier(int n, String string) {
            this.ok = n;
            this.RF = string;
        }

        public void zza(RoomUpdateListener roomUpdateListener) {
            roomUpdateListener.onLeftRoom(this.ok, this.RF);
        }

        public void zzapj() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((RoomUpdateListener)object);
        }
    }

    private static final class JoinedRoomNotifier
    extends AbstractRoomNotifier {
        public JoinedRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onJoinedRoom(n, room);
        }
    }

    private static final class RoomCreatedNotifier
    extends AbstractRoomNotifier {
        public RoomCreatedNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomCreated(n, room);
        }
    }

    private static abstract class AbstractPeerStatusNotifier
    extends AbstractRoomStatusNotifier {
        private final ArrayList<String> Rk = new ArrayList();

        AbstractPeerStatusNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                this.Rk.add(stringArray[i]);
            }
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.zza(roomStatusUpdateListener, room, this.Rk);
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    private static abstract class AbstractRoomStatusNotifier
    extends zzps<RoomStatusUpdateListener> {
        AbstractRoomStatusNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            this.zza(roomStatusUpdateListener, GamesClientImpl.zzbi(dataHolder));
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2);
    }

    private static abstract class AbstractRoomNotifier
    extends zzps<RoomUpdateListener> {
        AbstractRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected void zza(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            this.zza(roomUpdateListener, GamesClientImpl.zzbi(dataHolder), dataHolder.getStatusCode());
        }

        protected abstract void zza(RoomUpdateListener var1, Room var2, int var3);
    }

    private static final class NearbyPlayerDetectedNotifier
    implements zzqn.zzb<OnNearbyPlayerDetectedListener> {
        public void zza(OnNearbyPlayerDetectedListener onNearbyPlayerDetectedListener) {
            onNearbyPlayerDetectedListener.zza(null);
        }

        public void zzapj() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnNearbyPlayerDetectedListener)object);
        }
    }

    private static final class SocialInviteRemovedNotifier
    implements zzqn.zzb<OnSocialInviteUpdateReceivedListener> {
        private final SocialInvite SB;

        SocialInviteRemovedNotifier(SocialInvite socialInvite) {
            this.SB = socialInvite;
        }

        public void zza(OnSocialInviteUpdateReceivedListener onSocialInviteUpdateReceivedListener) {
            onSocialInviteUpdateReceivedListener.zzb(this.SB);
        }

        public void zzapj() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnSocialInviteUpdateReceivedListener)object);
        }
    }

    private static final class SocialInviteUpdateReceivedNotifier
    implements zzqn.zzb<OnSocialInviteUpdateReceivedListener> {
        private final SocialInvite SB;

        SocialInviteUpdateReceivedNotifier(SocialInvite socialInvite) {
            this.SB = socialInvite;
        }

        public void zza(OnSocialInviteUpdateReceivedListener onSocialInviteUpdateReceivedListener) {
            onSocialInviteUpdateReceivedListener.zza(this.SB);
        }

        public void zzapj() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnSocialInviteUpdateReceivedListener)object);
        }
    }

    private static final class RequestRemovedNotifier
    implements zzqn.zzb<OnRequestReceivedListener> {
        private final String zzbvq;

        RequestRemovedNotifier(String string) {
            this.zzbvq = string;
        }

        public void zza(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestRemoved(this.zzbvq);
        }

        public void zzapj() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnRequestReceivedListener)object);
        }
    }

    private static final class RequestReceivedNotifier
    implements zzqn.zzb<OnRequestReceivedListener> {
        private final GameRequest Sq;

        RequestReceivedNotifier(GameRequest gameRequest) {
            this.Sq = gameRequest;
        }

        public void zza(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestReceived(this.Sq);
        }

        public void zzapj() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnRequestReceivedListener)object);
        }
    }

    private static final class QuestCompletedNotifier
    implements zzqn.zzb<QuestUpdateListener> {
        private final Quest Rl;

        QuestCompletedNotifier(Quest quest) {
            this.Rl = quest;
        }

        public void zza(QuestUpdateListener questUpdateListener) {
            questUpdateListener.onQuestCompleted(this.Rl);
        }

        public void zzapj() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((QuestUpdateListener)object);
        }
    }

    private static final class MatchRemovedNotifier
    implements zzqn.zzb<OnTurnBasedMatchUpdateReceivedListener> {
        private final String Sa;

        MatchRemovedNotifier(String string) {
            this.Sa = string;
        }

        public void zza(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(this.Sa);
        }

        public void zzapj() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private static final class MatchUpdateReceivedNotifier
    implements zzqn.zzb<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch Sb;

        MatchUpdateReceivedNotifier(TurnBasedMatch turnBasedMatch) {
            this.Sb = turnBasedMatch;
        }

        public void zza(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(this.Sb);
        }

        public void zzapj() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private static final class InvitationRemovedNotifier
    implements zzqn.zzb<OnInvitationReceivedListener> {
        private final String bP;

        InvitationRemovedNotifier(String string) {
            this.bP = string;
        }

        public void zza(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationRemoved(this.bP);
        }

        public void zzapj() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnInvitationReceivedListener)object);
        }
    }

    private static final class InvitationReceivedNotifier
    implements zzqn.zzb<OnInvitationReceivedListener> {
        private final Invitation RC;

        InvitationReceivedNotifier(Invitation invitation) {
            this.RC = invitation;
        }

        public void zza(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationReceived(this.RC);
        }

        public void zzapj() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnInvitationReceivedListener)object);
        }
    }

    private static final class CaptureOverlayStateChangedNotifier
    implements zzqn.zzb<Videos.CaptureOverlayStateListener> {
        private final int Rr;

        CaptureOverlayStateChangedNotifier(int n) {
            this.Rr = n;
        }

        public void zza(Videos.CaptureOverlayStateListener captureOverlayStateListener) {
            captureOverlayStateListener.onCaptureOverlayStateChanged(this.Rr);
        }

        public void zzapj() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((Videos.CaptureOverlayStateListener)object);
        }
    }

    private static final class SetPlayerMutedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Players.LoadPlayersResult> zv;

        SetPlayerMutedBinderCallback(zzpm.zzb<Players.LoadPlayersResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbg(DataHolder dataHolder) {
            this.zv.setResult((Object)new LoadPlayersResultImpl(dataHolder));
        }
    }

    private static final class PlayerUnfriendedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Players.LoadPlayersResult> zv;

        PlayerUnfriendedBinderCallback(zzpm.zzb<Players.LoadPlayersResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbf(DataHolder dataHolder) {
            this.zv.setResult((Object)new LoadPlayersResultImpl(dataHolder));
        }
    }

    private static final class CancelFriendInviteFirstPartyBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Social.InviteUpdateResult> zv;

        CancelFriendInviteFirstPartyBinderCallback(zzpm.zzb<Social.InviteUpdateResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbe(DataHolder dataHolder) {
            this.zv.setResult((Object)new InviteUpdateResultImpl(dataHolder));
        }
    }

    private static final class IgnoreFriendInviteFirstPartyBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Social.InviteUpdateResult> zv;

        IgnoreFriendInviteFirstPartyBinderCallback(zzpm.zzb<Social.InviteUpdateResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbd(DataHolder dataHolder) {
            this.zv.setResult((Object)new InviteUpdateResultImpl(dataHolder));
        }
    }

    private static final class AcceptFriendInviteFirstPartyBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Social.InviteUpdateResult> zv;

        AcceptFriendInviteFirstPartyBinderCallback(zzpm.zzb<Social.InviteUpdateResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzba(DataHolder dataHolder) {
            this.zv.setResult((Object)new InviteUpdateResultImpl(dataHolder));
        }
    }

    private static final class SendFriendInviteFirstPartyBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Social.InviteUpdateResult> zv;

        SendFriendInviteFirstPartyBinderCallback(zzpm.zzb<Social.InviteUpdateResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzaz(DataHolder dataHolder) {
            this.zv.setResult((Object)new InviteUpdateResultImpl(dataHolder));
        }
    }

    private static final class UpdateHeadlessCapturePermissionBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Status> zv;

        UpdateHeadlessCapturePermissionBinderCallback(zzpm.zzb<Status> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbj(Status status) {
            this.zv.setResult((Object)status);
        }
    }

    private static final class ListVideosBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Videos.ListVideosResult> zv;

        ListVideosBinderCallback(zzpm.zzb<Videos.ListVideosResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzax(DataHolder dataHolder) {
            this.zv.setResult((Object)new ListVideosResultImpl(dataHolder));
        }
    }

    private static final class CaptureStreamingUrlBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Videos.CaptureStreamingUrlResult> zv;

        CaptureStreamingUrlBinderCallback(zzpm.zzb<Videos.CaptureStreamingUrlResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzm(int n, String string) {
            this.zv.setResult((Object)new CaptureStreamingUrlResultImpl(new Status(n), string));
        }
    }

    private static final class CaptureStreamingMetadataBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Videos.CaptureStreamingMetadataResult> zv;

        CaptureStreamingMetadataBinderCallback(zzpm.zzb<Videos.CaptureStreamingMetadataResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzd(int n, String string, String string2) {
            this.zv.setResult((Object)new CaptureStreamingMetadataResultImpl(new Status(n), string, string2));
        }
    }

    private static final class CaptureStreamingEnabledBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Status> zv;

        CaptureStreamingEnabledBinderCallback(zzpm.zzb<Status> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzql(int n) {
            this.zv.setResult((Object)new Status(n));
        }
    }

    private static final class CaptureStreamingAvailabilityBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Videos.CaptureStreamingAvailabilityResult> zv;

        CaptureStreamingAvailabilityBinderCallback(zzpm.zzb<Videos.CaptureStreamingAvailabilityResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, boolean bl, boolean bl2) {
            this.zv.setResult((Object)new CaptureStreamingAvailabilityResultImpl(new Status(n), bl, bl2));
        }
    }

    private static final class CaptureStoppedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Videos.CaptureStoppedResult> zv;

        public CaptureStoppedBinderCallbacks(zzpm.zzb<Videos.CaptureStoppedResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, Uri uri) {
            this.zv.setResult((Object)new CaptureStoppedResultImpl(new Status(n), uri));
        }
    }

    private static final class CaptureStateBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Videos.CaptureStateResult> zv;

        public CaptureStateBinderCallbacks(zzpm.zzb<Videos.CaptureStateResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(int n, Bundle bundle) {
            this.zv.setResult((Object)new CaptureStateResultImpl(new Status(n), CaptureState.zzaa(bundle)));
        }
    }

    private static final class CaptureStartedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Status> zv;
        private final Videos.CaptureRuntimeErrorCallback Rs;

        public CaptureStartedBinderCallbacks(zzpm.zzb<Status> zzb2, Videos.CaptureRuntimeErrorCallback captureRuntimeErrorCallback) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
            this.Rs = (Videos.CaptureRuntimeErrorCallback)zzab.zzb((Object)captureRuntimeErrorCallback, (Object)"Callback must not be null");
        }

        @Override
        public void zzbk(Status status) {
            this.zv.setResult((Object)status);
        }

        @Override
        public void zzqp(int n) {
            this.Rs.zzsh(n);
        }
    }

    private static final class CapturePausedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Status> zv;

        public CapturePausedBinderCallback(zzpm.zzb<Status> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzqq(int n) {
            this.zv.setResult((Object)new Status(n));
        }
    }

    private static final class CaptureOverlayStateBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqn<Videos.CaptureOverlayStateListener> Gc;

        CaptureOverlayStateBinderCallback(zzqn<Videos.CaptureOverlayStateListener> zzqn2) {
            this.Gc = (zzqn)zzab.zzb(zzqn2, (Object)"Callback must not be null");
        }

        @Override
        public void onCaptureOverlayStateChanged(int n) {
            this.Gc.zza((zzqn.zzb)new CaptureOverlayStateChangedNotifier(n));
        }
    }

    private static final class CaptureLaunchGameAndOverlayBinderCallback
    extends AbstractGamesCallbacks {
        private final Games.BaseGamesApiMethodImpl<Status> Rq;

        CaptureLaunchGameAndOverlayBinderCallback(Games.BaseGamesApiMethodImpl<Status> baseGamesApiMethodImpl) {
            this.Rq = (Games.BaseGamesApiMethodImpl)((Object)zzab.zzb(baseGamesApiMethodImpl, (Object)"Holder must not be null"));
        }

        @Override
        public void zzqk(int n) {
            this.Rq.zzc((Result)new Status(n));
        }

        @Override
        public void zzbh(Status status) {
            this.Rq.zzc((Result)status);
        }
    }

    private static final class CaptureCapabilitiesBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Videos.CaptureCapabilitiesResult> zv;

        CaptureCapabilitiesBinderCallback(zzpm.zzb<Videos.CaptureCapabilitiesResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, VideoCapabilities videoCapabilities) {
            this.zv.setResult((Object)new CaptureCapabilitiesResultImpl(new Status(n), videoCapabilities));
        }
    }

    private static final class CaptureAvailableBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Videos.CaptureAvailableResult> zv;

        CaptureAvailableBinderCallback(zzpm.zzb<Videos.CaptureAvailableResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzg(int n, boolean bl) {
            this.zv.setResult((Object)new CaptureAvailableResultImpl(new Status(n), bl));
        }
    }

    private static final class HeadlessCaptureEnabledBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Status> zv;

        HeadlessCaptureEnabledBinderCallback(zzpm.zzb<Status> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbi(Status status) {
            this.zv.setResult((Object)status);
        }
    }

    static final class SnapshotDeletedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Snapshots.DeleteSnapshotResult> zv;

        public SnapshotDeletedBinderCallbacks(zzpm.zzb<Snapshots.DeleteSnapshotResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzl(int n, String string) {
            this.zv.setResult((Object)new DeleteSnapshotResultImpl(n, string));
        }
    }

    private static final class SnapshotCommittedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Snapshots.CommitSnapshotResult> Sy;

        public SnapshotCommittedBinderCallbacks(zzpm.zzb<Snapshots.CommitSnapshotResult> zzb2) {
            this.Sy = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzao(DataHolder dataHolder) {
            this.Sy.setResult((Object)new CommitSnapshotResultImpl(dataHolder));
        }
    }

    private static final class SnapshotOpenedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Snapshots.OpenSnapshotResult> Sz;

        public SnapshotOpenedBinderCallbacks(zzpm.zzb<Snapshots.OpenSnapshotResult> zzb2) {
            this.Sz = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder dataHolder, Contents contents) {
            this.Sz.setResult((Object)new OpenSnapshotResultImpl(dataHolder, contents));
        }

        @Override
        public void zza(DataHolder dataHolder, String string, Contents contents, Contents contents2, Contents contents3) {
            this.Sz.setResult((Object)new OpenSnapshotResultImpl(dataHolder, string, contents, contents2, contents3));
        }
    }

    private static final class SnapshotsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Snapshots.LoadSnapshotsResult> SA;

        public SnapshotsLoadedBinderCallbacks(zzpm.zzb<Snapshots.LoadSnapshotsResult> zzb2) {
            this.SA = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzan(DataHolder dataHolder) {
            this.SA.setResult((Object)new LoadSnapshotsResultImpl(dataHolder));
        }
    }

    private static final class PlayerStatsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Stats.LoadPlayerStatsResult> zv;

        public PlayerStatsLoadedBinderCallbacks(zzpm.zzb<Stats.LoadPlayerStatsResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzaw(DataHolder dataHolder) {
            this.zv.setResult((Object)new LoadPlayerStatsResultImpl(dataHolder));
        }
    }

    private static final class AppContentLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<AppContents.LoadAppContentResult> Rm;

        public AppContentLoadedBinderCallbacks(zzpm.zzb<AppContents.LoadAppContentResult> zzb2) {
            this.Rm = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder[] dataHolderArray) {
            this.Rm.setResult((Object)new LoadAppContentsResultImpl(dataHolderArray));
        }
    }

    private static final class QuestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Quests.LoadQuestsResult> Sm;

        public QuestsLoadedBinderCallbacks(zzpm.zzb<Quests.LoadQuestsResult> zzb2) {
            this.Sm = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzat(DataHolder dataHolder) {
            this.Sm.setResult((Object)new LoadQuestsResultImpl(dataHolder));
        }
    }

    private static final class QuestMilestoneClaimBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Quests.ClaimMilestoneResult> Sk;
        private final String Sl;

        public QuestMilestoneClaimBinderCallbacks(zzpm.zzb<Quests.ClaimMilestoneResult> zzb2, String string) {
            this.Sk = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
            this.Sl = (String)zzab.zzb((Object)string, (Object)"MilestoneId must not be null");
        }

        @Override
        public void zzap(DataHolder dataHolder) {
            this.Sk.setResult((Object)new ClaimMilestoneResultImpl(dataHolder, this.Sl));
        }
    }

    private static final class QuestAcceptedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Quests.AcceptQuestResult> Sj;

        public QuestAcceptedBinderCallbacks(zzpm.zzb<Quests.AcceptQuestResult> zzb2) {
            this.Sj = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzaq(DataHolder dataHolder) {
            this.Sj.setResult((Object)new AcceptQuestResultImpl(dataHolder));
        }
    }

    private static final class RequestSummariesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Requests.LoadRequestSummariesResult> Ss;

        public RequestSummariesLoadedBinderCallbacks(zzpm.zzb<Requests.LoadRequestSummariesResult> zzb2) {
            this.Ss = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzam(DataHolder dataHolder) {
            this.Ss.setResult((Object)new LoadRequestSummariesResultImpl(dataHolder));
        }
    }

    private static final class RequestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Requests.LoadRequestsResult> St;

        public RequestsLoadedBinderCallbacks(zzpm.zzb<Requests.LoadRequestsResult> zzb2) {
            this.St = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzd(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzpw(n);
            this.St.setResult((Object)new LoadRequestsResultImpl(status, bundle));
        }
    }

    private static final class RequestSentBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Requests.SendRequestResult> Sr;

        public RequestSentBinderCallbacks(zzpm.zzb<Requests.SendRequestResult> zzb2) {
            this.Sr = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzal(DataHolder dataHolder) {
            this.Sr.setResult((Object)new SendRequestResultImpl(dataHolder));
        }
    }

    private static final class RequestsUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Requests.UpdateRequestsResult> Su;

        public RequestsUpdatedBinderCallbacks(zzpm.zzb<Requests.UpdateRequestsResult> zzb2) {
            this.Su = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzak(DataHolder dataHolder) {
            this.Su.setResult((Object)new UpdateRequestsResultImpl(dataHolder));
        }
    }

    private static final class PopupLocationInfoBinderCallbacks
    extends AbstractGamesClient {
        private final PopupManager Re;

        public PopupLocationInfoBinderCallbacks(PopupManager popupManager) {
            this.Re = popupManager;
        }

        @Override
        public PopupLocationInfoParcelable zzbha() {
            return new PopupLocationInfoParcelable(this.Re.zzbit());
        }
    }

    private static final class GetServerAuthCodeBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Games.GetServerAuthCodeResult> zv;

        public GetServerAuthCodeBinderCallbacks(zzpm.zzb<Games.GetServerAuthCodeResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(int n, String string) {
            Status status = GamesStatusCodes.zzpw(n);
            this.zv.setResult((Object)new GetServerAuthCodeResultImpl(status, string));
        }
    }

    private static final class GetAuthTokenBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Games.GetTokenResult> zv;

        public GetAuthTokenBinderCallbacks(zzpm.zzb<Games.GetTokenResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(int n, String string) {
            Status status = GamesStatusCodes.zzpw(n);
            this.zv.setResult((Object)new GetTokenResultImpl(status, string));
        }
    }

    private static final class SignOutCompleteBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Status> zv;

        public SignOutCompleteBinderCallbacks(zzpm.zzb<Status> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbgz() {
            Status status = GamesStatusCodes.zzpw(0);
            this.zv.setResult((Object)status);
        }
    }

    private static final class InboxCountsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Notifications.InboxCountResult> zv;

        InboxCountsLoadedBinderCallback(zzpm.zzb<Notifications.InboxCountResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzg(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzpw(n);
            this.zv.setResult((Object)new InboxCountResultImpl(status, bundle));
        }
    }

    private static final class ContactSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Status> zv;

        ContactSettingsUpdatedBinderCallback(zzpm.zzb<Status> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzqi(int n) {
            this.zv.setResult((Object)GamesStatusCodes.zzpw(n));
        }
    }

    private static final class ContactSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Notifications.ContactSettingLoadResult> zv;

        ContactSettingsLoadedBinderCallback(zzpm.zzb<Notifications.ContactSettingLoadResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzai(DataHolder dataHolder) {
            this.zv.setResult((Object)new ContactSettingLoadResultImpl(dataHolder));
        }
    }

    private static final class GameMuteStatusLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Notifications.GameMuteStatusLoadResult> zv;

        GameMuteStatusLoadedBinderCallback(zzpm.zzb<Notifications.GameMuteStatusLoadResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzag(DataHolder dataHolder) {
            this.zv.setResult((Object)new GameMuteStatusLoadResultImpl(dataHolder));
        }
    }

    private static final class GameMuteStatusChangedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Notifications.GameMuteStatusChangeResult> zv;

        GameMuteStatusChangedBinderCallback(zzpm.zzb<Notifications.GameMuteStatusChangeResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, String string, boolean bl) {
            this.zv.setResult((Object)new GameMuteStatusChangeResultImpl(n, string, bl));
        }
    }

    private static final class RealTimeReliableMessageBinderCallbacks
    extends AbstractGamesCallbacks {
        final zzqn<RealTimeMultiplayer.ReliableMessageSentCallback> Sp;

        public RealTimeReliableMessageBinderCallbacks(zzqn<RealTimeMultiplayer.ReliableMessageSentCallback> zzqn2) {
            this.Sp = zzqn2;
        }

        @Override
        public void zzb(int n, int n2, String string) {
            if (this.Sp != null) {
                this.Sp.zza((zzqn.zzb)new RealTimeMessageSentNotifier(n, n2, string));
            }
        }
    }

    private static final class RoomBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqn<? extends RoomUpdateListener> Sv;
        private final zzqn<? extends RoomStatusUpdateListener> Sw;
        private final zzqn<RealTimeMessageReceivedListener> Sx;

        public RoomBinderCallbacks(zzqn<RoomUpdateListener> zzqn2) {
            this.Sv = (zzqn)zzab.zzb(zzqn2, (Object)"Callbacks must not be null");
            this.Sw = null;
            this.Sx = null;
        }

        public RoomBinderCallbacks(zzqn<? extends RoomUpdateListener> zzqn2, zzqn<? extends RoomStatusUpdateListener> zzqn3, zzqn<RealTimeMessageReceivedListener> zzqn4) {
            this.Sv = (zzqn)zzab.zzb(zzqn2, (Object)"Callbacks must not be null");
            this.Sw = zzqn3;
            this.Sx = zzqn4;
        }

        @Override
        public void zzz(DataHolder dataHolder) {
            this.Sv.zza((zzqn.zzb)new RoomCreatedNotifier(dataHolder));
        }

        @Override
        public void zzaa(DataHolder dataHolder) {
            this.Sv.zza((zzqn.zzb)new JoinedRoomNotifier(dataHolder));
        }

        @Override
        public void onLeftRoom(int n, String string) {
            this.Sv.zza((zzqn.zzb)new LeftRoomNotifier(n, string));
        }

        @Override
        public void zzad(DataHolder dataHolder) {
            this.Sv.zza((zzqn.zzb)new RoomConnectedNotifier(dataHolder));
        }

        @Override
        public void zzab(DataHolder dataHolder) {
            if (this.Sw != null) {
                this.Sw.zza((zzqn.zzb)new RoomConnectingNotifier(dataHolder));
            }
        }

        @Override
        public void zzac(DataHolder dataHolder) {
            if (this.Sw != null) {
                this.Sw.zza((zzqn.zzb)new RoomAutoMatchingNotifier(dataHolder));
            }
        }

        @Override
        public void zzae(DataHolder dataHolder) {
            if (this.Sw != null) {
                this.Sw.zza((zzqn.zzb)new ConnectedToRoomNotifier(dataHolder));
            }
        }

        @Override
        public void zzaf(DataHolder dataHolder) {
            if (this.Sw != null) {
                this.Sw.zza((zzqn.zzb)new DisconnectedFromRoomNotifier(dataHolder));
            }
        }

        @Override
        public void zze(DataHolder dataHolder, String[] stringArray) {
            if (this.Sw != null) {
                this.Sw.zza((zzqn.zzb)new PeerConnectedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzf(DataHolder dataHolder, String[] stringArray) {
            if (this.Sw != null) {
                this.Sw.zza((zzqn.zzb)new PeerDisconnectedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zza(DataHolder dataHolder, String[] stringArray) {
            if (this.Sw != null) {
                this.Sw.zza((zzqn.zzb)new PeerInvitedToRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzb(DataHolder dataHolder, String[] stringArray) {
            if (this.Sw != null) {
                this.Sw.zza((zzqn.zzb)new PeerJoinedRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzc(DataHolder dataHolder, String[] stringArray) {
            if (this.Sw != null) {
                this.Sw.zza((zzqn.zzb)new PeerLeftRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzd(DataHolder dataHolder, String[] stringArray) {
            if (this.Sw != null) {
                this.Sw.zza((zzqn.zzb)new PeerDeclinedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void onP2PConnected(String string) {
            if (this.Sw != null) {
                this.Sw.zza((zzqn.zzb)new P2PConnectedNotifier(string));
            }
        }

        @Override
        public void onP2PDisconnected(String string) {
            if (this.Sw != null) {
                this.Sw.zza((zzqn.zzb)new P2PDisconnectedNotifier(string));
            }
        }

        @Override
        public void onRealTimeMessageReceived(RealTimeMessage realTimeMessage) {
            if (this.Sx != null) {
                this.Sx.zza((zzqn.zzb)new MessageReceivedNotifier(realTimeMessage));
            }
        }
    }

    private static final class TurnBasedMatchCanceledBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<TurnBasedMultiplayer.CancelMatchResult> SD;

        public TurnBasedMatchCanceledBinderCallbacks(zzpm.zzb<TurnBasedMultiplayer.CancelMatchResult> zzb2) {
            this.SD = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzk(int n, String string) {
            Status status = GamesStatusCodes.zzpw(n);
            this.SD.setResult((Object)new CancelMatchResultImpl(status, string));
        }
    }

    private static final class TurnBasedMatchLeftBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<TurnBasedMultiplayer.LeaveMatchResult> SF;

        public TurnBasedMatchLeftBinderCallbacks(zzpm.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2) {
            this.SF = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzx(DataHolder dataHolder) {
            this.SF.setResult((Object)new LeaveMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<TurnBasedMultiplayer.UpdateMatchResult> SH;

        public TurnBasedMatchUpdatedBinderCallbacks(zzpm.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2) {
            this.SH = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzw(DataHolder dataHolder) {
            this.SH.setResult((Object)new UpdateMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchInitiatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<TurnBasedMultiplayer.InitiateMatchResult> SE;

        public TurnBasedMatchInitiatedBinderCallbacks(zzpm.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2) {
            this.SE = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzv(DataHolder dataHolder) {
            this.SE.setResult((Object)new InitiateMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<TurnBasedMultiplayer.LoadMatchResult> SG;

        public TurnBasedMatchLoadedBinderCallbacks(zzpm.zzb<TurnBasedMultiplayer.LoadMatchResult> zzb2) {
            this.SG = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzu(DataHolder dataHolder) {
            this.SG.setResult((Object)new LoadMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<TurnBasedMultiplayer.LoadMatchesResult> SI;

        public TurnBasedMatchesLoadedBinderCallbacks(zzpm.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2) {
            this.SI = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzc(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzpw(n);
            this.SI.setResult((Object)new LoadMatchesResultImpl(status, bundle));
        }
    }

    private static final class SubmitScoreBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Leaderboards.SubmitScoreResult> zv;

        public SubmitScoreBinderCallbacks(zzpm.zzb<Leaderboards.SubmitScoreResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzk(DataHolder dataHolder) {
            this.zv.setResult((Object)new SubmitScoreResultImpl(dataHolder));
        }
    }

    private static final class UpdateProfileDiscoverabilityBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Status> zv;

        UpdateProfileDiscoverabilityBinderCallback(zzpm.zzb<Status> zzb2) {
            this.zv = zzb2;
        }

        @Override
        public void zzqo(int n) {
            this.zv.setResult((Object)new Status(n));
        }
    }

    private static final class UpdateAutoSignInBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Status> zv;

        UpdateAutoSignInBinderCallback(zzpm.zzb<Status> zzb2) {
            this.zv = zzb2;
        }

        @Override
        public void zzqn(int n) {
            this.zv.setResult((Object)new Status(n));
        }
    }

    private static final class DeletePlayerBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Status> zv;

        DeletePlayerBinderCallback(zzpm.zzb<Status> zzb2) {
            this.zv = zzb2;
        }

        @Override
        public void zzqm(int n) {
            this.zv.setResult((Object)new Status(n));
        }
    }

    private static final class GamerProfileUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Players.UpdateGamerProfileResult> zv;

        GamerProfileUpdatedBinderCallback(zzpm.zzb<Players.UpdateGamerProfileResult> zzb2) {
            this.zv = zzb2;
        }

        @Override
        public void zzh(int n, Bundle bundle) {
            this.zv.setResult((Object)new UpdateGamerProfileResultImpl(n, bundle));
        }
    }

    private static final class StockProfileImagesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Players.LoadStockProfileImagesResult> zv;

        StockProfileImagesLoadedBinderCallback(zzpm.zzb<Players.LoadStockProfileImagesResult> zzb2) {
            this.zv = zzb2;
        }

        @Override
        public void zzay(DataHolder dataHolder) {
            this.zv.setResult((Object)new LoadStockProfileImagesResultImpl(dataHolder));
        }
    }

    private static final class ProfileSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Status> zv;

        ProfileSettingsUpdatedBinderCallback(zzpm.zzb<Status> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzqj(int n) {
            this.zv.setResult((Object)GamesStatusCodes.zzpw(n));
        }
    }

    private static final class ProfileSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Players.LoadProfileSettingsResult> zv;

        ProfileSettingsLoadedBinderCallback(zzpm.zzb<Players.LoadProfileSettingsResult> zzb2) {
            this.zv = zzb2;
        }

        @Override
        public void zzav(DataHolder dataHolder) {
            this.zv.setResult((Object)new ProfileSettingsEntity(dataHolder));
            dataHolder.close();
        }
    }

    static final class PlayerXpStreamLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Players.LoadXpStreamResult> zv;

        PlayerXpStreamLoadedBinderCallback(zzpm.zzb<Players.LoadXpStreamResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzau(DataHolder dataHolder) {
            this.zv.setResult((Object)new LoadXpStreamResultImpl(dataHolder));
        }
    }

    private static final class PlayerXpForGameCategoriesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Players.LoadXpForGameCategoriesResult> zv;

        PlayerXpForGameCategoriesLoadedBinderCallback(zzpm.zzb<Players.LoadXpForGameCategoriesResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzf(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzpw(n);
            this.zv.setResult((Object)new LoadXpForGameCategoriesResultImpl(status, bundle));
        }
    }

    private static final class InvitesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Social.LoadInvitesResult> zv;

        InvitesLoadedBinderCallback(zzpm.zzb<Social.LoadInvitesResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbh(DataHolder dataHolder) {
            this.zv.setResult((Object)new LoadInvitesResultImpl(dataHolder));
        }
    }

    private static final class PlayersLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Players.LoadPlayersResult> zv;

        PlayersLoadedBinderCallback(zzpm.zzb<Players.LoadPlayersResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzl(DataHolder dataHolder) {
            this.zv.setResult((Object)new LoadPlayersResultImpl(dataHolder));
        }

        @Override
        public void zzm(DataHolder dataHolder) {
            this.zv.setResult((Object)new LoadPlayersResultImpl(dataHolder));
        }
    }

    private static final class SocialInviteUpdateReceivedBinderCallback
    extends AbstractGamesCallbacks {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzbb(DataHolder dataHolder) {
            SocialInviteBuffer socialInviteBuffer = new SocialInviteBuffer(dataHolder);
            SocialInvite socialInvite = null;
            try {
                if (socialInviteBuffer.getCount() > 0) {
                    socialInvite = (SocialInvite)((SocialInvite)socialInviteBuffer.get(0)).freeze();
                }
            }
            finally {
                socialInviteBuffer.release();
            }
            if (socialInvite != null) {
                null.zza((zzqn.zzb)new SocialInviteUpdateReceivedNotifier(socialInvite));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzbc(DataHolder dataHolder) {
            SocialInviteBuffer socialInviteBuffer = new SocialInviteBuffer(dataHolder);
            SocialInvite socialInvite = null;
            try {
                if (socialInviteBuffer.getCount() > 0) {
                    socialInvite = (SocialInvite)((SocialInvite)socialInviteBuffer.get(0)).freeze();
                }
            }
            finally {
                socialInviteBuffer.release();
            }
            if (socialInvite != null) {
                null.zza((zzqn.zzb)new SocialInviteRemovedNotifier(socialInvite));
            }
        }
    }

    private static final class RequestReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqn<OnRequestReceivedListener> Gc;

        RequestReceivedBinderCallback(zzqn<OnRequestReceivedListener> zzqn2) {
            this.Gc = zzqn2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzt(DataHolder dataHolder) {
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            GameRequest gameRequest = null;
            try {
                if (gameRequestBuffer.getCount() > 0) {
                    gameRequest = (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze();
                }
            }
            finally {
                gameRequestBuffer.release();
            }
            if (gameRequest != null) {
                this.Gc.zza((zzqn.zzb)new RequestReceivedNotifier(gameRequest));
            }
        }

        @Override
        public void onRequestRemoved(String string) {
            this.Gc.zza((zzqn.zzb)new RequestRemovedNotifier(string));
        }
    }

    private static final class QuestUpdateBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqn<QuestUpdateListener> Gc;

        QuestUpdateBinderCallback(zzqn<QuestUpdateListener> zzqn2) {
            this.Gc = zzqn2;
        }

        @Override
        public void zzar(DataHolder dataHolder) {
            Quest quest = this.zzbk(dataHolder);
            if (quest != null) {
                this.Gc.zza((zzqn.zzb)new QuestCompletedNotifier(quest));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Quest zzbk(DataHolder dataHolder) {
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            Quest quest = null;
            try {
                if (questBuffer.getCount() > 0) {
                    quest = (Quest)((Quest)questBuffer.get(0)).freeze();
                }
            }
            finally {
                questBuffer.release();
            }
            return quest;
        }
    }

    private static final class MatchUpdateReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqn<OnTurnBasedMatchUpdateReceivedListener> Gc;

        MatchUpdateReceivedBinderCallback(zzqn<OnTurnBasedMatchUpdateReceivedListener> zzqn2) {
            this.Gc = zzqn2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzy(DataHolder dataHolder) {
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            TurnBasedMatch turnBasedMatch = null;
            try {
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
            }
            finally {
                turnBasedMatchBuffer.release();
            }
            if (turnBasedMatch != null) {
                this.Gc.zza((zzqn.zzb)new MatchUpdateReceivedNotifier(turnBasedMatch));
            }
        }

        @Override
        public void onTurnBasedMatchRemoved(String string) {
            this.Gc.zza((zzqn.zzb)new MatchRemovedNotifier(string));
        }
    }

    private static final class InvitationReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqn<OnInvitationReceivedListener> Gc;

        InvitationReceivedBinderCallback(zzqn<OnInvitationReceivedListener> zzqn2) {
            this.Gc = zzqn2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzs(DataHolder dataHolder) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            finally {
                invitationBuffer.release();
            }
            if (invitation != null) {
                this.Gc.zza((zzqn.zzb)new InvitationReceivedNotifier(invitation));
            }
        }

        @Override
        public void onInvitationRemoved(String string) {
            this.Gc.zza((zzqn.zzb)new InvitationRemovedNotifier(string));
        }
    }

    private static final class InvitationsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Invitations.LoadInvitationsResult> zv;

        InvitationsLoadedBinderCallback(zzpm.zzb<Invitations.LoadInvitationsResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzr(DataHolder dataHolder) {
            this.zv.setResult((Object)new LoadInvitationsResultImpl(dataHolder));
        }
    }

    private static final class PlayerLeaderboardScoreLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Leaderboards.LoadPlayerScoreResult> zv;

        PlayerLeaderboardScoreLoadedBinderCallback(zzpm.zzb<Leaderboards.LoadPlayerScoreResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzaj(DataHolder dataHolder) {
            this.zv.setResult((Object)new LoadPlayerScoreResultImpl(dataHolder));
        }
    }

    private static final class LeaderboardScoresLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Leaderboards.LoadScoresResult> zv;

        LeaderboardScoresLoadedBinderCallback(zzpm.zzb<Leaderboards.LoadScoresResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder dataHolder, DataHolder dataHolder2) {
            this.zv.setResult((Object)new LoadScoresResultImpl(dataHolder, dataHolder2));
        }
    }

    private static final class LeaderboardsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Leaderboards.LeaderboardMetadataResult> zv;

        LeaderboardsLoadedBinderCallback(zzpm.zzb<Leaderboards.LeaderboardMetadataResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzj(DataHolder dataHolder) {
            this.zv.setResult((Object)new LeaderboardMetadataResultImpl(dataHolder));
        }
    }

    private static final class GameSearchSuggestionsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zv;

        GameSearchSuggestionsLoadedBinderCallback(zzpm.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzq(DataHolder dataHolder) {
            this.zv.setResult((Object)new LoadGameSearchSuggestionsResultImpl(dataHolder));
        }
    }

    private static final class GameInstancesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<GamesMetadata.LoadGameInstancesResult> zv;

        GameInstancesLoadedBinderCallback(zzpm.zzb<GamesMetadata.LoadGameInstancesResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzp(DataHolder dataHolder) {
            this.zv.setResult((Object)new LoadGameInstancesResultImpl(dataHolder));
        }
    }

    private static final class EventsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Events.LoadEventsResult> zv;

        EventsLoadedBinderCallback(zzpm.zzb<Events.LoadEventsResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(DataHolder dataHolder) {
            this.zv.setResult((Object)new LoadEventResultImpl(dataHolder));
        }
    }

    private static final class GamesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<GamesMetadata.LoadGamesResult> zv;

        GamesLoadedBinderCallback(zzpm.zzb<GamesMetadata.LoadGamesResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzn(DataHolder dataHolder) {
            this.zv.setResult((Object)new LoadGamesResultImpl(dataHolder));
        }
    }

    private static final class AchievementUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Achievements.UpdateAchievementResult> zv;

        AchievementUpdatedBinderCallback(zzpm.zzb<Achievements.UpdateAchievementResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzj(int n, String string) {
            this.zv.setResult((Object)new UpdateAchievementResultImpl(n, string));
        }
    }

    private static final class AchievementsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpm.zzb<Achievements.LoadAchievementsResult> zv;

        AchievementsLoadedBinderCallback(zzpm.zzb<Achievements.LoadAchievementsResult> zzb2) {
            this.zv = (zzpm.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzh(DataHolder dataHolder) {
            this.zv.setResult((Object)new LoadAchievementsResultImpl(dataHolder));
        }
    }

    private class GameClientEventIncrementCache
    extends EventIncrementCache {
        public GameClientEventIncrementCache() {
            super(GamesClientImpl.this.getContext().getMainLooper(), 1000);
        }

        @Override
        protected void zzq(String string, int n) {
            try {
                if (GamesClientImpl.this.isConnected()) {
                    ((IGamesService)GamesClientImpl.this.zzasa()).zzn(string, n);
                } else {
                    GamesLog.zzag("GamesClientImpl", new StringBuilder(89 + String.valueOf(string).length()).append("Unable to increment event ").append(string).append(" by ").append(n).append(" because the games client is no longer connected").toString());
                }
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.this.zzb(remoteException);
            }
        }
    }
}

