/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.player;

import android.net.Uri;
import android.os.Parcel;
import android.text.TextUtils;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.internal.player.ProfileSettingsEntityCreator;
import com.google.android.gms.games.internal.player.StockProfileImage;
import com.google.android.gms.games.internal.player.StockProfileImageEntity;

public class ProfileSettingsEntity
extends AbstractSafeParcelable
implements Players.LoadProfileSettingsResult {
    public static final ProfileSettingsEntityCreator CREATOR = new ProfileSettingsEntityCreator();
    private final int mVersionCode;
    private final Status bY;
    private final String PX;
    private final boolean Wd;
    private final boolean PV;
    private final boolean We;
    private final StockProfileImageEntity Wf;
    private final boolean Wg;
    private final boolean Wh;

    public ProfileSettingsEntity(DataHolder dataHolder) {
        this.mVersionCode = 3;
        this.bY = new Status(dataHolder.getStatusCode());
        if (this.bY.isSuccess() && dataHolder.getCount() > 0) {
            int n = dataHolder.zzfs(0);
            this.PX = dataHolder.zzd("gamer_tag", 0, n);
            this.Wd = dataHolder.zze("gamer_tag_explicitly_set", 0, n);
            this.PV = dataHolder.zze("profile_visible", 0, n);
            this.We = dataHolder.zze("profile_visibility_explicitly_set", 0, n);
            String string = dataHolder.zzd("stock_avatar_url", 0, n);
            String string2 = dataHolder.zzd("stock_avatar_uri", 0, n);
            this.Wf = !TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2) ? new StockProfileImageEntity(string, Uri.parse((String)string2)) : null;
            this.Wg = dataHolder.zze("profile_discoverable", 0, n);
            this.Wh = dataHolder.zze("auto_sign_in", 0, n);
        } else {
            this.PX = null;
            this.Wd = false;
            this.PV = false;
            this.We = false;
            this.Wf = null;
            this.Wg = false;
            this.Wh = false;
        }
    }

    ProfileSettingsEntity(int n, Status status, String string, boolean bl, boolean bl2, boolean bl3, StockProfileImageEntity stockProfileImageEntity, boolean bl4, boolean bl5) {
        this.mVersionCode = n;
        this.bY = status;
        this.PX = string;
        this.Wd = bl;
        this.PV = bl2;
        this.We = bl3;
        this.Wf = stockProfileImageEntity;
        this.Wg = bl4;
        this.Wh = bl5;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String zzbff() {
        return this.PX;
    }

    @Override
    public boolean zzbfp() {
        return this.Wd;
    }

    @Override
    public boolean zzbfi() {
        return this.PV;
    }

    @Override
    public boolean zzbfn() {
        return this.We;
    }

    @Override
    public StockProfileImage zzbfo() {
        return this.Wf;
    }

    @Override
    public boolean zzbfq() {
        return this.Wg;
    }

    @Override
    public boolean zzbfr() {
        return this.Wh;
    }

    public Status getStatus() {
        return this.bY;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.PX, this.Wd, this.PV, this.We, this.bY, this.Wf, this.Wg, this.Wh});
    }

    public boolean equals(Object object) {
        if (!(object instanceof Players.LoadProfileSettingsResult)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Players.LoadProfileSettingsResult loadProfileSettingsResult = (Players.LoadProfileSettingsResult)object;
        return zzaa.equal((Object)this.PX, (Object)loadProfileSettingsResult.zzbff()) && zzaa.equal((Object)this.Wd, (Object)loadProfileSettingsResult.zzbfp()) && zzaa.equal((Object)this.PV, (Object)loadProfileSettingsResult.zzbfi()) && zzaa.equal((Object)this.We, (Object)loadProfileSettingsResult.zzbfn()) && zzaa.equal((Object)this.bY, (Object)loadProfileSettingsResult.getStatus()) && zzaa.equal((Object)this.Wf, (Object)loadProfileSettingsResult.zzbfo()) && zzaa.equal((Object)this.Wg, (Object)loadProfileSettingsResult.zzbfq()) && zzaa.equal((Object)this.Wh, (Object)loadProfileSettingsResult.zzbfr());
    }

    public String toString() {
        return zzaa.zzx((Object)this).zzg("GamerTag", (Object)this.PX).zzg("IsGamerTagExplicitlySet", (Object)this.Wd).zzg("IsProfileVisible", (Object)this.PV).zzg("IsVisibilityExplicitlySet", (Object)this.We).zzg("Status", (Object)this.bY).zzg("StockProfileImage", (Object)this.Wf).zzg("IsProfileDiscoverable", (Object)this.Wg).zzg("AutoSignIn", (Object)this.Wh).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        ProfileSettingsEntityCreator.zza(this, parcel, n);
    }
}

