/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchEntityCreator;
import java.util.ArrayList;

public final class TurnBasedMatchEntity
extends AbstractSafeParcelable
implements TurnBasedMatch {
    public static final Parcelable.Creator<TurnBasedMatchEntity> CREATOR = new TurnBasedMatchEntityCreator();
    private final int mVersionCode;
    private final GameEntity Vh;
    private final String Sa;
    private final String Xn;
    private final long WR;
    private final String Xv;
    private final long Qx;
    private final String Xw;
    private final int Xx;
    private final int WV;
    private final int mVersion;
    private final byte[] Xy;
    private final ArrayList<ParticipantEntity> WU;
    private final String Xz;
    private final byte[] XA;
    private final int XB;
    private final Bundle Xl;
    private final int XC;
    private final boolean XD;
    private final String zzcvf;
    private final String XE;

    public TurnBasedMatchEntity(TurnBasedMatch turnBasedMatch) {
        this.mVersionCode = 2;
        this.Vh = new GameEntity(turnBasedMatch.getGame());
        this.Sa = turnBasedMatch.getMatchId();
        this.Xn = turnBasedMatch.getCreatorId();
        this.WR = turnBasedMatch.getCreationTimestamp();
        this.Xv = turnBasedMatch.getLastUpdaterId();
        this.Qx = turnBasedMatch.getLastUpdatedTimestamp();
        this.Xw = turnBasedMatch.getPendingParticipantId();
        this.Xx = turnBasedMatch.getStatus();
        this.XC = turnBasedMatch.getTurnStatus();
        this.WV = turnBasedMatch.getVariant();
        this.mVersion = turnBasedMatch.getVersion();
        this.Xz = turnBasedMatch.getRematchId();
        this.XB = turnBasedMatch.getMatchNumber();
        this.Xl = turnBasedMatch.getAutoMatchCriteria();
        this.XD = turnBasedMatch.isLocallyModified();
        this.zzcvf = turnBasedMatch.getDescription();
        this.XE = turnBasedMatch.getDescriptionParticipantId();
        byte[] byArray = turnBasedMatch.getData();
        if (byArray == null) {
            this.Xy = null;
        } else {
            this.Xy = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.Xy, 0, byArray.length);
        }
        byte[] byArray2 = turnBasedMatch.getPreviousMatchData();
        if (byArray2 == null) {
            this.XA = null;
        } else {
            this.XA = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.XA, 0, byArray2.length);
        }
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        this.WU = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.WU.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
    }

    TurnBasedMatchEntity(int n, GameEntity gameEntity, String string, String string2, long l, String string3, long l2, String string4, int n2, int n3, int n4, byte[] byArray, ArrayList<ParticipantEntity> arrayList, String string5, byte[] byArray2, int n5, Bundle bundle, int n6, boolean bl, String string6, String string7) {
        this.mVersionCode = n;
        this.Vh = gameEntity;
        this.Sa = string;
        this.Xn = string2;
        this.WR = l;
        this.Xv = string3;
        this.Qx = l2;
        this.Xw = string4;
        this.Xx = n2;
        this.XC = n6;
        this.WV = n3;
        this.mVersion = n4;
        this.Xy = byArray;
        this.WU = arrayList;
        this.Xz = string5;
        this.XA = byArray2;
        this.XB = n5;
        this.Xl = bundle;
        this.XD = bl;
        this.zzcvf = string6;
        this.XE = string7;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public Game getGame() {
        return this.Vh;
    }

    @Override
    public String getMatchId() {
        return this.Sa;
    }

    @Override
    public String getCreatorId() {
        return this.Xn;
    }

    @Override
    public long getCreationTimestamp() {
        return this.WR;
    }

    @Override
    public String getLastUpdaterId() {
        return this.Xv;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.Qx;
    }

    @Override
    public String getPendingParticipantId() {
        return this.Xw;
    }

    @Override
    public int getStatus() {
        return this.Xx;
    }

    @Override
    public int getTurnStatus() {
        return this.XC;
    }

    @Override
    public String getDescription() {
        return this.zzcvf;
    }

    @Override
    public String getDescriptionParticipantId() {
        return this.XE;
    }

    @Override
    public Participant getDescriptionParticipant() {
        String string = this.getDescriptionParticipantId();
        if (string == null) {
            return null;
        }
        return this.getParticipant(string);
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzcvf, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public int getVariant() {
        return this.WV;
    }

    @Override
    public byte[] getData() {
        return this.Xy;
    }

    @Override
    public int getVersion() {
        return this.mVersion;
    }

    @Override
    public String getRematchId() {
        return this.Xz;
    }

    @Override
    public byte[] getPreviousMatchData() {
        return this.XA;
    }

    @Override
    public int getMatchNumber() {
        return this.XB;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.Xl;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        if (this.Xl == null) {
            return 0;
        }
        return this.Xl.getInt("max_automatch_players");
    }

    @Override
    public boolean canRematch() {
        return this.Xx == 2 && this.Xz == null;
    }

    @Override
    public boolean isLocallyModified() {
        return this.XD;
    }

    @Override
    public int getParticipantStatus(String string) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, string);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.zzc(this);
    }

    @Override
    public String getParticipantId(String string) {
        return TurnBasedMatchEntity.zzb(this, string);
    }

    @Override
    public Participant getParticipant(String string) {
        return TurnBasedMatchEntity.zzc(this, string);
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.WU);
    }

    public TurnBasedMatch freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return TurnBasedMatchEntity.zza(this);
    }

    static int zza(TurnBasedMatch turnBasedMatch) {
        return zzaa.hashCode((Object[])new Object[]{turnBasedMatch.getGame(), turnBasedMatch.getMatchId(), turnBasedMatch.getCreatorId(), turnBasedMatch.getCreationTimestamp(), turnBasedMatch.getLastUpdaterId(), turnBasedMatch.getLastUpdatedTimestamp(), turnBasedMatch.getPendingParticipantId(), turnBasedMatch.getStatus(), turnBasedMatch.getTurnStatus(), turnBasedMatch.getDescription(), turnBasedMatch.getVariant(), turnBasedMatch.getVersion(), turnBasedMatch.getParticipants(), turnBasedMatch.getRematchId(), turnBasedMatch.getMatchNumber(), turnBasedMatch.getAutoMatchCriteria(), turnBasedMatch.getAvailableAutoMatchSlots(), turnBasedMatch.isLocallyModified()});
    }

    public boolean equals(Object object) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, object);
    }

    static boolean zza(TurnBasedMatch turnBasedMatch, Object object) {
        if (!(object instanceof TurnBasedMatch)) {
            return false;
        }
        if (turnBasedMatch == object) {
            return true;
        }
        TurnBasedMatch turnBasedMatch2 = (TurnBasedMatch)object;
        return zzaa.equal((Object)turnBasedMatch2.getGame(), (Object)turnBasedMatch.getGame()) && zzaa.equal((Object)turnBasedMatch2.getMatchId(), (Object)turnBasedMatch.getMatchId()) && zzaa.equal((Object)turnBasedMatch2.getCreatorId(), (Object)turnBasedMatch.getCreatorId()) && zzaa.equal((Object)turnBasedMatch2.getCreationTimestamp(), (Object)turnBasedMatch.getCreationTimestamp()) && zzaa.equal((Object)turnBasedMatch2.getLastUpdaterId(), (Object)turnBasedMatch.getLastUpdaterId()) && zzaa.equal((Object)turnBasedMatch2.getLastUpdatedTimestamp(), (Object)turnBasedMatch.getLastUpdatedTimestamp()) && zzaa.equal((Object)turnBasedMatch2.getPendingParticipantId(), (Object)turnBasedMatch.getPendingParticipantId()) && zzaa.equal((Object)turnBasedMatch2.getStatus(), (Object)turnBasedMatch.getStatus()) && zzaa.equal((Object)turnBasedMatch2.getTurnStatus(), (Object)turnBasedMatch.getTurnStatus()) && zzaa.equal((Object)turnBasedMatch2.getDescription(), (Object)turnBasedMatch.getDescription()) && zzaa.equal((Object)turnBasedMatch2.getVariant(), (Object)turnBasedMatch.getVariant()) && zzaa.equal((Object)turnBasedMatch2.getVersion(), (Object)turnBasedMatch.getVersion()) && zzaa.equal((Object)turnBasedMatch2.getParticipants(), (Object)turnBasedMatch.getParticipants()) && zzaa.equal((Object)turnBasedMatch2.getRematchId(), (Object)turnBasedMatch.getRematchId()) && zzaa.equal((Object)turnBasedMatch2.getMatchNumber(), (Object)turnBasedMatch.getMatchNumber()) && zzaa.equal((Object)turnBasedMatch2.getAutoMatchCriteria(), (Object)turnBasedMatch.getAutoMatchCriteria()) && zzaa.equal((Object)turnBasedMatch2.getAvailableAutoMatchSlots(), (Object)turnBasedMatch.getAvailableAutoMatchSlots()) && zzaa.equal((Object)turnBasedMatch2.isLocallyModified(), (Object)turnBasedMatch.isLocallyModified());
    }

    public String toString() {
        return TurnBasedMatchEntity.zzb(this);
    }

    static String zzb(TurnBasedMatch turnBasedMatch) {
        return zzaa.zzx((Object)turnBasedMatch).zzg("Game", (Object)turnBasedMatch.getGame()).zzg("MatchId", (Object)turnBasedMatch.getMatchId()).zzg("CreatorId", (Object)turnBasedMatch.getCreatorId()).zzg("CreationTimestamp", (Object)turnBasedMatch.getCreationTimestamp()).zzg("LastUpdaterId", (Object)turnBasedMatch.getLastUpdaterId()).zzg("LastUpdatedTimestamp", (Object)turnBasedMatch.getLastUpdatedTimestamp()).zzg("PendingParticipantId", (Object)turnBasedMatch.getPendingParticipantId()).zzg("MatchStatus", (Object)turnBasedMatch.getStatus()).zzg("TurnStatus", (Object)turnBasedMatch.getTurnStatus()).zzg("Description", (Object)turnBasedMatch.getDescription()).zzg("Variant", (Object)turnBasedMatch.getVariant()).zzg("Data", (Object)turnBasedMatch.getData()).zzg("Version", (Object)turnBasedMatch.getVersion()).zzg("Participants", (Object)turnBasedMatch.getParticipants()).zzg("RematchId", (Object)turnBasedMatch.getRematchId()).zzg("PreviousData", (Object)turnBasedMatch.getPreviousMatchData()).zzg("MatchNumber", (Object)turnBasedMatch.getMatchNumber()).zzg("AutoMatchCriteria", (Object)turnBasedMatch.getAutoMatchCriteria()).zzg("AvailableAutoMatchSlots", (Object)turnBasedMatch.getAvailableAutoMatchSlots()).zzg("LocallyModified", (Object)turnBasedMatch.isLocallyModified()).zzg("DescriptionParticipantId", (Object)turnBasedMatch.getDescriptionParticipantId()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        TurnBasedMatchEntityCreator.zza(this, parcel, n);
    }

    static int zza(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        String string2 = String.valueOf(turnBasedMatch.getMatchId());
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in match ").append(string2).toString());
    }

    static ArrayList<String> zzc(TurnBasedMatch turnBasedMatch) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String zzb(TurnBasedMatch turnBasedMatch, String string) {
        String string2 = null;
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant zzc(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        String string2 = String.valueOf(turnBasedMatch.getMatchId());
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in match ").append(string2).toString());
    }
}

