/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestEntityCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class GameRequestEntity
extends AbstractSafeParcelable
implements GameRequest {
    public static final Parcelable.Creator<GameRequestEntity> CREATOR = new GameRequestEntityCreator();
    private final int mVersionCode;
    private final GameEntity Vh;
    private final PlayerEntity XR;
    private final byte[] Xy;
    private final String zzbvq;
    private final ArrayList<PlayerEntity> XS;
    private final int iq;
    private final long WR;
    private final long XT;
    private final Bundle XU;
    private final int zzblv;

    public GameRequestEntity(GameRequest gameRequest) {
        this.mVersionCode = 2;
        this.Vh = new GameEntity(gameRequest.getGame());
        this.XR = new PlayerEntity(gameRequest.getSender());
        this.zzbvq = gameRequest.getRequestId();
        this.iq = gameRequest.getType();
        this.WR = gameRequest.getCreationTimestamp();
        this.XT = gameRequest.getExpirationTimestamp();
        this.zzblv = gameRequest.getStatus();
        byte[] byArray = gameRequest.getData();
        if (byArray == null) {
            this.Xy = null;
        } else {
            this.Xy = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.Xy, 0, byArray.length);
        }
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        this.XS = new ArrayList(n);
        this.XU = new Bundle();
        for (int i = 0; i < n; ++i) {
            Player player = (Player)list.get(i).freeze();
            String string = player.getPlayerId();
            this.XS.add((PlayerEntity)player);
            this.XU.putInt(string, gameRequest.getRecipientStatus(string));
        }
    }

    GameRequestEntity(int n, GameEntity gameEntity, PlayerEntity playerEntity, byte[] byArray, String string, ArrayList<PlayerEntity> arrayList, int n2, long l, long l2, Bundle bundle, int n3) {
        this.mVersionCode = n;
        this.Vh = gameEntity;
        this.XR = playerEntity;
        this.Xy = byArray;
        this.zzbvq = string;
        this.XS = arrayList;
        this.iq = n2;
        this.WR = l;
        this.XT = l2;
        this.XU = bundle;
        this.zzblv = n3;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getRequestId() {
        return this.zzbvq;
    }

    @Override
    public Game getGame() {
        return this.Vh;
    }

    @Override
    public Player getSender() {
        return this.XR;
    }

    @Override
    public List<Player> getRecipients() {
        return new ArrayList<Player>(this.XS);
    }

    @Override
    public boolean isConsumed(String string) {
        return this.getRecipientStatus(string) == 1;
    }

    @Override
    public byte[] getData() {
        return this.Xy;
    }

    @Override
    public int getType() {
        return this.iq;
    }

    @Override
    public long getCreationTimestamp() {
        return this.WR;
    }

    @Override
    public long getExpirationTimestamp() {
        return this.XT;
    }

    @Override
    public int getRecipientStatus(String string) {
        return this.XU.getInt(string, 0);
    }

    @Override
    public int getStatus() {
        return this.zzblv;
    }

    public Bundle zzbkm() {
        return this.XU;
    }

    public GameRequest freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameRequestEntity.zza(this);
    }

    static int zza(GameRequest gameRequest) {
        return zzaa.hashCode((Object[])new Object[]{gameRequest.getGame(), gameRequest.getRecipients(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.zzb(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp()});
    }

    public boolean equals(Object object) {
        return GameRequestEntity.zza(this, object);
    }

    static boolean zza(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return zzaa.equal((Object)gameRequest2.getGame(), (Object)gameRequest.getGame()) && zzaa.equal(gameRequest2.getRecipients(), gameRequest.getRecipients()) && zzaa.equal((Object)gameRequest2.getRequestId(), (Object)gameRequest.getRequestId()) && zzaa.equal((Object)gameRequest2.getSender(), (Object)gameRequest.getSender()) && Arrays.equals(GameRequestEntity.zzb(gameRequest2), GameRequestEntity.zzb(gameRequest)) && zzaa.equal((Object)gameRequest2.getType(), (Object)gameRequest.getType()) && zzaa.equal((Object)gameRequest2.getCreationTimestamp(), (Object)gameRequest.getCreationTimestamp()) && zzaa.equal((Object)gameRequest2.getExpirationTimestamp(), (Object)gameRequest.getExpirationTimestamp());
    }

    private static int[] zzb(GameRequest gameRequest) {
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = gameRequest.getRecipientStatus(list.get(i).getPlayerId());
        }
        return nArray;
    }

    public String toString() {
        return GameRequestEntity.zzc(this);
    }

    static String zzc(GameRequest gameRequest) {
        return zzaa.zzx((Object)gameRequest).zzg("Game", (Object)gameRequest.getGame()).zzg("Sender", (Object)gameRequest.getSender()).zzg("Recipients", gameRequest.getRecipients()).zzg("Data", (Object)gameRequest.getData()).zzg("RequestId", (Object)gameRequest.getRequestId()).zzg("Type", (Object)gameRequest.getType()).zzg("CreationTimestamp", (Object)gameRequest.getCreationTimestamp()).zzg("ExpirationTimestamp", (Object)gameRequest.getExpirationTimestamp()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        GameRequestEntityCreator.zza(this, parcel, n);
    }
}

