/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.graphics.Bitmap;
import android.net.Uri;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeEntity;

public interface SnapshotMetadataChange {
    public static final SnapshotMetadataChange EMPTY_CHANGE = new SnapshotMetadataChangeEntity();

    public String getDescription();

    public Long getPlayedTimeMillis();

    public BitmapTeleporter zzbkn();

    public Bitmap getCoverImage();

    public Long getProgressValue();

    public static final class Builder {
        private String zzcvf;
        private Long XY;
        private Long XZ;
        private BitmapTeleporter Ya;
        private Uri Yb;

        public Builder setDescription(String string) {
            this.zzcvf = string;
            return this;
        }

        public Builder setPlayedTimeMillis(long l) {
            this.XY = l;
            return this;
        }

        public Builder setProgressValue(long l) {
            this.XZ = l;
            return this;
        }

        public Builder setCoverImage(Bitmap bitmap) {
            this.Ya = new BitmapTeleporter(bitmap);
            this.Yb = null;
            return this;
        }

        public Builder fromMetadata(SnapshotMetadata snapshotMetadata) {
            this.zzcvf = snapshotMetadata.getDescription();
            this.XY = snapshotMetadata.getPlayedTime();
            this.XZ = snapshotMetadata.getProgressValue();
            if (this.XY == -1L) {
                this.XY = null;
            }
            this.Yb = snapshotMetadata.getCoverImageUri();
            if (this.Yb != null) {
                this.Ya = null;
            }
            return this;
        }

        public SnapshotMetadataChange build() {
            return new SnapshotMetadataChangeEntity(this.zzcvf, this.XY, this.Ya, this.Yb, this.XZ);
        }
    }
}

