/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.stats;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.games.stats.PlayerStats;
import com.google.android.gms.games.stats.PlayerStatsEntityCreator;

public class PlayerStatsEntity
extends AbstractSafeParcelable
implements PlayerStats {
    public static final Parcelable.Creator<PlayerStatsEntity> CREATOR = new PlayerStatsEntityCreator();
    private final int mVersionCode;
    private final float Yr;
    private final float Ys;
    private final int Yt;
    private final int Yu;
    private final int Yv;
    private final float Yw;
    private final float Yx;
    private final Bundle Yy;
    private final float Yz;
    private final float YA;
    private final float YB;

    public PlayerStatsEntity(PlayerStats playerStats) {
        this.mVersionCode = 4;
        this.Yr = playerStats.getAverageSessionLength();
        this.Ys = playerStats.getChurnProbability();
        this.Yt = playerStats.getDaysSinceLastPlayed();
        this.Yu = playerStats.getNumberOfPurchases();
        this.Yv = playerStats.getNumberOfSessions();
        this.Yw = playerStats.getSessionPercentile();
        this.Yx = playerStats.getSpendPercentile();
        this.Yz = playerStats.getSpendProbability();
        this.YA = playerStats.getHighSpenderProbability();
        this.YB = playerStats.getTotalSpendNext28Days();
        this.Yy = playerStats.zzbkq();
    }

    PlayerStatsEntity(int n, float f, float f2, int n2, int n3, int n4, float f3, float f4, Bundle bundle, float f5, float f6, float f7) {
        this.mVersionCode = n;
        this.Yr = f;
        this.Ys = f2;
        this.Yt = n2;
        this.Yu = n3;
        this.Yv = n4;
        this.Yw = f3;
        this.Yx = f4;
        this.Yy = bundle;
        this.Yz = f5;
        this.YA = f6;
        this.YB = f7;
    }

    @Override
    public float getAverageSessionLength() {
        return this.Yr;
    }

    @Override
    public float getChurnProbability() {
        return this.Ys;
    }

    @Override
    public int getDaysSinceLastPlayed() {
        return this.Yt;
    }

    @Override
    public int getNumberOfPurchases() {
        return this.Yu;
    }

    @Override
    public int getNumberOfSessions() {
        return this.Yv;
    }

    @Override
    public float getSessionPercentile() {
        return this.Yw;
    }

    @Override
    public float getSpendPercentile() {
        return this.Yx;
    }

    @Override
    public Bundle zzbkq() {
        return this.Yy;
    }

    @Override
    public float getSpendProbability() {
        return this.Yz;
    }

    @Override
    public float getHighSpenderProbability() {
        return this.YA;
    }

    @Override
    public float getTotalSpendNext28Days() {
        return this.YB;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public PlayerStats zzbkr() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerStatsEntity.zza(this);
    }

    static int zza(PlayerStats playerStats) {
        return zzaa.hashCode((Object[])new Object[]{Float.valueOf(playerStats.getAverageSessionLength()), Float.valueOf(playerStats.getChurnProbability()), playerStats.getDaysSinceLastPlayed(), playerStats.getNumberOfPurchases(), playerStats.getNumberOfSessions(), Float.valueOf(playerStats.getSessionPercentile()), Float.valueOf(playerStats.getSpendPercentile()), Float.valueOf(playerStats.getSpendProbability()), Float.valueOf(playerStats.getHighSpenderProbability()), Float.valueOf(playerStats.getTotalSpendNext28Days())});
    }

    public boolean equals(Object object) {
        return PlayerStatsEntity.zza(this, object);
    }

    static boolean zza(PlayerStats playerStats, Object object) {
        if (!(object instanceof PlayerStats)) {
            return false;
        }
        if (playerStats == object) {
            return true;
        }
        PlayerStats playerStats2 = (PlayerStats)object;
        return zzaa.equal((Object)Float.valueOf(playerStats2.getAverageSessionLength()), (Object)Float.valueOf(playerStats.getAverageSessionLength())) && zzaa.equal((Object)Float.valueOf(playerStats2.getChurnProbability()), (Object)Float.valueOf(playerStats.getChurnProbability())) && zzaa.equal((Object)playerStats2.getDaysSinceLastPlayed(), (Object)playerStats.getDaysSinceLastPlayed()) && zzaa.equal((Object)playerStats2.getNumberOfPurchases(), (Object)playerStats.getNumberOfPurchases()) && zzaa.equal((Object)playerStats2.getNumberOfSessions(), (Object)playerStats.getNumberOfSessions()) && zzaa.equal((Object)Float.valueOf(playerStats2.getSessionPercentile()), (Object)Float.valueOf(playerStats.getSessionPercentile())) && zzaa.equal((Object)Float.valueOf(playerStats2.getSpendPercentile()), (Object)Float.valueOf(playerStats.getSpendPercentile())) && zzaa.equal((Object)Float.valueOf(playerStats2.getSpendProbability()), (Object)Float.valueOf(playerStats.getSpendProbability())) && zzaa.equal((Object)Float.valueOf(playerStats2.getHighSpenderProbability()), (Object)Float.valueOf(playerStats.getHighSpenderProbability())) && zzaa.equal((Object)Float.valueOf(playerStats2.getTotalSpendNext28Days()), (Object)Float.valueOf(playerStats.getTotalSpendNext28Days()));
    }

    public String toString() {
        return PlayerStatsEntity.zzb(this);
    }

    static String zzb(PlayerStats playerStats) {
        return zzaa.zzx((Object)playerStats).zzg("AverageSessionLength", (Object)Float.valueOf(playerStats.getAverageSessionLength())).zzg("ChurnProbability", (Object)Float.valueOf(playerStats.getChurnProbability())).zzg("DaysSinceLastPlayed", (Object)playerStats.getDaysSinceLastPlayed()).zzg("NumberOfPurchases", (Object)playerStats.getNumberOfPurchases()).zzg("NumberOfSessions", (Object)playerStats.getNumberOfSessions()).zzg("SessionPercentile", (Object)Float.valueOf(playerStats.getSessionPercentile())).zzg("SpendPercentile", (Object)Float.valueOf(playerStats.getSpendPercentile())).zzg("SpendProbability", (Object)Float.valueOf(playerStats.getSpendProbability())).zzg("HighSpenderProbability", (Object)Float.valueOf(playerStats.getHighSpenderProbability())).zzg("TotalSpendNext28Days", (Object)Float.valueOf(playerStats.getTotalSpendNext28Days())).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        PlayerStatsEntityCreator.zza(this, parcel, n);
    }

    public /* synthetic */ Object freeze() {
        return this.zzbkr();
    }
}

