/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.api;

import android.content.Intent;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.internal.zzqc;
import com.google.android.gms.internal.zzrd;

public final class QuestsImpl
implements Quests {
    @Override
    public Intent getQuestsIntent(GoogleApiClient googleApiClient, int[] nArray) {
        return Games.zzi(googleApiClient).zzc(nArray);
    }

    @Override
    public Intent getQuestIntent(GoogleApiClient googleApiClient, String string) {
        return Games.zzi(googleApiClient).zzjx(string);
    }

    @Override
    public void registerQuestUpdateListener(GoogleApiClient googleApiClient, QuestUpdateListener questUpdateListener) {
        GamesClientImpl gamesClientImpl = Games.zzb(googleApiClient, false);
        if (gamesClientImpl != null) {
            zzrd zzrd2 = googleApiClient.zzs((Object)questUpdateListener);
            gamesClientImpl.zzc((zzrd<QuestUpdateListener>)zzrd2);
        }
    }

    @Override
    public void unregisterQuestUpdateListener(GoogleApiClient googleApiClient) {
        GamesClientImpl gamesClientImpl = Games.zzb(googleApiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzbkg();
        }
    }

    @Override
    public PendingResult<Quests.AcceptQuestResult> accept(GoogleApiClient googleApiClient, final String string) {
        return googleApiClient.zzd((zzqc.zza)new AcceptImpl(googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzh((zzqc.zzb<Quests.AcceptQuestResult>)this, string);
            }
        });
    }

    @Override
    public PendingResult<Quests.ClaimMilestoneResult> claim(GoogleApiClient googleApiClient, final String string, final String string2) {
        return googleApiClient.zzd((zzqc.zza)new ClaimImpl(googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzb((zzqc.zzb<Quests.ClaimMilestoneResult>)this, string, string2);
            }
        });
    }

    @Override
    public PendingResult<Quests.LoadQuestsResult> load(GoogleApiClient googleApiClient, final int[] nArray, final int n, final boolean bl) {
        return googleApiClient.zzc((zzqc.zza)new LoadsImpl(googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zzqc.zzb<Quests.LoadQuestsResult>)this, nArray, n, bl);
            }
        });
    }

    @Override
    public PendingResult<Quests.LoadQuestsResult> loadByIds(GoogleApiClient googleApiClient, final boolean bl, final String ... stringArray) {
        return googleApiClient.zzc((zzqc.zza)new LoadsImpl(googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzb((zzqc.zzb<Quests.LoadQuestsResult>)this, bl, stringArray);
            }
        });
    }

    @Override
    public void showStateChangedPopup(GoogleApiClient googleApiClient, String string) {
        GamesClientImpl gamesClientImpl = Games.zzb(googleApiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzjy(string);
        }
    }

    private static abstract class LoadsImpl
    extends Games.BaseGamesApiMethodImpl<Quests.LoadQuestsResult> {
        private LoadsImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Quests.LoadQuestsResult zzck(final Status status) {
            return new Quests.LoadQuestsResult(){

                public void release() {
                }

                public Status getStatus() {
                    return status;
                }

                @Override
                public QuestBuffer getQuests() {
                    int n = status.getStatusCode();
                    return new QuestBuffer(DataHolder.zzgc((int)n));
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzck(status);
        }
    }

    private static abstract class ClaimImpl
    extends Games.BaseGamesApiMethodImpl<Quests.ClaimMilestoneResult> {
        private ClaimImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Quests.ClaimMilestoneResult zzcj(final Status status) {
            return new Quests.ClaimMilestoneResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public Milestone getMilestone() {
                    return null;
                }

                @Override
                public Quest getQuest() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzcj(status);
        }
    }

    private static abstract class AcceptImpl
    extends Games.BaseGamesApiMethodImpl<Quests.AcceptQuestResult> {
        private AcceptImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Quests.AcceptQuestResult zzci(final Status status) {
            return new Quests.AcceptQuestResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public Quest getQuest() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzci(status);
        }
    }
}

