/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.internal.constants.TurnBasedMatchTurnStatus;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;

public final class LoadMatchesResponse {
    private final InvitationBuffer acT;
    private final TurnBasedMatchBuffer acU;
    private final TurnBasedMatchBuffer acV;
    private final TurnBasedMatchBuffer acW;

    public LoadMatchesResponse(Bundle bundle) {
        DataHolder dataHolder = LoadMatchesResponse.zzc(bundle, 0);
        this.acT = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.zzc(bundle, 1);
        this.acU = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.zzc(bundle, 2);
        this.acV = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.zzc(bundle, 3);
        this.acW = dataHolder4 != null ? new TurnBasedMatchBuffer(dataHolder4) : null;
    }

    private static DataHolder zzc(Bundle bundle, int n) {
        String string = TurnBasedMatchTurnStatus.zzrv(n);
        if (!bundle.containsKey(string)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string);
    }

    public InvitationBuffer getInvitations() {
        return this.acT;
    }

    public TurnBasedMatchBuffer getMyTurnMatches() {
        return this.acU;
    }

    public TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.acV;
    }

    public TurnBasedMatchBuffer getCompletedMatches() {
        return this.acW;
    }

    @Deprecated
    public void close() {
        this.release();
    }

    public void release() {
        if (this.acT != null) {
            this.acT.release();
        }
        if (this.acU != null) {
            this.acU.release();
        }
        if (this.acV != null) {
            this.acV.release();
        }
        if (this.acW != null) {
            this.acW.release();
        }
    }

    public boolean hasData() {
        if (this.acT != null && this.acT.getCount() > 0) {
            return true;
        }
        if (this.acU != null && this.acU.getCount() > 0) {
            return true;
        }
        if (this.acV != null && this.acV.getCount() > 0) {
            return true;
        }
        return this.acW != null && this.acW.getCount() > 0;
    }
}

