/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameRef;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerRef;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestEntity;
import java.util.ArrayList;
import java.util.List;

public final class GameRequestRef
extends zzc
implements GameRequest {
    private final int Wu;

    public GameRequestRef(DataHolder dataHolder, int n, int n2) {
        super(dataHolder, n);
        this.Wu = n2;
    }

    @Override
    public String getRequestId() {
        return this.getString("external_request_id");
    }

    @Override
    public Game getGame() {
        return new GameRef(this.xi, this.zK);
    }

    @Override
    public Player getSender() {
        return new PlayerRef(this.xi, this.zzatc(), "sender_");
    }

    @Override
    public List<Player> getRecipients() {
        ArrayList<Player> arrayList = new ArrayList<Player>(this.Wu);
        for (int i = 0; i < this.Wu; ++i) {
            arrayList.add(new PlayerRef(this.xi, this.zK + i, "recipient_"));
        }
        return arrayList;
    }

    @Override
    public boolean isConsumed(String string) {
        return this.getRecipientStatus(string) == 1;
    }

    @Override
    public byte[] getData() {
        return this.getByteArray("data");
    }

    @Override
    public int getType() {
        return this.getInteger("type");
    }

    @Override
    public long getCreationTimestamp() {
        return this.getLong("creation_timestamp");
    }

    @Override
    public long getExpirationTimestamp() {
        return this.getLong("expiration_timestamp");
    }

    @Override
    public int getRecipientStatus(String string) {
        for (int i = this.zK; i < this.zK + this.Wu; ++i) {
            int n = this.xi.zzgb(i);
            String string2 = this.xi.zzd("recipient_external_player_id", i, n);
            if (!string2.equals(string)) continue;
            return this.xi.zzc("recipient_status", i, n);
        }
        return -1;
    }

    @Override
    public int getStatus() {
        return this.getInteger("status");
    }

    public GameRequest freeze() {
        return new GameRequestEntity(this);
    }

    public int hashCode() {
        return GameRequestEntity.zza(this);
    }

    public boolean equals(Object object) {
        return GameRequestEntity.zza(this, object);
    }

    public String toString() {
        return GameRequestEntity.zzc(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        GameRequestEntity gameRequestEntity = (GameRequestEntity)((GameRequest)this.freeze());
        gameRequestEntity.writeToParcel(parcel, n);
    }
}

