/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.AchievementEntityCreator;

public final class AchievementEntity
extends AbstractSafeParcelable
implements Achievement {
    public static final Parcelable.Creator<AchievementEntity> CREATOR = new AchievementEntityCreator();
    private final int mVersionCode;
    private final String VQ;
    private final int lN;
    private final String mName;
    private final String Y;
    private final Uri VR;
    private final String VS;
    private final Uri VT;
    private final String VU;
    private final int VV;
    private final String VW;
    private final PlayerEntity VX;
    private final int mState;
    private final int VY;
    private final String VZ;
    private final long Wa;
    private final long Wb;

    public AchievementEntity(Achievement achievement) {
        this.mVersionCode = 1;
        this.VQ = achievement.getAchievementId();
        this.lN = achievement.getType();
        this.mName = achievement.getName();
        this.Y = achievement.getDescription();
        this.VR = achievement.getUnlockedImageUri();
        this.VS = achievement.getUnlockedImageUrl();
        this.VT = achievement.getRevealedImageUri();
        this.VU = achievement.getRevealedImageUrl();
        this.VX = (PlayerEntity)achievement.getPlayer().freeze();
        this.mState = achievement.getState();
        this.Wa = achievement.getLastUpdatedTimestamp();
        this.Wb = achievement.getXpValue();
        if (achievement.getType() == 1) {
            this.VV = achievement.getTotalSteps();
            this.VW = achievement.getFormattedTotalSteps();
            this.VY = achievement.getCurrentSteps();
            this.VZ = achievement.getFormattedCurrentSteps();
        } else {
            this.VV = 0;
            this.VW = null;
            this.VY = 0;
            this.VZ = null;
        }
        zzc.zzu((Object)this.VQ);
        zzc.zzu((Object)this.Y);
    }

    AchievementEntity(int n, String string, int n2, String string2, String string3, Uri uri, String string4, Uri uri2, String string5, int n3, String string6, PlayerEntity playerEntity, int n4, int n5, String string7, long l, long l2) {
        this.mVersionCode = n;
        this.VQ = string;
        this.lN = n2;
        this.mName = string2;
        this.Y = string3;
        this.VR = uri;
        this.VS = string4;
        this.VT = uri2;
        this.VU = string5;
        this.VV = n3;
        this.VW = string6;
        this.VX = playerEntity;
        this.mState = n4;
        this.VY = n5;
        this.VZ = string7;
        this.Wa = l;
        this.Wb = l2;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getAchievementId() {
        return this.VQ;
    }

    @Override
    public int getType() {
        return this.lN;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDescription() {
        return this.Y;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.Y, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getUnlockedImageUri() {
        return this.VR;
    }

    @Override
    public String getUnlockedImageUrl() {
        return this.VS;
    }

    @Override
    public Uri getRevealedImageUri() {
        return this.VT;
    }

    @Override
    public String getRevealedImageUrl() {
        return this.VU;
    }

    public int zzbil() {
        return this.VV;
    }

    @Override
    public int getTotalSteps() {
        zzc.zzbr((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzbil();
    }

    @Override
    public String getFormattedTotalSteps() {
        zzc.zzbr((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzbim();
    }

    public String zzbim() {
        return this.VW;
    }

    @Override
    public void getFormattedTotalSteps(CharArrayBuffer charArrayBuffer) {
        zzc.zzbr((this.getType() == 1 ? 1 : 0) != 0);
        zzg.zzb((String)this.VW, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Player getPlayer() {
        return this.VX;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getCurrentSteps() {
        zzc.zzbr((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzbin();
    }

    public int zzbin() {
        return this.VY;
    }

    @Override
    public String getFormattedCurrentSteps() {
        zzc.zzbr((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzbio();
    }

    public String zzbio() {
        return this.VZ;
    }

    @Override
    public void getFormattedCurrentSteps(CharArrayBuffer charArrayBuffer) {
        zzc.zzbr((this.getType() == 1 ? 1 : 0) != 0);
        zzg.zzb((String)this.VZ, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.Wa;
    }

    @Override
    public long getXpValue() {
        return this.Wb;
    }

    public Achievement freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return AchievementEntity.zza(this);
    }

    static int zza(Achievement achievement) {
        int n = 0;
        int n2 = 0;
        if (achievement.getType() == 1) {
            n = achievement.getCurrentSteps();
            n2 = achievement.getTotalSteps();
        }
        return zzab.hashCode((Object[])new Object[]{achievement.getAchievementId(), achievement.getName(), achievement.getType(), achievement.getDescription(), achievement.getXpValue(), achievement.getState(), achievement.getLastUpdatedTimestamp(), achievement.getPlayer(), n, n2});
    }

    public boolean equals(Object object) {
        return AchievementEntity.zza(this, object);
    }

    static boolean zza(Achievement achievement, Object object) {
        if (!(object instanceof Achievement)) {
            return false;
        }
        if (achievement == object) {
            return true;
        }
        Achievement achievement2 = (Achievement)object;
        boolean bl = true;
        boolean bl2 = true;
        if (achievement.getType() == 1) {
            bl = zzab.equal((Object)achievement2.getCurrentSteps(), (Object)achievement.getCurrentSteps());
            bl2 = zzab.equal((Object)achievement2.getTotalSteps(), (Object)achievement.getTotalSteps());
        }
        return zzab.equal((Object)achievement2.getAchievementId(), (Object)achievement.getAchievementId()) && zzab.equal((Object)achievement2.getName(), (Object)achievement.getName()) && zzab.equal((Object)achievement2.getType(), (Object)achievement.getType()) && zzab.equal((Object)achievement2.getDescription(), (Object)achievement.getDescription()) && zzab.equal((Object)achievement2.getXpValue(), (Object)achievement.getXpValue()) && zzab.equal((Object)achievement2.getState(), (Object)achievement.getState()) && zzab.equal((Object)achievement2.getLastUpdatedTimestamp(), (Object)achievement.getLastUpdatedTimestamp()) && zzab.equal((Object)achievement2.getPlayer(), (Object)achievement.getPlayer()) && bl && bl2;
    }

    public String toString() {
        return AchievementEntity.zzb(this);
    }

    static String zzb(Achievement achievement) {
        zzab.zza zza2 = zzab.zzx((Object)achievement).zzg("Id", (Object)achievement.getAchievementId()).zzg("Type", (Object)achievement.getType()).zzg("Name", (Object)achievement.getName()).zzg("Description", (Object)achievement.getDescription()).zzg("Player", (Object)achievement.getPlayer()).zzg("State", (Object)achievement.getState());
        if (achievement.getType() == 1) {
            zza2.zzg("CurrentSteps", (Object)achievement.getCurrentSteps());
            zza2.zzg("TotalSteps", (Object)achievement.getTotalSteps());
        }
        return zza2.toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        AchievementEntityCreator.zza(this, parcel, n);
    }
}

