/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.games.video.VideoCapabilitiesCreator;
import com.google.android.gms.games.video.VideoConfiguration;

public final class VideoCapabilities
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<VideoCapabilities> CREATOR = new VideoCapabilitiesCreator();
    private final int mVersionCode;
    private final boolean aei;
    private final boolean aej;
    private final boolean aek;
    private final boolean[] ael;
    private final boolean[] aem;

    public VideoCapabilities(int n, boolean bl, boolean bl2, boolean bl3, boolean[] blArray, boolean[] blArray2) {
        this.mVersionCode = n;
        this.aei = bl;
        this.aej = bl2;
        this.aek = bl3;
        this.ael = blArray;
        this.aem = blArray2;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public boolean isMicSupported() {
        return this.aej;
    }

    public boolean isCameraSupported() {
        return this.aei;
    }

    public boolean isWriteStorageSupported() {
        return this.aek;
    }

    public boolean[] zzbnm() {
        return this.ael;
    }

    public boolean[] zzbnn() {
        return this.aem;
    }

    public boolean supportsCaptureMode(int n) {
        zzac.zzbr((boolean)VideoConfiguration.isValidCaptureMode(n, false));
        return this.ael[n];
    }

    public boolean supportsQualityLevel(int n) {
        zzac.zzbr((boolean)VideoConfiguration.isValidQualityLevel(n, false));
        return this.aem[n];
    }

    public boolean isFullySupported(int n, int n2) {
        return this.aei && this.aej && this.aek && this.supportsCaptureMode(n) && this.supportsQualityLevel(n2);
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.zzbnm(), this.zzbnn(), this.isCameraSupported(), this.isMicSupported(), this.isWriteStorageSupported()});
    }

    public boolean equals(Object object) {
        if (!(object instanceof VideoCapabilities)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        VideoCapabilities videoCapabilities = (VideoCapabilities)((Object)object);
        return zzab.equal((Object)videoCapabilities.zzbnm(), (Object)this.zzbnm()) && zzab.equal((Object)videoCapabilities.zzbnn(), (Object)this.zzbnn()) && zzab.equal((Object)videoCapabilities.isCameraSupported(), (Object)this.isCameraSupported()) && zzab.equal((Object)videoCapabilities.isMicSupported(), (Object)this.isMicSupported()) && zzab.equal((Object)videoCapabilities.isWriteStorageSupported(), (Object)this.isWriteStorageSupported());
    }

    public String toString() {
        return zzab.zzx((Object)((Object)this)).zzg("SupportedCaptureModes", (Object)this.zzbnm()).zzg("SupportedQualityLevels", (Object)this.zzbnn()).zzg("CameraSupported", (Object)this.isCameraSupported()).zzg("MicSupported", (Object)this.isMicSupported()).zzg("StorageWriteSupported", (Object)this.isWriteStorageSupported()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        VideoCapabilitiesCreator.zza(this, parcel, n);
    }
}

