/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.AchievementEntityCreator;

public final class AchievementEntity
extends AbstractSafeParcelable
implements Achievement {
    public static final Parcelable.Creator<AchievementEntity> CREATOR = new AchievementEntityCreator();
    private final int mVersionCode;
    private final String XX;
    private final int nV;
    private final String mName;
    private final String cg;
    private final Uri XY;
    private final String XZ;
    private final Uri Ya;
    private final String Yb;
    private final int Yc;
    private final String Yd;
    private final PlayerEntity Ye;
    private final int mState;
    private final int Yf;
    private final String Yg;
    private final long Yh;
    private final long Yi;

    public AchievementEntity(Achievement achievement) {
        this.mVersionCode = 1;
        this.XX = achievement.getAchievementId();
        this.nV = achievement.getType();
        this.mName = achievement.getName();
        this.cg = achievement.getDescription();
        this.XY = achievement.getUnlockedImageUri();
        this.XZ = achievement.getUnlockedImageUrl();
        this.Ya = achievement.getRevealedImageUri();
        this.Yb = achievement.getRevealedImageUrl();
        this.Ye = (PlayerEntity)achievement.getPlayer().freeze();
        this.mState = achievement.getState();
        this.Yh = achievement.getLastUpdatedTimestamp();
        this.Yi = achievement.getXpValue();
        if (achievement.getType() == 1) {
            this.Yc = achievement.getTotalSteps();
            this.Yd = achievement.getFormattedTotalSteps();
            this.Yf = achievement.getCurrentSteps();
            this.Yg = achievement.getFormattedCurrentSteps();
        } else {
            this.Yc = 0;
            this.Yd = null;
            this.Yf = 0;
            this.Yg = null;
        }
        zzc.zzu((Object)this.XX);
        zzc.zzu((Object)this.cg);
    }

    AchievementEntity(int n, String string, int n2, String string2, String string3, Uri uri, String string4, Uri uri2, String string5, int n3, String string6, PlayerEntity playerEntity, int n4, int n5, String string7, long l, long l2) {
        this.mVersionCode = n;
        this.XX = string;
        this.nV = n2;
        this.mName = string2;
        this.cg = string3;
        this.XY = uri;
        this.XZ = string4;
        this.Ya = uri2;
        this.Yb = string5;
        this.Yc = n3;
        this.Yd = string6;
        this.Ye = playerEntity;
        this.mState = n4;
        this.Yf = n5;
        this.Yg = string7;
        this.Yh = l;
        this.Yi = l2;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getAchievementId() {
        return this.XX;
    }

    @Override
    public int getType() {
        return this.nV;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDescription() {
        return this.cg;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.cg, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getUnlockedImageUri() {
        return this.XY;
    }

    @Override
    public String getUnlockedImageUrl() {
        return this.XZ;
    }

    @Override
    public Uri getRevealedImageUri() {
        return this.Ya;
    }

    @Override
    public String getRevealedImageUrl() {
        return this.Yb;
    }

    public int zzbid() {
        return this.Yc;
    }

    @Override
    public int getTotalSteps() {
        zzc.zzbs((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzbid();
    }

    @Override
    public String getFormattedTotalSteps() {
        zzc.zzbs((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzbie();
    }

    public String zzbie() {
        return this.Yd;
    }

    @Override
    public void getFormattedTotalSteps(CharArrayBuffer charArrayBuffer) {
        zzc.zzbs((this.getType() == 1 ? 1 : 0) != 0);
        zzg.zzb((String)this.Yd, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Player getPlayer() {
        return this.Ye;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getCurrentSteps() {
        zzc.zzbs((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzbif();
    }

    public int zzbif() {
        return this.Yf;
    }

    @Override
    public String getFormattedCurrentSteps() {
        zzc.zzbs((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzbig();
    }

    public String zzbig() {
        return this.Yg;
    }

    @Override
    public void getFormattedCurrentSteps(CharArrayBuffer charArrayBuffer) {
        zzc.zzbs((this.getType() == 1 ? 1 : 0) != 0);
        zzg.zzb((String)this.Yg, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.Yh;
    }

    @Override
    public long getXpValue() {
        return this.Yi;
    }

    public Achievement freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return AchievementEntity.zza(this);
    }

    static int zza(Achievement achievement) {
        int n = 0;
        int n2 = 0;
        if (achievement.getType() == 1) {
            n = achievement.getCurrentSteps();
            n2 = achievement.getTotalSteps();
        }
        return zzz.hashCode((Object[])new Object[]{achievement.getAchievementId(), achievement.getName(), achievement.getType(), achievement.getDescription(), achievement.getXpValue(), achievement.getState(), achievement.getLastUpdatedTimestamp(), achievement.getPlayer(), n, n2});
    }

    public boolean equals(Object object) {
        return AchievementEntity.zza(this, object);
    }

    static boolean zza(Achievement achievement, Object object) {
        if (!(object instanceof Achievement)) {
            return false;
        }
        if (achievement == object) {
            return true;
        }
        Achievement achievement2 = (Achievement)object;
        boolean bl = true;
        boolean bl2 = true;
        if (achievement.getType() == 1) {
            bl = zzz.equal((Object)achievement2.getCurrentSteps(), (Object)achievement.getCurrentSteps());
            bl2 = zzz.equal((Object)achievement2.getTotalSteps(), (Object)achievement.getTotalSteps());
        }
        return zzz.equal((Object)achievement2.getAchievementId(), (Object)achievement.getAchievementId()) && zzz.equal((Object)achievement2.getName(), (Object)achievement.getName()) && zzz.equal((Object)achievement2.getType(), (Object)achievement.getType()) && zzz.equal((Object)achievement2.getDescription(), (Object)achievement.getDescription()) && zzz.equal((Object)achievement2.getXpValue(), (Object)achievement.getXpValue()) && zzz.equal((Object)achievement2.getState(), (Object)achievement.getState()) && zzz.equal((Object)achievement2.getLastUpdatedTimestamp(), (Object)achievement.getLastUpdatedTimestamp()) && zzz.equal((Object)achievement2.getPlayer(), (Object)achievement.getPlayer()) && bl && bl2;
    }

    public String toString() {
        return AchievementEntity.zzb(this);
    }

    static String zzb(Achievement achievement) {
        zzz.zza zza2 = zzz.zzx((Object)achievement).zzg("Id", (Object)achievement.getAchievementId()).zzg("Type", (Object)achievement.getType()).zzg("Name", (Object)achievement.getName()).zzg("Description", (Object)achievement.getDescription()).zzg("Player", (Object)achievement.getPlayer()).zzg("State", (Object)achievement.getState());
        if (achievement.getType() == 1) {
            zza2.zzg("CurrentSteps", (Object)achievement.getCurrentSteps());
            zza2.zzg("TotalSteps", (Object)achievement.getTotalSteps());
        }
        return zza2.toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        AchievementEntityCreator.zza(this, parcel, n);
    }
}

