/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.player;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.internal.player.ProfileSettingsEntityCreator;
import com.google.android.gms.games.internal.player.StockProfileImage;
import com.google.android.gms.games.internal.player.StockProfileImageEntity;

public class ProfileSettingsEntity
extends AbstractSafeParcelable
implements Players.LoadProfileSettingsResult {
    public static final Parcelable.Creator<ProfileSettingsEntity> CREATOR = new ProfileSettingsEntityCreator();
    private final int mVersionCode;
    private final Status hv;
    private final String XH;
    private final boolean adP;
    private final boolean XF;
    private final boolean adQ;
    private final StockProfileImageEntity adR;
    private final boolean adS;
    private final boolean adT;

    public ProfileSettingsEntity(DataHolder dataHolder) {
        this.mVersionCode = 3;
        this.hv = new Status(dataHolder.getStatusCode());
        if (this.hv.isSuccess() && dataHolder.getCount() > 0) {
            int n = dataHolder.zzga(0);
            this.XH = dataHolder.zzd("gamer_tag", 0, n);
            this.adP = dataHolder.zze("gamer_tag_explicitly_set", 0, n);
            this.XF = dataHolder.zze("profile_visible", 0, n);
            this.adQ = dataHolder.zze("profile_visibility_explicitly_set", 0, n);
            String string = dataHolder.zzd("stock_avatar_url", 0, n);
            String string2 = dataHolder.zzd("stock_avatar_uri", 0, n);
            this.adR = !TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2) ? new StockProfileImageEntity(string, Uri.parse((String)string2)) : null;
            this.adS = dataHolder.zze("profile_discoverable", 0, n);
            this.adT = dataHolder.zze("auto_sign_in", 0, n);
        } else {
            this.XH = null;
            this.adP = false;
            this.XF = false;
            this.adQ = false;
            this.adR = null;
            this.adS = false;
            this.adT = false;
        }
    }

    ProfileSettingsEntity(int n, Status status, String string, boolean bl, boolean bl2, boolean bl3, StockProfileImageEntity stockProfileImageEntity, boolean bl4, boolean bl5) {
        this.mVersionCode = n;
        this.hv = status;
        this.XH = string;
        this.adP = bl;
        this.XF = bl2;
        this.adQ = bl3;
        this.adR = stockProfileImageEntity;
        this.adS = bl4;
        this.adT = bl5;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String zzbhq() {
        return this.XH;
    }

    @Override
    public boolean zzbia() {
        return this.adP;
    }

    @Override
    public boolean zzbht() {
        return this.XF;
    }

    @Override
    public boolean zzbhy() {
        return this.adQ;
    }

    @Override
    public StockProfileImage zzbhz() {
        return this.adR;
    }

    @Override
    public boolean zzbib() {
        return this.adS;
    }

    @Override
    public boolean zzbic() {
        return this.adT;
    }

    public Status getStatus() {
        return this.hv;
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.XH, this.adP, this.XF, this.adQ, this.hv, this.adR, this.adS, this.adT});
    }

    public boolean equals(Object object) {
        if (!(object instanceof Players.LoadProfileSettingsResult)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Players.LoadProfileSettingsResult loadProfileSettingsResult = (Players.LoadProfileSettingsResult)object;
        return zzz.equal((Object)this.XH, (Object)loadProfileSettingsResult.zzbhq()) && zzz.equal((Object)this.adP, (Object)loadProfileSettingsResult.zzbia()) && zzz.equal((Object)this.XF, (Object)loadProfileSettingsResult.zzbht()) && zzz.equal((Object)this.adQ, (Object)loadProfileSettingsResult.zzbhy()) && zzz.equal((Object)this.hv, (Object)loadProfileSettingsResult.getStatus()) && zzz.equal((Object)this.adR, (Object)loadProfileSettingsResult.zzbhz()) && zzz.equal((Object)this.adS, (Object)loadProfileSettingsResult.zzbib()) && zzz.equal((Object)this.adT, (Object)loadProfileSettingsResult.zzbic());
    }

    public String toString() {
        return zzz.zzx((Object)this).zzg("GamerTag", (Object)this.XH).zzg("IsGamerTagExplicitlySet", (Object)this.adP).zzg("IsProfileVisible", (Object)this.XF).zzg("IsVisibilityExplicitlySet", (Object)this.adQ).zzg("Status", (Object)this.hv).zzg("StockProfileImage", (Object)this.adR).zzg("IsProfileDiscoverable", (Object)this.adS).zzg("AutoSignIn", (Object)this.adT).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        ProfileSettingsEntityCreator.zza(this, parcel, n);
    }
}

