/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;

public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long aed;
    private final String aee;
    private final String aef;
    private final long aeg;
    private final long aeh;
    private final String aei;
    private final Uri aej;
    private final Uri aek;
    private final PlayerEntity ael;
    private final String aem;
    private final String aen;
    private final String aeo;

    public LeaderboardScoreEntity(LeaderboardScore leaderboardScore) {
        this.aed = leaderboardScore.getRank();
        this.aee = (String)zzaa.zzy((Object)leaderboardScore.getDisplayRank());
        this.aef = (String)zzaa.zzy((Object)leaderboardScore.getDisplayScore());
        this.aeg = leaderboardScore.getRawScore();
        this.aeh = leaderboardScore.getTimestampMillis();
        this.aei = leaderboardScore.getScoreHolderDisplayName();
        this.aej = leaderboardScore.getScoreHolderIconImageUri();
        this.aek = leaderboardScore.getScoreHolderHiResImageUri();
        Player player = leaderboardScore.getScoreHolder();
        this.ael = player == null ? null : (PlayerEntity)player.freeze();
        this.aem = leaderboardScore.getScoreTag();
        this.aen = leaderboardScore.getScoreHolderIconImageUrl();
        this.aeo = leaderboardScore.getScoreHolderHiResImageUrl();
    }

    @Override
    public long getRank() {
        return this.aed;
    }

    @Override
    public String getDisplayRank() {
        return this.aee;
    }

    @Override
    public void getDisplayRank(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.aee, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDisplayScore() {
        return this.aef;
    }

    @Override
    public void getDisplayScore(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.aef, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public long getRawScore() {
        return this.aeg;
    }

    @Override
    public long getTimestampMillis() {
        return this.aeh;
    }

    @Override
    public String getScoreHolderDisplayName() {
        if (this.ael == null) {
            return this.aei;
        }
        return this.ael.getDisplayName();
    }

    @Override
    public void getScoreHolderDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.ael == null) {
            zzg.zzb((String)this.aei, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.ael.getDisplayName(charArrayBuffer);
    }

    @Override
    public Uri getScoreHolderIconImageUri() {
        if (this.ael == null) {
            return this.aej;
        }
        return this.ael.getIconImageUri();
    }

    @Override
    public String getScoreHolderIconImageUrl() {
        if (this.ael == null) {
            return this.aen;
        }
        return this.ael.getIconImageUrl();
    }

    @Override
    public Uri getScoreHolderHiResImageUri() {
        if (this.ael == null) {
            return this.aek;
        }
        return this.ael.getHiResImageUri();
    }

    @Override
    public String getScoreHolderHiResImageUrl() {
        if (this.ael == null) {
            return this.aeo;
        }
        return this.ael.getHiResImageUrl();
    }

    @Override
    public Player getScoreHolder() {
        return this.ael;
    }

    @Override
    public String getScoreTag() {
        return this.aem;
    }

    public LeaderboardScore zzbmo() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    static int zza(LeaderboardScore leaderboardScore) {
        return zzz.hashCode((Object[])new Object[]{leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder()});
    }

    public boolean equals(Object object) {
        return LeaderboardScoreEntity.zza(this, object);
    }

    static boolean zza(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return zzz.equal((Object)leaderboardScore2.getRank(), (Object)leaderboardScore.getRank()) && zzz.equal((Object)leaderboardScore2.getDisplayRank(), (Object)leaderboardScore.getDisplayRank()) && zzz.equal((Object)leaderboardScore2.getRawScore(), (Object)leaderboardScore.getRawScore()) && zzz.equal((Object)leaderboardScore2.getDisplayScore(), (Object)leaderboardScore.getDisplayScore()) && zzz.equal((Object)leaderboardScore2.getTimestampMillis(), (Object)leaderboardScore.getTimestampMillis()) && zzz.equal((Object)leaderboardScore2.getScoreHolderDisplayName(), (Object)leaderboardScore.getScoreHolderDisplayName()) && zzz.equal((Object)leaderboardScore2.getScoreHolderIconImageUri(), (Object)leaderboardScore.getScoreHolderIconImageUri()) && zzz.equal((Object)leaderboardScore2.getScoreHolderHiResImageUri(), (Object)leaderboardScore.getScoreHolderHiResImageUri()) && zzz.equal((Object)leaderboardScore2.getScoreHolder(), (Object)leaderboardScore.getScoreHolder()) && zzz.equal((Object)leaderboardScore2.getScoreTag(), (Object)leaderboardScore.getScoreTag());
    }

    public String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    static String zzb(LeaderboardScore leaderboardScore) {
        return zzz.zzx((Object)leaderboardScore).zzg("Rank", (Object)leaderboardScore.getRank()).zzg("DisplayRank", (Object)leaderboardScore.getDisplayRank()).zzg("Score", (Object)leaderboardScore.getRawScore()).zzg("DisplayScore", (Object)leaderboardScore.getDisplayScore()).zzg("Timestamp", (Object)leaderboardScore.getTimestampMillis()).zzg("DisplayName", (Object)leaderboardScore.getScoreHolderDisplayName()).zzg("IconImageUri", (Object)leaderboardScore.getScoreHolderIconImageUri()).zzg("IconImageUrl", (Object)leaderboardScore.getScoreHolderIconImageUrl()).zzg("HiResImageUri", (Object)leaderboardScore.getScoreHolderHiResImageUri()).zzg("HiResImageUrl", (Object)leaderboardScore.getScoreHolderHiResImageUrl()).zzg("Player", (Object)(leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder())).zzg("ScoreTag", (Object)leaderboardScore.getScoreTag()).toString();
    }

    public /* synthetic */ Object freeze() {
        return this.zzbmo();
    }
}

