/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerRef;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;

public final class LeaderboardScoreRef
extends zzc
implements LeaderboardScore {
    private final PlayerRef aep;

    LeaderboardScoreRef(DataHolder dataHolder, int n) {
        super(dataHolder, n);
        this.aep = new PlayerRef(dataHolder, n);
    }

    @Override
    public long getRank() {
        return this.getLong("rank");
    }

    @Override
    public String getDisplayRank() {
        return this.getString("display_rank");
    }

    @Override
    public void getDisplayRank(CharArrayBuffer charArrayBuffer) {
        this.zza("display_rank", charArrayBuffer);
    }

    @Override
    public String getDisplayScore() {
        return this.getString("display_score");
    }

    @Override
    public void getDisplayScore(CharArrayBuffer charArrayBuffer) {
        this.zza("display_score", charArrayBuffer);
    }

    @Override
    public long getRawScore() {
        return this.getLong("raw_score");
    }

    @Override
    public long getTimestampMillis() {
        return this.getLong("achieved_timestamp");
    }

    @Override
    public String getScoreHolderDisplayName() {
        if (this.zzhq("external_player_id")) {
            return this.getString("default_display_name");
        }
        return this.aep.getDisplayName();
    }

    @Override
    public void getScoreHolderDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzhq("external_player_id")) {
            this.zza("default_display_name", charArrayBuffer);
            return;
        }
        this.aep.getDisplayName(charArrayBuffer);
    }

    @Override
    public Uri getScoreHolderIconImageUri() {
        if (this.zzhq("external_player_id")) {
            return this.zzhp("default_display_image_uri");
        }
        return this.aep.getIconImageUri();
    }

    @Override
    public String getScoreHolderIconImageUrl() {
        if (this.zzhq("external_player_id")) {
            return this.getString("default_display_image_url");
        }
        return this.aep.getIconImageUrl();
    }

    @Override
    public Uri getScoreHolderHiResImageUri() {
        if (this.zzhq("external_player_id")) {
            return null;
        }
        return this.aep.getHiResImageUri();
    }

    @Override
    public String getScoreHolderHiResImageUrl() {
        if (this.zzhq("external_player_id")) {
            return null;
        }
        return this.aep.getHiResImageUrl();
    }

    @Override
    public Player getScoreHolder() {
        if (this.zzhq("external_player_id")) {
            return null;
        }
        return this.aep;
    }

    @Override
    public String getScoreTag() {
        return this.getString("score_tag");
    }

    public LeaderboardScore zzbmo() {
        return new LeaderboardScoreEntity(this);
    }

    public int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    public boolean equals(Object object) {
        return LeaderboardScoreEntity.zza(this, object);
    }

    public String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    public /* synthetic */ Object freeze() {
        return this.zzbmo();
    }
}

