/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationEntityCreator;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import java.util.ArrayList;

public final class InvitationEntity
extends GamesDowngradeableSafeParcel
implements Invitation {
    public static final Parcelable.Creator<InvitationEntity> CREATOR = new InvitationEntityCreatorCompat();
    private final int mVersionCode;
    private final GameEntity acT;
    private final String hm;
    private final long aeD;
    private final int aeE;
    private final ParticipantEntity aeF;
    private final ArrayList<ParticipantEntity> aeG;
    private final int aeH;
    private final int aeI;

    InvitationEntity(Invitation invitation) {
        this.mVersionCode = 2;
        this.acT = new GameEntity(invitation.getGame());
        this.hm = invitation.getInvitationId();
        this.aeD = invitation.getCreationTimestamp();
        this.aeE = invitation.getInvitationType();
        this.aeH = invitation.getVariant();
        this.aeI = invitation.getAvailableAutoMatchSlots();
        String string = invitation.getInviter().getParticipantId();
        Participant participant = null;
        ArrayList arrayList = invitation.getParticipants();
        int n = arrayList.size();
        this.aeG = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Participant participant2 = (Participant)arrayList.get(i);
            if (participant2.getParticipantId().equals(string)) {
                participant = participant2;
            }
            this.aeG.add((ParticipantEntity)participant2.freeze());
        }
        zzaa.zzb(participant, (Object)"Must have a valid inviter!");
        this.aeF = (ParticipantEntity)participant.freeze();
    }

    InvitationEntity(int n, GameEntity gameEntity, String string, long l, int n2, ParticipantEntity participantEntity, ArrayList<ParticipantEntity> arrayList, int n3, int n4) {
        this.mVersionCode = n;
        this.acT = gameEntity;
        this.hm = string;
        this.aeD = l;
        this.aeE = n2;
        this.aeF = participantEntity;
        this.aeG = arrayList;
        this.aeH = n3;
        this.aeI = n4;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public Game getGame() {
        return this.acT;
    }

    @Override
    public String getInvitationId() {
        return this.hm;
    }

    @Override
    public Participant getInviter() {
        return this.aeF;
    }

    @Override
    public long getCreationTimestamp() {
        return this.aeD;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.aeG);
    }

    @Override
    public int getInvitationType() {
        return this.aeE;
    }

    @Override
    public int getVariant() {
        return this.aeH;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        return this.aeI;
    }

    public Invitation freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return InvitationEntity.zza(this);
    }

    static int zza(Invitation invitation) {
        return zzz.hashCode((Object[])new Object[]{invitation.getGame(), invitation.getInvitationId(), invitation.getCreationTimestamp(), invitation.getInvitationType(), invitation.getInviter(), invitation.getParticipants(), invitation.getVariant(), invitation.getAvailableAutoMatchSlots()});
    }

    public boolean equals(Object object) {
        return InvitationEntity.zza(this, object);
    }

    static boolean zza(Invitation invitation, Object object) {
        if (!(object instanceof Invitation)) {
            return false;
        }
        if (invitation == object) {
            return true;
        }
        Invitation invitation2 = (Invitation)object;
        return zzz.equal((Object)invitation2.getGame(), (Object)invitation.getGame()) && zzz.equal((Object)invitation2.getInvitationId(), (Object)invitation.getInvitationId()) && zzz.equal((Object)invitation2.getCreationTimestamp(), (Object)invitation.getCreationTimestamp()) && zzz.equal((Object)invitation2.getInvitationType(), (Object)invitation.getInvitationType()) && zzz.equal((Object)invitation2.getInviter(), (Object)invitation.getInviter()) && zzz.equal((Object)invitation2.getParticipants(), (Object)invitation.getParticipants()) && zzz.equal((Object)invitation2.getVariant(), (Object)invitation.getVariant()) && zzz.equal((Object)invitation2.getAvailableAutoMatchSlots(), (Object)invitation.getAvailableAutoMatchSlots());
    }

    public String toString() {
        return InvitationEntity.zzb(this);
    }

    static String zzb(Invitation invitation) {
        return zzz.zzx((Object)invitation).zzg("Game", (Object)invitation.getGame()).zzg("InvitationId", (Object)invitation.getInvitationId()).zzg("CreationTimestamp", (Object)invitation.getCreationTimestamp()).zzg("InvitationType", (Object)invitation.getInvitationType()).zzg("Inviter", (Object)invitation.getInviter()).zzg("Participants", (Object)invitation.getParticipants()).zzg("Variant", (Object)invitation.getVariant()).zzg("AvailableAutoMatchSlots", (Object)invitation.getAvailableAutoMatchSlots()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (!this.zzawa()) {
            InvitationEntityCreator.zza(this, parcel, n);
        } else {
            this.acT.writeToParcel(parcel, n);
            parcel.writeString(this.hm);
            parcel.writeLong(this.aeD);
            parcel.writeInt(this.aeE);
            this.aeF.writeToParcel(parcel, n);
            int n2 = this.aeG.size();
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                this.aeG.get(i).writeToParcel(parcel, n);
            }
        }
    }

    static final class InvitationEntityCreatorCompat
    extends InvitationEntityCreator {
        InvitationEntityCreatorCompat() {
        }

        @Override
        public InvitationEntity zzmf(Parcel parcel) {
            int n;
            boolean bl = InvitationEntity.zzf(InvitationEntity.zzavz());
            if (bl || InvitationEntity.zzhu((String)InvitationEntity.class.getCanonicalName())) {
                return super.zzmf(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            String string = parcel.readString();
            long l = parcel.readLong();
            int n2 = parcel.readInt();
            ParticipantEntity participantEntity = (ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel);
            int n3 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n3);
            for (n = 0; n < n3; ++n) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n = -1;
            boolean bl2 = false;
            return new InvitationEntity(2, gameEntity, string, l, n2, participantEntity, arrayList, -1, 0);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzmf(parcel);
        }
    }
}

