/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntityCreator;
import com.google.android.gms.games.multiplayer.ParticipantResult;

public final class ParticipantEntity
extends GamesDowngradeableSafeParcel
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new ParticipantEntityCreatorCompat();
    private final int mVersionCode;
    private final String ZU;
    private final String jh;
    private final Uri WQ;
    private final Uri WR;
    private final int zzbtt;
    private final String YJ;
    private final boolean aeK;
    private final PlayerEntity Ye;
    private final int mt;
    private final ParticipantResult aeL;
    private final String Xb;
    private final String Xc;

    public ParticipantEntity(Participant participant) {
        this.mVersionCode = 3;
        this.ZU = participant.getParticipantId();
        this.jh = participant.getDisplayName();
        this.WQ = participant.getIconImageUri();
        this.WR = participant.getHiResImageUri();
        this.zzbtt = participant.getStatus();
        this.YJ = participant.zzbjm();
        this.aeK = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.Ye = player == null ? null : new PlayerEntity(player);
        this.mt = participant.getCapabilities();
        this.aeL = participant.getResult();
        this.Xb = participant.getIconImageUrl();
        this.Xc = participant.getHiResImageUrl();
    }

    ParticipantEntity(int n, String string, String string2, Uri uri, Uri uri2, int n2, String string3, boolean bl, PlayerEntity playerEntity, int n3, ParticipantResult participantResult, String string4, String string5) {
        this.mVersionCode = n;
        this.ZU = string;
        this.jh = string2;
        this.WQ = uri;
        this.WR = uri2;
        this.zzbtt = n2;
        this.YJ = string3;
        this.aeK = bl;
        this.Ye = playerEntity;
        this.mt = n3;
        this.aeL = participantResult;
        this.Xb = string4;
        this.Xc = string5;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public int getStatus() {
        return this.zzbtt;
    }

    @Override
    public String zzbjm() {
        return this.YJ;
    }

    @Override
    public boolean isConnectedToRoom() {
        return this.aeK;
    }

    @Override
    public String getDisplayName() {
        if (this.Ye == null) {
            return this.jh;
        }
        return this.Ye.getDisplayName();
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.Ye == null) {
            zzg.zzb((String)this.jh, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.Ye.getDisplayName(charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        if (this.Ye == null) {
            return this.WQ;
        }
        return this.Ye.getIconImageUri();
    }

    @Override
    public String getIconImageUrl() {
        if (this.Ye == null) {
            return this.Xb;
        }
        return this.Ye.getIconImageUrl();
    }

    @Override
    public Uri getHiResImageUri() {
        if (this.Ye == null) {
            return this.WR;
        }
        return this.Ye.getHiResImageUri();
    }

    @Override
    public String getHiResImageUrl() {
        if (this.Ye == null) {
            return this.Xc;
        }
        return this.Ye.getHiResImageUrl();
    }

    @Override
    public String getParticipantId() {
        return this.ZU;
    }

    @Override
    public Player getPlayer() {
        return this.Ye;
    }

    @Override
    public ParticipantResult getResult() {
        return this.aeL;
    }

    @Override
    public int getCapabilities() {
        return this.mt;
    }

    public Participant freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ParticipantEntity.zza(this);
    }

    static int zza(Participant participant) {
        return zzz.hashCode((Object[])new Object[]{participant.getPlayer(), participant.getStatus(), participant.zzbjm(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult(), participant.getParticipantId()});
    }

    public boolean equals(Object object) {
        return ParticipantEntity.zza(this, object);
    }

    static boolean zza(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return zzz.equal((Object)participant2.getPlayer(), (Object)participant.getPlayer()) && zzz.equal((Object)participant2.getStatus(), (Object)participant.getStatus()) && zzz.equal((Object)participant2.zzbjm(), (Object)participant.zzbjm()) && zzz.equal((Object)participant2.isConnectedToRoom(), (Object)participant.isConnectedToRoom()) && zzz.equal((Object)participant2.getDisplayName(), (Object)participant.getDisplayName()) && zzz.equal((Object)participant2.getIconImageUri(), (Object)participant.getIconImageUri()) && zzz.equal((Object)participant2.getHiResImageUri(), (Object)participant.getHiResImageUri()) && zzz.equal((Object)participant2.getCapabilities(), (Object)participant.getCapabilities()) && zzz.equal((Object)((Object)participant2.getResult()), (Object)((Object)participant.getResult())) && zzz.equal((Object)participant2.getParticipantId(), (Object)participant.getParticipantId());
    }

    public String toString() {
        return ParticipantEntity.zzb(this);
    }

    static String zzb(Participant participant) {
        return zzz.zzx((Object)participant).zzg("ParticipantId", (Object)participant.getParticipantId()).zzg("Player", (Object)participant.getPlayer()).zzg("Status", (Object)participant.getStatus()).zzg("ClientAddress", (Object)participant.zzbjm()).zzg("ConnectedToRoom", (Object)participant.isConnectedToRoom()).zzg("DisplayName", (Object)participant.getDisplayName()).zzg("IconImage", (Object)participant.getIconImageUri()).zzg("IconImageUrl", (Object)participant.getIconImageUrl()).zzg("HiResImage", (Object)participant.getHiResImageUri()).zzg("HiResImageUrl", (Object)participant.getHiResImageUrl()).zzg("Capabilities", (Object)participant.getCapabilities()).zzg("Result", (Object)participant.getResult()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (!this.zzawa()) {
            ParticipantEntityCreator.zza(this, parcel, n);
        } else {
            parcel.writeString(this.ZU);
            parcel.writeString(this.jh);
            parcel.writeString(this.WQ == null ? null : this.WQ.toString());
            parcel.writeString(this.WR == null ? null : this.WR.toString());
            parcel.writeInt(this.zzbtt);
            parcel.writeString(this.YJ);
            parcel.writeInt(this.aeK ? 1 : 0);
            parcel.writeInt(this.Ye == null ? 0 : 1);
            if (this.Ye != null) {
                this.Ye.writeToParcel(parcel, n);
            }
        }
    }

    static final class ParticipantEntityCreatorCompat
    extends ParticipantEntityCreator {
        ParticipantEntityCreatorCompat() {
        }

        @Override
        public ParticipantEntity zzmg(Parcel parcel) {
            boolean bl = ParticipantEntity.zzf(ParticipantEntity.zzavz());
            if (bl || ParticipantEntity.zzhu((String)ParticipantEntity.class.getCanonicalName())) {
                return super.zzmg(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            String string4 = parcel.readString();
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            int n = parcel.readInt();
            String string5 = parcel.readString();
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            int n2 = 7;
            Object var14_14 = null;
            Object var15_15 = null;
            Object var16_16 = null;
            PlayerEntity playerEntity = bl3 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(3, string, string2, uri, uri2, n, string5, bl2, playerEntity, 7, null, null, null);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzmg(parcel);
        }
    }
}

